/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import java.net.URL;
import java.util.Optional;
import org.apache.james.jwt.CheckTokenClient;
import org.apache.james.jwt.DefaultCheckTokenClient;
import org.apache.james.jwt.JwksPublicKeyProvider;
import org.apache.james.jwt.JwtTokenVerifier;
import org.apache.james.jwt.PublicKeyProvider;
import org.apache.james.jwt.introspection.IntrospectionEndpoint;
import org.apache.james.jwt.introspection.TokenIntrospectionResponse;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class OidcJwtTokenVerifier {
    public static final CheckTokenClient CHECK_TOKEN_CLIENT = new DefaultCheckTokenClient();

    public static Optional<String> verifySignatureAndExtractClaim(String jwtToken, URL jwksURL, String claimName) {
        Optional<String> unverifiedClaim = OidcJwtTokenVerifier.getClaimWithoutSignatureVerification(jwtToken, "kid");
        PublicKeyProvider jwksPublicKeyProvider = unverifiedClaim.map(kidValue -> JwksPublicKeyProvider.of(jwksURL, kidValue)).orElse(JwksPublicKeyProvider.of(jwksURL));
        return new JwtTokenVerifier(jwksPublicKeyProvider).verifyAndExtractClaim(jwtToken, claimName, String.class);
    }

    public static <T> Optional<T> getClaimWithoutSignatureVerification(String token, String claimName) {
        int signatureIndex = token.lastIndexOf(46);
        if (signatureIndex <= 0) {
            return Optional.empty();
        }
        String nonSignedToken = token.substring(0, signatureIndex + 1);
        try {
            Jwt headerClaims = Jwts.parserBuilder().build().parseClaimsJwt(nonSignedToken);
            Object claim = headerClaims.getHeader().get((Object)claimName);
            if (claim == null) {
                return Optional.empty();
            }
            return Optional.of(claim);
        }
        catch (JwtException e) {
            return Optional.empty();
        }
    }

    public static Publisher<String> verifyWithIntrospection(String jwtToken, URL jwksURL, String claimName, IntrospectionEndpoint introspectionEndpoint) {
        return Mono.fromCallable(() -> OidcJwtTokenVerifier.verifySignatureAndExtractClaim(jwtToken, jwksURL, claimName)).flatMap(optional -> optional.map(Mono::just).orElseGet(Mono::empty)).flatMap(claimResult -> Mono.from(CHECK_TOKEN_CLIENT.introspect(introspectionEndpoint, jwtToken)).filter(TokenIntrospectionResponse::active).filter(tokenIntrospectionResponse -> tokenIntrospectionResponse.claimByPropertyName(claimName).map(claim -> claim.equals(claimResult)).orElse(false)).map(activeResponse -> claimResult));
    }

    public static Publisher<String> verifyWithUserinfo(String jwtToken, URL jwksURL, String claimName, URL userinfoEndpoint) {
        return Mono.fromCallable(() -> OidcJwtTokenVerifier.verifySignatureAndExtractClaim(jwtToken, jwksURL, claimName)).flatMap(optional -> optional.map(Mono::just).orElseGet(Mono::empty)).flatMap(claimResult -> Mono.from(CHECK_TOKEN_CLIENT.userInfo(userinfoEndpoint, jwtToken)).filter(userinfoResponse -> userinfoResponse.claimByPropertyName(claimName).map(claim -> claim.equals(claimResult)).orElse(false)).map(userinfoResponse -> claimResult));
    }
}

