/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.transport.mailets.jsieve.ResourceLocator;
import org.apache.james.transport.mailets.jsieve.delivery.SieveExecutor;
import org.apache.james.transport.mailets.jsieve.delivery.SievePoster;
import org.apache.james.user.api.UsersRepository;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class Sieve
extends GenericMailet {
    private final UsersRepository usersRepository;
    private final ResourceLocator resourceLocator;
    private SieveExecutor sieveExecutor;

    @Inject
    public Sieve(UsersRepository usersRepository, SieveRepository sieveRepository) {
        this(usersRepository, new ResourceLocator(sieveRepository, usersRepository));
    }

    public Sieve(UsersRepository usersRepository, ResourceLocator resourceLocator) {
        this.usersRepository = usersRepository;
        this.resourceLocator = resourceLocator;
    }

    public String getMailetInfo() {
        return "Sieve Mailet";
    }

    public void init() throws MessagingException {
        this.sieveExecutor = SieveExecutor.builder().resourceLocator(this.resourceLocator).mailetContext(this.getMailetContext()).sievePoster(new SievePoster(this.usersRepository, "INBOX")).build();
    }

    public void service(Mail mail) throws MessagingException {
        for (MailAddress recipient : mail.getRecipients()) {
            this.sieveExecutor.execute(recipient, mail);
        }
    }
}

