/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.backends.opensearch.AliasName;
import org.apache.james.backends.opensearch.IndexName;
import org.apache.james.backends.opensearch.OpenSearchConfiguration;
import org.apache.james.backends.opensearch.OpenSearchIndexer;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.backends.opensearch.RoutingKey;
import org.apache.james.events.EventListener;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.quota.search.QuotaSearcher;
import org.apache.james.quota.search.opensearch.OpenSearchQuotaConfiguration;
import org.apache.james.quota.search.opensearch.OpenSearchQuotaSearcher;
import org.apache.james.quota.search.opensearch.QuotaSearchIndexCreationUtil;
import org.apache.james.quota.search.opensearch.UserRoutingKeyFactory;
import org.apache.james.quota.search.opensearch.events.OpenSearchQuotaMailboxListener;
import org.apache.james.quota.search.opensearch.json.QuotaRatioToOpenSearchJson;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchQuotaSearcherModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSearchQuotaSearcherModule.class);

    protected void configure() {
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.ReactiveGroupEventListener.class).addBinding().to(OpenSearchQuotaMailboxListener.class);
    }

    @Provides
    @Singleton
    public QuotaSearcher provideSearcher(ReactorOpenSearchClient client, OpenSearchQuotaConfiguration configuration) {
        return new OpenSearchQuotaSearcher(client, configuration.getReadAliasQuotaRatioName());
    }

    @Provides
    @Singleton
    private OpenSearchQuotaConfiguration getOpenSearchQuotaConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration("opensearch");
            return OpenSearchQuotaConfiguration.fromProperties((Configuration)configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find opensearch configuration file. Providing a default OpenSearchQuotaConfiguration");
            return OpenSearchQuotaConfiguration.DEFAULT_CONFIGURATION;
        }
    }

    @Provides
    @Singleton
    public OpenSearchQuotaMailboxListener provideListener(ReactorOpenSearchClient client, OpenSearchQuotaConfiguration configuration, QuotaRootResolver quotaRootResolver) {
        return new OpenSearchQuotaMailboxListener(new OpenSearchIndexer(client, configuration.getWriteAliasQuotaRatioName()), new QuotaRatioToOpenSearchJson(quotaRootResolver), (RoutingKey.Factory)new UserRoutingKeyFactory(), quotaRootResolver);
    }

    @ProvidesIntoSet
    InitializationOperation createIndex(OpenSearchQuotaIndexCreator instance) {
        return InitilizationOperationBuilder.forClass(OpenSearchQuotaIndexCreator.class).init(instance::createIndex);
    }

    static class OpenSearchQuotaIndexCreator
    implements Startable {
        private final OpenSearchConfiguration configuration;
        private final OpenSearchQuotaConfiguration quotaConfiguration;
        private final ReactorOpenSearchClient client;

        @Inject
        OpenSearchQuotaIndexCreator(OpenSearchConfiguration configuration, OpenSearchQuotaConfiguration quotaConfiguration, ReactorOpenSearchClient client) {
            this.configuration = configuration;
            this.quotaConfiguration = quotaConfiguration;
            this.client = client;
        }

        void createIndex() throws IOException {
            QuotaSearchIndexCreationUtil.prepareClient((ReactorOpenSearchClient)this.client, (AliasName)this.quotaConfiguration.getReadAliasQuotaRatioName(), (AliasName)this.quotaConfiguration.getWriteAliasQuotaRatioName(), (IndexName)this.quotaConfiguration.getIndexQuotaRatioName(), (OpenSearchConfiguration)this.configuration);
        }
    }
}

