/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.modules;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import com.datastax.oss.driver.api.querybuilder.schema.compaction.CompactionStrategy;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.mailbox.cassandra.table.CassandraACLTable;
import org.apache.james.mailbox.cassandra.table.CassandraACLV2Table;
import org.apache.james.mailbox.cassandra.table.CassandraUserMailboxRightsTable;

public interface CassandraAclModule {
    public static final CassandraModule MODULE = CassandraModule.builder().table("acl").comment("Holds mailbox ACLs").options(options -> (CreateTableWithOptions)options.withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).statement(statement -> types -> statement.withPartitionKey(CassandraACLTable.ID, DataTypes.TIMEUUID).withColumn(CassandraACLTable.ACL, DataTypes.TEXT).withColumn(CassandraACLTable.VERSION, DataTypes.BIGINT)).table("aclv2").comment("Holds mailbox ACLs. This table do not rely on a JSON representation nor on LWT, contrary to the acl table it replaces.").options(options -> (CreateTableWithOptions)options.withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).statement(statement -> types -> statement.withPartitionKey(CassandraACLV2Table.ID, DataTypes.TIMEUUID).withClusteringColumn(CassandraACLV2Table.KEY, DataTypes.TEXT).withColumn(CassandraACLV2Table.RIGHTS, (DataType)DataTypes.setOf((DataType)DataTypes.TEXT))).table("UserMailboxACL").comment("Denormalisation table. Allow to retrieve non personal mailboxIds a user has right on").options(options -> (CreateTableWithOptions)((CreateTableWithOptions)options.withCompaction((CompactionStrategy)SchemaBuilder.leveledCompactionStrategy())).withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).statement(statement -> types -> statement.withPartitionKey(CassandraUserMailboxRightsTable.USER_NAME, DataTypes.TEXT).withClusteringColumn(CassandraUserMailboxRightsTable.MAILBOX_ID, DataTypes.TIMEUUID).withColumn(CassandraUserMailboxRightsTable.RIGHTS, DataTypes.TEXT)).build();
}

