/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public final class MailQueueName {
    private static final String PREFIX = "JamesMailQueue";
    private static final String EXCHANGE_PREFIX = "JamesMailQueue-exchange-";
    private static final String DEAD_LETTER_EXCHANGE_PREFIX = "JamesMailQueue-dead-letter-exchange-";
    private static final String DEAD_LETTER_QUEUE_PREFIX = "JamesMailQueue-dead-letter-queue-";
    @VisibleForTesting
    static final String WORKQUEUE_PREFIX = "JamesMailQueue-workqueue-";
    private final String name;

    public static MailQueueName fromString(String name) {
        Preconditions.checkNotNull((Object)name);
        return new MailQueueName(name);
    }

    static Optional<MailQueueName> fromRabbitWorkQueueName(String workQueueName) {
        return WorkQueueName.fromString(workQueueName).map(WorkQueueName::toMailQueueName);
    }

    private MailQueueName(String name) {
        this.name = name;
    }

    public String asString() {
        return this.name;
    }

    String toDeadLetterExchangeName() {
        return DEAD_LETTER_EXCHANGE_PREFIX + this.name;
    }

    String toDeadLetterQueueName() {
        return DEAD_LETTER_QUEUE_PREFIX + this.name;
    }

    ExchangeName toRabbitExchangeName() {
        return new ExchangeName(this.name);
    }

    WorkQueueName toWorkQueueName() {
        return new WorkQueueName(this.name);
    }

    org.apache.james.queue.api.MailQueueName toModel() {
        return org.apache.james.queue.api.MailQueueName.of((String)this.asString());
    }

    public final boolean equals(Object o) {
        if (o instanceof MailQueueName) {
            MailQueueName that = (MailQueueName)o;
            return Objects.equals(this.name, that.name);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    static class ExchangeName {
        private final String name;

        private ExchangeName(String name) {
            this.name = name;
        }

        String asString() {
            return MailQueueName.EXCHANGE_PREFIX + this.name;
        }

        public final boolean equals(Object o) {
            if (o instanceof ExchangeName) {
                ExchangeName that = (ExchangeName)o;
                return Objects.equals(this.name, that.name);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
        }
    }

    static class WorkQueueName {
        private final String name;

        static Optional<WorkQueueName> fromString(String name) {
            Preconditions.checkNotNull((Object)name);
            return Optional.of(name).filter(WorkQueueName::isJamesWorkQueueName).map(s -> s.substring(MailQueueName.WORKQUEUE_PREFIX.length())).map(WorkQueueName::new);
        }

        static boolean isJamesWorkQueueName(String name) {
            return name.startsWith(MailQueueName.WORKQUEUE_PREFIX);
        }

        private WorkQueueName(String name) {
            this.name = name;
        }

        String asString() {
            return MailQueueName.WORKQUEUE_PREFIX + this.name;
        }

        MailQueueName toMailQueueName() {
            return MailQueueName.fromString(this.name);
        }

        public final boolean equals(Object o) {
            if (o instanceof WorkQueueName) {
                WorkQueueName that = (WorkQueueName)o;
                return Objects.equals(this.name, that.name);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
        }
    }
}

