/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.utils.quotas;

import java.util.Optional;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.jmap.draft.model.Number;
import org.apache.james.jmap.draft.model.mailbox.Quotas;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.Quota;
import reactor.core.publisher.Mono;

public abstract class QuotaLoader {
    public abstract Mono<Quotas> getQuotas(MailboxPath var1);

    protected <T extends QuotaLimitValue<T>, U extends QuotaUsageValue<U, T>> Quotas.Value<T, U> quotaToValue(Quota<T, U> quota) {
        return new Quotas.Value(this.quotaValueUsageToNumber(quota.getUsed()), this.quotaLimitValueToOptionalNumber(quota.getLimit()));
    }

    protected Number quotaValueToNumber(QuotaLimitValue<?> value) {
        return Number.BOUND_SANITIZING_FACTORY.from(value.asLong());
    }

    protected Number quotaValueUsageToNumber(QuotaUsageValue<?, ?> value) {
        return Number.BOUND_SANITIZING_FACTORY.from(value.asLong());
    }

    protected Optional<Number> quotaLimitValueToOptionalNumber(QuotaLimitValue<?> value) {
        if (value.isUnlimited()) {
            return Optional.empty();
        }
        return Optional.of(this.quotaValueToNumber(value));
    }
}

