/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.AnnotationException;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.MailboxReactorUtils;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.util.FunctionalUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StoreMailboxAnnotationManager
implements MailboxAnnotationManager {
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final StoreRightManager rightManager;
    private final int limitOfAnnotations;
    private final int limitAnnotationSize;

    @Inject
    public StoreMailboxAnnotationManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, StoreRightManager rightManager) {
        this(mailboxSessionMapperFactory, rightManager, 10, 1024);
    }

    public StoreMailboxAnnotationManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, StoreRightManager rightManager, int limitOfAnnotations, int limitAnnotationSize) {
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.rightManager = rightManager;
        this.limitOfAnnotations = limitOfAnnotations;
        this.limitAnnotationSize = limitAnnotationSize;
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        return (List)MailboxReactorUtils.block(this.getAllAnnotationsReactive(mailboxPath, session).collectList());
    }

    public Flux<MailboxAnnotation> getAllAnnotationsReactive(MailboxPath mailboxPath, MailboxSession session) {
        AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(session);
        return this.checkThenGetMailboxId(mailboxPath, session).switchIfEmpty(Mono.error((Throwable)new MailboxNotFoundException(mailboxPath))).flatMapMany(mailboxId -> annotationMapper.executeReactive(Flux.from(annotationMapper.getAllAnnotationsReactive((MailboxId)mailboxId)).collectList()).flatMapIterable(Function.identity()));
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return (List)MailboxReactorUtils.block(this.getAnnotationsByKeysReactive(mailboxPath, session, keys).collectList());
    }

    public Flux<MailboxAnnotation> getAnnotationsByKeysReactive(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) {
        AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(session);
        return this.checkThenGetMailboxId(mailboxPath, session).switchIfEmpty(Mono.error((Throwable)new MailboxNotFoundException(mailboxPath))).flatMapMany(mailboxId -> annotationMapper.executeReactive(Flux.from(annotationMapper.getAnnotationsByKeysReactive((MailboxId)mailboxId, keys)).collectList()).flatMapIterable(Function.identity()));
    }

    public void updateAnnotations(MailboxPath mailboxPath, MailboxSession session, List<MailboxAnnotation> mailboxAnnotations) throws MailboxException {
        MailboxReactorUtils.block(this.updateAnnotationsReactive(mailboxPath, session, mailboxAnnotations));
    }

    public Mono<Void> updateAnnotationsReactive(MailboxPath mailboxPath, MailboxSession session, List<MailboxAnnotation> mailboxAnnotations) {
        AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(session);
        return annotationMapper.executeReactive(this.checkThenGetMailboxId(mailboxPath, session).switchIfEmpty(Mono.error((Throwable)new MailboxNotFoundException(mailboxPath))).flatMapMany(mailboxId -> Flux.fromIterable((Iterable)mailboxAnnotations).concatMap(annotation -> {
            if (annotation.isNil()) {
                return Mono.from(annotationMapper.deleteAnnotationReactive((MailboxId)mailboxId, annotation.getKey()));
            }
            return this.canInsertOrUpdate((MailboxId)mailboxId, (MailboxAnnotation)annotation, annotationMapper).filter(FunctionalUtils.identityPredicate()).flatMap(can -> Mono.from(annotationMapper.insertAnnotationReactive((MailboxId)mailboxId, (MailboxAnnotation)annotation)));
        })).then());
    }

    private Mono<Boolean> canInsertOrUpdate(MailboxId mailboxId, MailboxAnnotation annotation, AnnotationMapper annotationMapper) {
        return Mono.just((Object)(annotation.size() > this.limitAnnotationSize ? 1 : 0)).filter(FunctionalUtils.identityPredicate()).flatMap(limited -> Mono.error((Throwable)new AnnotationException("annotation too big."))).switchIfEmpty(this.annotationCountCanInsertOrUpdate(mailboxId, annotation, annotationMapper));
    }

    private Mono<Boolean> annotationCountCanInsertOrUpdate(MailboxId mailboxId, MailboxAnnotation annotation, AnnotationMapper annotationMapper) {
        return Mono.from(annotationMapper.existReactive(mailboxId, annotation)).filter(FunctionalUtils.identityPredicate().negate()).flatMap(exist -> Mono.from(annotationMapper.countAnnotationsReactive(mailboxId)).filter(count -> count >= this.limitOfAnnotations).flatMap(limited -> Mono.error((Throwable)new AnnotationException("too many annotations.")))).switchIfEmpty(Mono.just((Object)true));
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return (List)MailboxReactorUtils.block(this.getAnnotationsByKeysWithOneDepthReactive(mailboxPath, session, keys).collectList());
    }

    public Flux<MailboxAnnotation> getAnnotationsByKeysWithOneDepthReactive(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) {
        AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(session);
        return this.checkThenGetMailboxId(mailboxPath, session).switchIfEmpty(Mono.error((Throwable)new MailboxNotFoundException(mailboxPath))).flatMapMany(mailboxId -> annotationMapper.executeReactive(Flux.from(annotationMapper.getAnnotationsByKeysWithOneDepthReactive((MailboxId)mailboxId, keys)).collectList()).flatMapIterable(Function.identity()));
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) throws MailboxException {
        return (List)MailboxReactorUtils.block(this.getAnnotationsByKeysWithAllDepthReactive(mailboxPath, session, keys).collectList());
    }

    public Flux<MailboxAnnotation> getAnnotationsByKeysWithAllDepthReactive(MailboxPath mailboxPath, MailboxSession session, Set<MailboxAnnotationKey> keys) {
        AnnotationMapper annotationMapper = this.mailboxSessionMapperFactory.getAnnotationMapper(session);
        return this.checkThenGetMailboxId(mailboxPath, session).switchIfEmpty(Mono.error((Throwable)new MailboxNotFoundException(mailboxPath))).flatMapMany(mailboxId -> annotationMapper.executeReactive(Flux.from(annotationMapper.getAnnotationsByKeysWithAllDepthReactive((MailboxId)mailboxId, keys)).collectList()).flatMapIterable(Function.identity()));
    }

    private Mono<MailboxId> checkThenGetMailboxId(MailboxPath mailboxPath, MailboxSession session) {
        return this.mailboxSessionMapperFactory.getMailboxMapper(session).findMailboxByPath(mailboxPath).flatMap(mailbox -> Mono.from(this.rightManager.hasRightReactive(mailboxPath, MailboxACL.Right.Read, session)).filter(FunctionalUtils.identityPredicate().negate()).flatMap(hasRight -> Mono.error((Throwable)new InsufficientRightsException("Not enough rights on " + mailboxPath))).switchIfEmpty(Mono.just((Object)mailbox.getMailboxId())));
    }
}

