/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum TelephoneNumberComparisonPolicy {
    IGNORE_ALL_NON_NUMERIC_CHARACTERS,
    IGNORE_ONLY_SPACES_AND_DASHES;


    @NotNull
    public ASN1OctetString normalizeValue(@NotNull ASN1OctetString value) {
        String valueString = StaticUtils.toLowerCase(value.stringValue());
        ByteStringBuffer buffer = new ByteStringBuffer(valueString.length());
        block4: for (int i = 0; i < valueString.length(); ++i) {
            char c = valueString.charAt(i);
            switch (c) {
                case ' ': 
                case '-': {
                    continue block4;
                }
                case '+': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    buffer.append(c);
                    continue block4;
                }
                default: {
                    if (this != IGNORE_ONLY_SPACES_AND_DASHES) continue block4;
                    buffer.append(c);
                }
            }
        }
        return new ASN1OctetString(buffer.toByteArray());
    }
}

