/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogFieldSyntax;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LogField
implements Serializable {
    private static final long serialVersionUID = 6689083040240574632L;
    @NotNull
    private final LogFieldSyntax<?> expectedSyntax;
    @Nullable
    private final String constantName;
    @NotNull
    private final String fieldName;

    public LogField(@NotNull String fieldName, @NotNull LogFieldSyntax<?> expectedSyntax) {
        this(fieldName, null, expectedSyntax);
    }

    public LogField(@NotNull String fieldName, @Nullable String constantName, @NotNull LogFieldSyntax<?> expectedSyntax) {
        Validator.ensureNotNullOrEmpty(fieldName, "LogField.fieldName must not be null or empty.");
        Validator.ensureNotNullWithMessage(expectedSyntax, "LogField.expectedSyntax must not be null.");
        this.fieldName = fieldName;
        this.constantName = constantName;
        this.expectedSyntax = expectedSyntax;
    }

    @NotNull
    public String getFieldName() {
        return this.fieldName;
    }

    @Nullable
    @InternalUseOnly
    public String getConstantName() {
        return this.constantName;
    }

    @NotNull
    public LogFieldSyntax<?> getExpectedSyntax() {
        return this.expectedSyntax;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("LogField(fieldName='");
        buffer.append(this.fieldName);
        buffer.append("', ");
        if (this.constantName != null) {
            buffer.append("constantName='");
            buffer.append(this.constantName);
            buffer.append("', ");
        }
        buffer.append("expectedSyntax='");
        buffer.append(this.expectedSyntax.getSyntaxName());
        buffer.append("')");
    }
}

