/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.NamedSPILoader;

public abstract class KnnVectorsFormat
implements NamedSPILoader.NamedSPI {
    public static final int DEFAULT_MAX_DIMENSIONS = 1024;
    private final String name;
    public static final KnnVectorsFormat EMPTY = new KnnVectorsFormat("EMPTY"){

        @Override
        public KnnVectorsWriter fieldsWriter(SegmentWriteState state) {
            throw new UnsupportedOperationException("Attempt to write EMPTY vector values");
        }

        @Override
        public KnnVectorsReader fieldsReader(SegmentReadState state) {
            return new KnnVectorsReader(this){

                @Override
                public void checkIntegrity() {
                }

                @Override
                public FloatVectorValues getFloatVectorValues(String field) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ByteVectorValues getByteVectorValues(String field) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void search(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void search(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void close() {
                }
            };
        }

        @Override
        public int getMaxDimensions(String fieldName) {
            return 0;
        }
    };

    protected KnnVectorsFormat(String name) {
        NamedSPILoader.checkServiceName(name);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static void reloadKnnVectorsFormat(ClassLoader classloader) {
        Holder.getLoader().reload(classloader);
    }

    public static KnnVectorsFormat forName(String name) {
        return Holder.getLoader().lookup(name);
    }

    public static Set<String> availableKnnVectorsFormats() {
        return Holder.getLoader().availableServices();
    }

    public abstract KnnVectorsWriter fieldsWriter(SegmentWriteState var1) throws IOException;

    public abstract KnnVectorsReader fieldsReader(SegmentReadState var1) throws IOException;

    public abstract int getMaxDimensions(String var1);

    private static final class Holder {
        private static final NamedSPILoader<KnnVectorsFormat> LOADER = new NamedSPILoader<KnnVectorsFormat>(KnnVectorsFormat.class);

        private Holder() {
        }

        static NamedSPILoader<KnnVectorsFormat> getLoader() {
            if (LOADER == null) {
                throw new IllegalStateException("You tried to lookup a KnnVectorsFormat name before all formats could be initialized. This likely happens if you call KnnVectorsFormat#forName from a KnnVectorsFormat's ctor.");
            }
            return LOADER;
        }
    }
}

