/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers.utils;

import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.james.core.MailAddress;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeWalk {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeWalk.class);
    protected static final String UNZIP_REQUEST_PARAMETER = "-z";
    protected static final String DEBUG_REQUEST_PARAMETER = "-d";
    private final Configuration configuration;
    private final PartMatch partMatch;

    public static String cleanString(String fileName) {
        return DecoderUtil.decodeEncodedWords((String)fileName.toLowerCase(Locale.US).trim(), (DecodeMonitor)DecodeMonitor.SILENT);
    }

    public MimeWalk(Configuration configuration, PartMatch partMatch) {
        this.configuration = configuration;
        this.partMatch = partMatch;
    }

    public Collection<MailAddress> matchMail(Mail mail) throws MessagingException {
        try {
            MimeMessage message = mail.getMessage();
            if (this.matchFound((Part)message)) {
                return mail.getRecipients();
            }
            return null;
        }
        catch (Exception e) {
            if (this.configuration.isDebug()) {
                LOGGER.debug("Malformed message", (Throwable)e);
            }
            throw new MessagingException("Malformed message", e);
        }
    }

    protected boolean matchFound(Part part) throws Exception {
        Object content;
        if (part.getContentType() == null || part.getContentType().startsWith("multipart/alternative")) {
            return false;
        }
        try {
            content = part.getContent();
        }
        catch (UnsupportedEncodingException uee) {
            return false;
        }
        MessagingException anException = null;
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            for (int i = 0; i < multipart.getCount(); ++i) {
                try {
                    BodyPart bodyPart = multipart.getBodyPart(i);
                    if (!this.matchFound((Part)bodyPart)) continue;
                    return true;
                }
                catch (MessagingException e) {
                    anException = e;
                }
            }
        } else if (this.partMatch.partMatch(part)) {
            return true;
        }
        if (anException != null) {
            throw anException;
        }
        return false;
    }

    public record Configuration(Mask[] masks, boolean isDebug, boolean unzipIsRequested) {
        public static Configuration DEFAULT = new Configuration(null, false, false);

        public static Configuration parse(String condition) {
            StringTokenizer st = new StringTokenizer(condition, ", ", false);
            ArrayList<Mask> theMasks = new ArrayList<Mask>(20);
            boolean unzipIsRequested = false;
            boolean isDebug = false;
            while (st.hasMoreTokens()) {
                String fileName = st.nextToken();
                if (theMasks.isEmpty() && fileName.equalsIgnoreCase(MimeWalk.UNZIP_REQUEST_PARAMETER)) {
                    unzipIsRequested = true;
                    LOGGER.info("zip file analysis requested");
                    continue;
                }
                if (theMasks.isEmpty() && fileName.equalsIgnoreCase(MimeWalk.DEBUG_REQUEST_PARAMETER)) {
                    isDebug = true;
                    LOGGER.info("debug requested");
                    continue;
                }
                Mask mask = new Mask();
                if (fileName.startsWith("*")) {
                    mask.suffixMatch = true;
                    mask.matchString = fileName.substring(1);
                } else {
                    mask.suffixMatch = false;
                    mask.matchString = fileName;
                }
                mask.matchString = MimeWalk.cleanString(mask.matchString);
                theMasks.add(mask);
            }
            return new Configuration((Mask[])theMasks.toArray(Mask[]::new), isDebug, unzipIsRequested);
        }
    }

    @FunctionalInterface
    public static interface PartMatch {
        public boolean partMatch(Part var1) throws MessagingException, IOException;
    }

    public static class Mask {
        private boolean suffixMatch;
        private String matchString;

        public boolean match(String fileName) {
            if (this.suffixMatch) {
                return fileName.endsWith(this.matchString);
            }
            return fileName.equals(this.matchString);
        }

        public String getMatchString() {
            return this.matchString;
        }
    }
}

