/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.function.ARQFunctions;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.function.FunctionFactoryAuto;
import org.apache.jena.sparql.function.StandardFunctions;
import org.apache.jena.sparql.function.library.cdt.CDTLiteralFunctions;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.MappedLoader;
import org.apache.jena.sys.JenaSystem;

public class FunctionRegistry {
    private Map<String, FunctionFactory> registry = new ConcurrentHashMap<String, FunctionFactory>();
    private Set<String> attemptedLoads = ConcurrentHashMap.newKeySet();

    public static FunctionRegistry standardRegistry() {
        FunctionRegistry reg = FunctionRegistry.get(ARQ.getContext());
        return reg;
    }

    public static void init() {
        FunctionRegistry reg = new FunctionRegistry();
        StandardFunctions.loadStdDefs(reg);
        StandardFunctions.loadOtherDefs(reg);
        ARQFunctions.load(reg);
        CDTLiteralFunctions.register(reg);
        FunctionRegistry.set(ARQ.getContext(), reg);
    }

    public static FunctionRegistry get() {
        FunctionRegistry reg = FunctionRegistry.get(ARQ.getContext());
        if (reg == null) {
            Log.warn(FunctionRegistry.class, (String)"Standard function registry should already have been initialized");
            FunctionRegistry.init();
            reg = FunctionRegistry.get(ARQ.getContext());
        }
        return reg;
    }

    public static FunctionRegistry get(Context context2) {
        if (context2 == null) {
            return null;
        }
        return (FunctionRegistry)context2.get(ARQConstants.registryFunctions);
    }

    public static void set(Context context2, FunctionRegistry reg) {
        context2.set(ARQConstants.registryFunctions, reg);
    }

    public static FunctionRegistry createFrom(FunctionRegistry from) {
        FunctionRegistry res = new FunctionRegistry();
        if (from != null) {
            res.registry.putAll(from.registry);
        }
        return res;
    }

    public FunctionRegistry put(String uri, Class<?> funcClass) {
        if (!Function.class.isAssignableFrom(funcClass)) {
            Log.warn((Object)this, (String)("Class " + funcClass.getName() + " is not a Function"));
            return this;
        }
        return this.put(uri, new FunctionFactoryAuto(funcClass));
    }

    public FunctionRegistry put(String uri, FunctionFactory f) {
        this.registry.put(uri, f);
        return this;
    }

    @Deprecated(forRemoval=true)
    public FunctionFactory get(String uri) {
        return this.getFunctionFactory(uri);
    }

    public FunctionFactory getFunctionFactory(String uri) {
        FunctionFactory function = this.registry.get(uri);
        if (function != null) {
            return function;
        }
        if (this.attemptedLoads.contains(uri)) {
            return null;
        }
        Class<?> functionClass = MappedLoader.loadClass(uri, Function.class);
        if (functionClass == null) {
            return null;
        }
        this.put(uri, functionClass);
        this.attemptedLoads.add(uri);
        return this.registry.get(uri);
    }

    public Function getFunction(String uri) {
        FunctionFactory ff = this.get(uri);
        if (ff == null) {
            return null;
        }
        return ff.create(uri);
    }

    public boolean isRegistered(String uri) {
        return this.registry.containsKey(uri);
    }

    public void remove(String uri) {
        this.registry.remove(uri);
    }

    public Iterator<String> keys() {
        return this.registry.keySet().iterator();
    }

    static {
        JenaSystem.init();
    }
}

