/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterBuilder;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.WriterDatasetRIOTFactory;
import org.apache.jena.riot.WriterGraphRIOT;
import org.apache.jena.riot.WriterGraphRIOTFactory;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;

public class RDFWriter {
    private static int BUF_SIZE = 131072;
    private final DatasetGraph dataset;
    private final Graph graph;
    private final RDFFormat format;
    private final String baseURI;
    private final Context context;

    public static RDFWriterBuilder create() {
        return RDFWriterBuilder.create();
    }

    public static RDFWriterBuilder source(Graph graph) {
        return RDFWriter.create().source(graph);
    }

    public static RDFWriterBuilder source(Model model) {
        return RDFWriter.create().source(model);
    }

    public static RDFWriterBuilder source(DatasetGraph dataset) {
        return RDFWriter.create().source(dataset);
    }

    public static RDFWriterBuilder source(Dataset dataset) {
        return RDFWriter.create().source(dataset);
    }

    RDFWriter(DatasetGraph dataset, Graph graph, RDFFormat format, Lang lang, String baseURI, Context context2) {
        this.dataset = dataset;
        this.graph = graph;
        this.format = RDFWriter.chooseFormat(format, lang);
        this.baseURI = baseURI;
        this.context = context2;
    }

    private static RDFFormat chooseFormat(RDFFormat format, Lang lang) {
        if (format != null) {
            return format;
        }
        if (lang == null) {
            return null;
        }
        format = RDFWriterRegistry.defaultSerialization(lang);
        return format;
    }

    public String asString() {
        String string;
        if (this.format == null) {
            throw new RiotException("Output as a string needs the Lang/Format specificied");
        }
        StringWriter sw = new StringWriter();
        try {
            this.output(sw, this.format);
            string = sw.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    sw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                IO.exception(ex);
                return null;
            }
        }
        sw.close();
        return string;
    }

    public String toString() {
        return this.asString();
    }

    public void output(OutputStream output) {
        this.output(output, this.format);
    }

    @Deprecated
    public void output(Writer javaWriter) {
        this.output(javaWriter, this.format);
    }

    public void output(StringWriter javaWriter) {
        this.output(javaWriter, this.format);
    }

    public void output(String filename) {
        Objects.requireNonNull(filename, "Null filename");
        RDFFormat fmt = this.format;
        if (fmt == null) {
            ContentType ct = RDFLanguages.guessContentType(filename);
            if (ct == null) {
                throw new RiotException("Lang and RDFformat unset and can't determine syntax from '" + filename + "'");
            }
            Lang lang = RDFLanguages.contentTypeToLang(ct);
            if (lang == null) {
                throw new RiotException("No syntax registered for '" + ct.getContentTypeStr() + "'");
            }
            fmt = RDFWriterRegistry.defaultSerialization(lang);
        }
        if (filename.equals("-")) {
            this.output(System.out, fmt);
            return;
        }
        Path p = Path.of(filename, new String[0]);
        try (OutputStream out1 = Files.newOutputStream(p, new OpenOption[0]);
             BufferedOutputStream out = new BufferedOutputStream(out1, BUF_SIZE);){
            this.output(out, fmt);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    private void output(OutputStream output, RDFFormat format) {
        if (format == null) {
            throw new RiotException("No syntax (Lang or RDFFormat) for output");
        }
        if (this.graph != null) {
            this.write$(output, this.graph, format);
            return;
        }
        if (this.dataset != null) {
            this.write$(output, this.dataset, format);
            return;
        }
        throw new RiotException("No graph or dataset to write");
    }

    private void output(Writer javaWriter, RDFFormat format) {
        if (format == null) {
            throw new RiotException("No syntax (Lang or RDFFormat) for output");
        }
        if (this.graph != null) {
            this.write$(javaWriter, this.graph, format);
            return;
        }
        if (this.dataset != null) {
            this.write$(javaWriter, this.dataset, format);
            return;
        }
        throw new RiotException("No graph or dataset to write");
    }

    private static WriterGraphRIOT createGraphWriter$(RDFFormat serialization) {
        WriterGraphRIOTFactory wf = RDFWriterRegistry.getWriterGraphFactory(serialization);
        if (wf == null) {
            throw new RiotException("No graph writer for " + String.valueOf(serialization));
        }
        return wf.create(serialization);
    }

    private static WriterDatasetRIOT createDatasetWriter$(RDFFormat serialization) {
        WriterDatasetRIOTFactory wf = RDFWriterRegistry.getWriterDatasetFactory(serialization);
        if (wf == null) {
            throw new RiotException("No dataset writer for " + String.valueOf(serialization));
        }
        return wf.create(serialization);
    }

    private void write$(OutputStream out, Graph graph, RDFFormat serialization) {
        WriterGraphRIOT w = RDFWriter.createGraphWriter$(serialization);
        w.write(out, graph, RDFWriter.prefixMap(graph), this.baseURI, this.context);
    }

    private void write$(OutputStream out, DatasetGraph dataset, RDFFormat serialization) {
        WriterDatasetRIOT w = RDFWriter.createDatasetWriter$(serialization);
        w.write(out, dataset, this.prefixMap(dataset), this.baseURI, this.context);
    }

    private void write$(Writer out, Graph graph, RDFFormat serialization) {
        WriterGraphRIOT w = RDFWriter.createGraphWriter$(serialization);
        w.write(out, graph, RDFWriter.prefixMap(graph), this.baseURI, this.context);
    }

    private void write$(Writer out, DatasetGraph dataset, RDFFormat serialization) {
        WriterDatasetRIOT w = RDFWriter.createDatasetWriter$(serialization);
        w.write(out, dataset, this.prefixMap(dataset), this.baseURI, this.context);
    }

    private PrefixMap prefixMap(DatasetGraph dataset) {
        return PrefixMapFactory.createForOutput(dataset.prefixes());
    }

    private static PrefixMap prefixMap(Graph graph) {
        return PrefixMapFactory.createForOutput(graph.getPrefixMapping());
    }
}

