/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.model.snapshots;

import io.prometheus.metrics.config.EscapingScheme;
import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import io.prometheus.metrics.model.snapshots.Exemplar;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.SnapshotEscaper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class UnknownSnapshot
extends MetricSnapshot {
    public UnknownSnapshot(MetricMetadata metadata, Collection<UnknownDataPointSnapshot> data) {
        this(metadata, data, false);
    }

    private UnknownSnapshot(MetricMetadata metadata, Collection<UnknownDataPointSnapshot> data, boolean internal) {
        super(metadata, data, internal);
    }

    public List<UnknownDataPointSnapshot> getDataPoints() {
        return this.dataPoints;
    }

    @Override
    MetricSnapshot escape(EscapingScheme escapingScheme, List<? extends DataPointSnapshot> dataPointSnapshots) {
        return new UnknownSnapshot(this.getMetadata().escape(escapingScheme), (Collection<UnknownDataPointSnapshot>)dataPointSnapshots, true);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends MetricSnapshot.Builder<Builder> {
        private final List<UnknownDataPointSnapshot> dataPoints = new ArrayList<UnknownDataPointSnapshot>();

        private Builder() {
        }

        public Builder dataPoint(UnknownDataPointSnapshot data) {
            this.dataPoints.add(data);
            return this;
        }

        @Override
        public UnknownSnapshot build() {
            return new UnknownSnapshot(this.buildMetadata(), this.dataPoints);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static final class UnknownDataPointSnapshot
    extends DataPointSnapshot {
        private final double value;
        @Nullable
        private final Exemplar exemplar;

        public UnknownDataPointSnapshot(double value, Labels labels, @Nullable Exemplar exemplar) {
            this(value, labels, exemplar, 0L);
        }

        public UnknownDataPointSnapshot(double value, Labels labels, @Nullable Exemplar exemplar, long scrapeTimestampMillis) {
            this(value, labels, exemplar, scrapeTimestampMillis, false);
        }

        private UnknownDataPointSnapshot(double value, Labels labels, @Nullable Exemplar exemplar, long scrapeTimestampMillis, boolean internal) {
            super(labels, 0L, scrapeTimestampMillis, internal);
            this.value = value;
            this.exemplar = exemplar;
        }

        public double getValue() {
            return this.value;
        }

        @Nullable
        public Exemplar getExemplar() {
            return this.exemplar;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Override
        DataPointSnapshot escape(EscapingScheme escapingScheme) {
            return new UnknownDataPointSnapshot(this.value, SnapshotEscaper.escapeLabels(this.getLabels(), escapingScheme), SnapshotEscaper.escapeExemplar(this.exemplar, escapingScheme), this.getScrapeTimestampMillis(), true);
        }

        public static class Builder
        extends DataPointSnapshot.Builder<Builder> {
            @Nullable
            private Exemplar exemplar = null;
            @Nullable
            private Double value = null;

            private Builder() {
            }

            public Builder value(double value) {
                this.value = value;
                return this;
            }

            public Builder exemplar(@Nullable Exemplar exemplar) {
                this.exemplar = exemplar;
                return this;
            }

            public UnknownDataPointSnapshot build() {
                if (this.value == null) {
                    throw new IllegalArgumentException("Missing required field: value is null.");
                }
                return new UnknownDataPointSnapshot(this.value, this.labels, this.exemplar, this.scrapeTimestampMillis);
            }

            @Override
            protected Builder self() {
                return this;
            }
        }
    }
}

