/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.filter_functions;

import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.geosparql.implementation.index.GeometryLiteralIndex;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase2;
import org.apache.jena.sparql.util.FmtUtils;

public class TransformDatatypeFF
extends FunctionBase2 {
    @Override
    public NodeValue exec(NodeValue v1, NodeValue v2) {
        try {
            if (!v2.isIRI() && !v2.isString()) {
                throw new ExprEvalException("Not a URI: " + FmtUtils.stringForNode(v2.asNode()));
            }
            String datatypeURI = v2.isIRI() ? v2.asNode().getURI() : v2.asString();
            GeometryWrapper geometry = GeometryWrapper.extract(v1, GeometryLiteralIndex.GeometryIndex.PRIMARY);
            Literal convertedGeom = geometry.asLiteral(datatypeURI);
            return NodeValue.makeNode(convertedGeom.getLexicalForm(), convertedGeom.getDatatype());
        }
        catch (DatatypeFormatException ex) {
            throw new ExprEvalException(ex.getMessage(), ex);
        }
    }
}

