/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.analyzer;

import org.apache.jena.query.text.analyzer.Util;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultilingualAnalyzer
extends DelegatingAnalyzerWrapper {
    private static Logger log = LoggerFactory.getLogger(MultilingualAnalyzer.class);
    private Analyzer defaultAnalyzer;

    public MultilingualAnalyzer(Analyzer defaultAnalyzer) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.defaultAnalyzer = defaultAnalyzer;
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        int idx = fieldName.lastIndexOf("_");
        if (idx == -1) {
            return this.defaultAnalyzer;
        }
        String lang = fieldName.substring(idx + 1);
        Analyzer analyzer = Util.getLocalizedAnalyzer(lang);
        analyzer = analyzer != null ? analyzer : this.defaultAnalyzer;
        log.trace("getWrappedAnalyzer {}", (Object)analyzer);
        return analyzer;
    }

    public String toString() {
        return "MultilingualAnalyzer(default=" + String.valueOf(this.defaultAnalyzer) + ")";
    }
}

