/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.facet.MultiLongValues;
import org.apache.lucene.facet.MultiLongValuesSource;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public final class LongRange
extends Range {
    public final long min;
    public final long max;

    public LongRange(String label, long minIn, boolean minInclusive, long maxIn, boolean maxInclusive) {
        super(label);
        if (!minInclusive) {
            if (minIn != Long.MAX_VALUE) {
                ++minIn;
            } else {
                this.failNoMatch();
            }
        }
        if (!maxInclusive) {
            if (maxIn != Long.MIN_VALUE) {
                --maxIn;
            } else {
                this.failNoMatch();
            }
        }
        if (minIn > maxIn) {
            this.failNoMatch();
        }
        this.min = minIn;
        this.max = maxIn;
    }

    public boolean accept(long value) {
        return value >= this.min && value <= this.max;
    }

    public String toString() {
        return "LongRange(" + this.label + ": " + this.min + " to " + this.max + ")";
    }

    public boolean equals(Object _that) {
        if (!(_that instanceof LongRange)) {
            return false;
        }
        LongRange that = (LongRange)_that;
        return that.label.equals(this.label) && that.min == this.min && that.max == this.max;
    }

    public int hashCode() {
        return Objects.hash(this.label, this.min, this.max);
    }

    public Query getQuery(Query fastMatchQuery, LongValuesSource valueSource) {
        return new ValueSourceQuery(this, fastMatchQuery, valueSource);
    }

    public Query getQuery(Query fastMatchQuery, MultiLongValuesSource valuesSource) {
        LongValuesSource singleValues = MultiLongValuesSource.unwrapSingleton(valuesSource);
        if (singleValues != null) {
            return new ValueSourceQuery(this, fastMatchQuery, singleValues);
        }
        return new MultiValueSourceQuery(this, fastMatchQuery, valuesSource);
    }

    private static class ValueSourceQuery
    extends Query {
        private final LongRange range;
        private final Query fastMatchQuery;
        private final LongValuesSource valueSource;

        ValueSourceQuery(LongRange range, Query fastMatchQuery, LongValuesSource valueSource) {
            this.range = range;
            this.fastMatchQuery = fastMatchQuery;
            this.valueSource = valueSource;
        }

        @Override
        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((ValueSourceQuery)this.getClass().cast(other));
        }

        private boolean equalsTo(ValueSourceQuery other) {
            return this.range.equals(other.range) && Objects.equals(this.fastMatchQuery, other.fastMatchQuery) && this.valueSource.equals(other.valueSource);
        }

        @Override
        public int hashCode() {
            return this.classHash() + 31 * Objects.hash(this.range, this.fastMatchQuery, this.valueSource);
        }

        @Override
        public String toString(String field) {
            return "Filter(" + this.range.toString() + ")";
        }

        @Override
        public void visit(QueryVisitor visitor) {
            visitor.visitLeaf(this);
        }

        @Override
        public Query rewrite(IndexSearcher indexSearcher) throws IOException {
            Query fastMatchRewritten;
            if (this.fastMatchQuery != null && (fastMatchRewritten = this.fastMatchQuery.rewrite(indexSearcher)) != this.fastMatchQuery) {
                return new ValueSourceQuery(this.range, fastMatchRewritten, this.valueSource);
            }
            return super.rewrite(indexSearcher);
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            final Weight fastMatchWeight = this.fastMatchQuery == null ? null : searcher.createWeight(this.fastMatchQuery, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            return new ConstantScoreWeight(this, boost){

                @Override
                public ScorerSupplier scorerSupplier(LeafReaderContext context2) throws IOException {
                    DocIdSetIterator approximation;
                    int maxDoc = context2.reader().maxDoc();
                    if (fastMatchWeight == null) {
                        approximation = DocIdSetIterator.all(maxDoc);
                    } else {
                        Scorer s = fastMatchWeight.scorer(context2);
                        if (s == null) {
                            return null;
                        }
                        approximation = s.iterator();
                    }
                    final LongValues values = valueSource.getValues(context2, null);
                    TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                        @Override
                        public boolean matches() throws IOException {
                            return values.advanceExact(this.approximation.docID()) && range.accept(values.longValue());
                        }

                        @Override
                        public float matchCost() {
                            return 100.0f;
                        }
                    };
                    ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, twoPhase);
                    return new Weight.DefaultScorerSupplier(scorer);
                }

                @Override
                public boolean isCacheable(LeafReaderContext ctx) {
                    return valueSource.isCacheable(ctx);
                }
            };
        }
    }

    private static class MultiValueSourceQuery
    extends Query {
        private final LongRange range;
        private final Query fastMatchQuery;
        private final MultiLongValuesSource valuesSource;

        MultiValueSourceQuery(LongRange range, Query fastMatchQuery, MultiLongValuesSource valuesSource) {
            this.range = range;
            this.fastMatchQuery = fastMatchQuery;
            this.valuesSource = valuesSource;
        }

        @Override
        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((MultiValueSourceQuery)this.getClass().cast(other));
        }

        private boolean equalsTo(MultiValueSourceQuery other) {
            return this.range.equals(other.range) && Objects.equals(this.fastMatchQuery, other.fastMatchQuery) && this.valuesSource.equals(other.valuesSource);
        }

        @Override
        public int hashCode() {
            return this.classHash() + 31 * Objects.hash(this.range, this.fastMatchQuery, this.valuesSource);
        }

        @Override
        public String toString(String field) {
            return "Filter(" + this.range.toString() + ")";
        }

        @Override
        public void visit(QueryVisitor visitor) {
            visitor.visitLeaf(this);
        }

        @Override
        public Query rewrite(IndexSearcher indexSearcher) throws IOException {
            Query fastMatchRewritten;
            if (this.fastMatchQuery != null && (fastMatchRewritten = this.fastMatchQuery.rewrite(indexSearcher)) != this.fastMatchQuery) {
                return new MultiValueSourceQuery(this.range, fastMatchRewritten, this.valuesSource);
            }
            return super.rewrite(indexSearcher);
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            final Weight fastMatchWeight = this.fastMatchQuery == null ? null : searcher.createWeight(this.fastMatchQuery, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            return new ConstantScoreWeight(this, boost){

                @Override
                public ScorerSupplier scorerSupplier(LeafReaderContext context2) throws IOException {
                    DocIdSetIterator approximation;
                    int maxDoc = context2.reader().maxDoc();
                    if (fastMatchWeight == null) {
                        approximation = DocIdSetIterator.all(maxDoc);
                    } else {
                        Scorer s = fastMatchWeight.scorer(context2);
                        if (s == null) {
                            return null;
                        }
                        approximation = s.iterator();
                    }
                    final MultiLongValues values = valuesSource.getValues(context2);
                    TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                        @Override
                        public boolean matches() throws IOException {
                            if (!values.advanceExact(this.approximation.docID())) {
                                return false;
                            }
                            int i = 0;
                            while ((long)i < values.getValueCount()) {
                                if (range.accept(values.nextValue())) {
                                    return true;
                                }
                                ++i;
                            }
                            return false;
                        }

                        @Override
                        public float matchCost() {
                            return 100.0f;
                        }
                    };
                    ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, twoPhase);
                    return new Weight.DefaultScorerSupplier(scorer);
                }

                @Override
                public boolean isCacheable(LeafReaderContext ctx) {
                    return valuesSource.isCacheable(ctx);
                }
            };
        }
    }
}

