/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.oapi;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.MediaType;
import org.apache.juneau.UriContext;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.lang.AsciiSet;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartDataType;
import org.apache.juneau.httppart.HttpPartFormat;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.swaps.TemporalCalendarSwap;
import org.apache.juneau.swaps.TemporalDateSwap;
import org.apache.juneau.swaps.TemporalSwap;
import org.apache.juneau.uon.UonSerializerSession;

public class OpenApiSerializerSession
extends UonSerializerSession {
    private static final BeanContext BC = BeanContext.DEFAULT;
    private static final ClassMeta<byte[]> CM_ByteArray = BC.getClassMeta(byte[].class);
    private static final ClassMeta<String[]> CM_StringArray = BC.getClassMeta(String[].class);
    private static final ClassMeta<Calendar> CM_Calendar = BC.getClassMeta(Calendar.class);
    private static final ClassMeta<Long> CM_Long = BC.getClassMeta(Long.class);
    private static final ClassMeta<Integer> CM_Integer = BC.getClassMeta(Integer.class);
    private static final ClassMeta<Double> CM_Double = BC.getClassMeta(Double.class);
    private static final ClassMeta<Float> CM_Float = BC.getClassMeta(Float.class);
    private static final ClassMeta<Boolean> CM_Boolean = BC.getClassMeta(Boolean.class);
    private static final HttpPartSchema DEFAULT_SCHEMA = HttpPartSchema.DEFAULT;
    private final OpenApiSerializer ctx;

    public static Builder create(OpenApiSerializer ctx) {
        return new Builder(ctx);
    }

    protected OpenApiSerializerSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String serialize(HttpPartType partType, HttpPartSchema schema, Object value) throws SerializeException, SchemaValidationException {
        void var4_11;
        HttpPartCollectionFormat cf;
        void var4_9;
        void var4_6;
        ObjectSwap swap;
        ClassMeta<Map<String, Object>> classMeta = this.getClassMetaForObject(value);
        if (classMeta == null) {
            ClassMeta<Object> classMeta2 = this.object();
        }
        if (Utils.nn(swap = var4_6.getSwap(this)) && !var4_6.isDateOrCalendarOrTemporal()) {
            value = this.swap(swap, value);
            ClassMeta<?> classMeta3 = swap.getSwapClassMeta(this);
            if (classMeta3.isObject()) {
                ClassMeta<Object> classMeta4 = this.getClassMetaForObject(value);
            }
        }
        schema = (HttpPartSchema)Utils.firstNonNull((Object[])new HttpPartSchema[]{schema, DEFAULT_SCHEMA});
        HttpPartDataType t = schema.getType((ClassMeta<?>)var4_9);
        HttpPartFormat f = schema.getFormat((ClassMeta<?>)var4_9);
        if (f == HttpPartFormat.NO_FORMAT) {
            f = this.ctx.getFormat();
        }
        if ((cf = schema.getCollectionFormat()) == HttpPartCollectionFormat.NO_COLLECTION_FORMAT) {
            cf = this.ctx.getCollectionFormat();
        }
        String out = null;
        schema.validateOutput(value, this.ctx.getBeanContext());
        if (var4_9.hasMutaterTo(schema.getParsedType()) || schema.getParsedType().hasMutaterFrom((ClassMeta<?>)var4_9)) {
            value = this.toType(value, schema.getParsedType());
            ClassMeta<?> classMeta5 = schema.getParsedType();
        }
        if (var4_11.isUri()) {
            value = this.getUriResolver().resolve(value);
            ClassMeta<String> classMeta6 = this.string();
        }
        if (Utils.nn((Object)value)) {
            if (t == HttpPartDataType.STRING) {
                if (f == HttpPartFormat.BYTE) {
                    out = StringUtils.base64Encode((byte[])this.toType(value, CM_ByteArray));
                } else if (f == HttpPartFormat.BINARY) {
                    out = StringUtils.toHex((byte[])this.toType(value, CM_ByteArray));
                } else if (f == HttpPartFormat.BINARY_SPACED) {
                    out = StringUtils.toSpacedHex((byte[])this.toType(value, CM_ByteArray));
                } else if (f == HttpPartFormat.DATE) {
                    try {
                        if (value instanceof Calendar) {
                            out = TemporalCalendarSwap.IsoDate.DEFAULT.swap((BeanSession)this, (Calendar)((Object)value));
                        }
                        if (value instanceof Date) {
                            out = TemporalDateSwap.IsoDate.DEFAULT.swap((BeanSession)this, (Date)((Object)value));
                        }
                        if (value instanceof Temporal) {
                            out = TemporalSwap.IsoDate.DEFAULT.swap((BeanSession)this, (Temporal)((Object)value));
                        }
                        out = value.toString();
                    }
                    catch (Exception e) {
                        throw new SerializeException(e);
                    }
                } else if (f == HttpPartFormat.DATE_TIME) {
                    try {
                        if (value instanceof Calendar) {
                            out = TemporalCalendarSwap.IsoInstant.DEFAULT.swap((BeanSession)this, (Calendar)((Object)value));
                        }
                        if (value instanceof Date) {
                            out = TemporalDateSwap.IsoInstant.DEFAULT.swap((BeanSession)this, (Date)((Object)value));
                        }
                        if (value instanceof Temporal) {
                            out = TemporalSwap.IsoInstant.DEFAULT.swap((BeanSession)this, (Temporal)((Object)value));
                        }
                        out = value.toString();
                    }
                    catch (Exception e) {
                        throw new SerializeException(e);
                    }
                } else {
                    out = f == HttpPartFormat.UON ? super.serialize(partType, schema, value) : this.toType(value, this.string());
                }
            } else if (t == HttpPartDataType.BOOLEAN) {
                out = Utils.s((Object)this.toType(value, CM_Boolean));
            } else if (t == HttpPartDataType.INTEGER) {
                out = f == HttpPartFormat.INT64 ? Utils.s((Object)this.toType(value, CM_Long)) : Utils.s((Object)this.toType(value, CM_Integer));
            } else if (t == HttpPartDataType.NUMBER) {
                out = f == HttpPartFormat.DOUBLE ? Utils.s((Object)this.toType(value, CM_Double)) : Utils.s((Object)this.toType(value, CM_Float));
            } else if (t == HttpPartDataType.ARRAY) {
                if (cf == HttpPartCollectionFormat.UONC) {
                    out = super.serialize(partType, null, this.toList(partType, (ClassMeta<?>)var4_13, value, schema));
                } else {
                    HttpPartSchema items = schema.getItems();
                    ClassMeta<Object> vt = this.getClassMetaForObject(value);
                    OapiStringBuilder sb = new OapiStringBuilder(cf);
                    if (var4_13.isArray()) {
                        for (int i = 0; i < Array.getLength(value); ++i) {
                            sb.append(this.serialize(partType, items, Array.get(value, i)));
                        }
                    } else if (var4_13.isCollection()) {
                        ((Collection)((Object)value)).forEach(x -> sb.append(this.serialize(partType, items, x)));
                    } else {
                        String[] ss;
                        if (!vt.hasMutaterTo(String[].class)) throw new SerializeException("Input is not a valid array type: " + String.valueOf(var4_13), new Object[0]);
                        for (String element : ss = this.toType(value, CM_StringArray)) {
                            sb.append(this.serialize(partType, items, element));
                        }
                    }
                    out = sb.toString();
                }
            } else if (t == HttpPartDataType.OBJECT) {
                if (cf == HttpPartCollectionFormat.UONC) {
                    if (schema.hasProperties() && var4_13.isMapOrBean()) {
                        value = this.toMap(partType, (ClassMeta<?>)var4_13, value, schema);
                    }
                    out = super.serialize(partType, null, value);
                } else if (var4_13.isBean()) {
                    OapiStringBuilder sb = new OapiStringBuilder(cf);
                    Predicate<Object> checkNull = x -> this.isKeepNullProperties() || Utils.nn((Object)x);
                    HttpPartSchema schema2 = schema;
                    this.toBeanMap(value).forEachValue(checkNull, (pMeta, key, val, thrown) -> {
                        if (thrown == null) {
                            sb.append(key, this.serialize(partType, schema2.getProperty((String)key), val));
                        }
                    });
                    out = sb.toString();
                } else {
                    if (!var4_13.isMap()) throw new SerializeException("Input is not a valid object type: " + String.valueOf(var4_13), new Object[0]);
                    OapiStringBuilder sb = new OapiStringBuilder(cf);
                    HttpPartSchema schema2 = schema;
                    value.forEach((k, v) -> sb.append(k, this.serialize(partType, schema2.getProperty(Utils.s((Object)k)), v)));
                    out = sb.toString();
                }
            } else {
                if (t == HttpPartDataType.FILE) {
                    throw new SerializeException("File part not supported.", new Object[0]);
                }
                if (t == HttpPartDataType.NO_TYPE) {
                    throw new SerializeException("Invalid type.", new Object[0]);
                }
            }
        }
        schema.validateInput(out);
        if (out == null) {
            out = schema.getDefault();
        }
        if (out != null) return out;
        return "null";
    }

    private List toList(HttpPartType partType, ClassMeta<?> type, Object o, HttpPartSchema s) throws SerializeException, SchemaValidationException {
        if (s == null) {
            s = DEFAULT_SCHEMA;
        }
        JsonList l = new JsonList();
        HttpPartSchema items = s.getItems();
        if (type.isArray()) {
            for (int i = 0; i < Array.getLength(o); ++i) {
                l.add(this.toObject(partType, Array.get(o, i), items));
            }
        } else if (type.isCollection()) {
            ((Collection)o).forEach(x -> l.add(this.toObject(partType, x, items)));
        } else {
            l.add(this.toObject(partType, o, items));
        }
        if (this.isSortCollections()) {
            return this.sort(l);
        }
        return l;
    }

    private Map<String, Object> toMap(HttpPartType partType, ClassMeta<?> type, Object o, HttpPartSchema s) throws SerializeException, SchemaValidationException {
        if (s == null) {
            s = DEFAULT_SCHEMA;
        }
        JsonMap m = new JsonMap();
        if (type.isBean()) {
            Predicate<Object> checkNull = x -> this.isKeepNullProperties() || Utils.nn((Object)x);
            HttpPartSchema s2 = s;
            this.toBeanMap(o).forEachValue(checkNull, (pMeta, key, val, thrown) -> {
                if (thrown == null) {
                    m.put((String)key, this.toObject(partType, val, s2.getProperty((String)key)));
                }
            });
        } else {
            HttpPartSchema s2 = s;
            ((Map)o).forEach((k, v) -> m.put(Utils.s((Object)k), this.toObject(partType, v, s2.getProperty(Utils.s((Object)k)))));
        }
        if (this.isSortMaps()) {
            return this.sort(m);
        }
        return m;
    }

    private Object toObject(HttpPartType partType, Object o, HttpPartSchema s) throws SerializeException, SchemaValidationException {
        if (o == null) {
            return null;
        }
        if (s == null) {
            s = DEFAULT_SCHEMA;
        }
        ClassMeta<Object> cm = this.getClassMetaForObject(o);
        HttpPartDataType t = s.getType(cm);
        HttpPartFormat f = s.getFormat(cm);
        HttpPartCollectionFormat cf = s.getCollectionFormat();
        if (t == HttpPartDataType.STRING) {
            if (f == HttpPartFormat.BYTE) {
                return StringUtils.base64Encode((byte[])this.toType(o, CM_ByteArray));
            }
            if (f == HttpPartFormat.BINARY) {
                return StringUtils.toHex((byte[])this.toType(o, CM_ByteArray));
            }
            if (f == HttpPartFormat.BINARY_SPACED) {
                return StringUtils.toSpacedHex((byte[])this.toType(o, CM_ByteArray));
            }
            if (f == HttpPartFormat.DATE) {
                return StringUtils.toIsoDate((Calendar)this.toType(o, CM_Calendar));
            }
            if (f == HttpPartFormat.DATE_TIME) {
                return StringUtils.toIsoDateTime((Calendar)this.toType(o, CM_Calendar));
            }
            return o;
        }
        if (t == HttpPartDataType.ARRAY) {
            List l = this.toList(partType, this.getClassMetaForObject(o), o, s);
            if (cf == HttpPartCollectionFormat.CSV) {
                return StringUtils.joine((List)l, (char)',');
            }
            if (cf == HttpPartCollectionFormat.PIPES) {
                return StringUtils.joine((List)l, (char)'|');
            }
            if (cf == HttpPartCollectionFormat.SSV) {
                return StringUtils.join((Collection)l, (char)' ');
            }
            if (cf == HttpPartCollectionFormat.TSV) {
                return StringUtils.join((Collection)l, (char)'\t');
            }
            return l;
        }
        if (t == HttpPartDataType.OBJECT) {
            return this.toMap(partType, this.getClassMetaForObject(o), o, s);
        }
        return o;
    }

    private <T> T toType(Object in, ClassMeta<T> type) throws SerializeException {
        try {
            return this.convertToType(in, type);
        }
        catch (InvalidDataConversionException e) {
            throw new SerializeException(e);
        }
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        try {
            out.getWriter().write(this.serialize(HttpPartType.BODY, this.getSchema(), o));
        }
        catch (SchemaValidationException e) {
            throw new SerializeException(e);
        }
    }

    public static class Builder
    extends UonSerializerSession.Builder {
        private OpenApiSerializer ctx;

        protected Builder(OpenApiSerializer ctx) {
            super(ctx);
            this.ctx = ctx;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public OpenApiSerializerSession build() {
            return new OpenApiSerializerSession(this);
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder resolver(VarResolverSession value) {
            super.resolver(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder useWhitespace(Boolean value) {
            super.useWhitespace(value);
            return this;
        }
    }

    private static class OapiStringBuilder {
        static final AsciiSet EQ = AsciiSet.of((String)"=\\");
        static final AsciiSet PIPE = AsciiSet.of((String)"|\\");
        static final AsciiSet PIPE_OR_EQ = AsciiSet.of((String)"|=\\");
        static final AsciiSet COMMA = AsciiSet.of((String)",\\");
        static final AsciiSet COMMA_OR_EQ = AsciiSet.of((String)",=\\");
        private final StringBuilder sb = new StringBuilder();
        private final HttpPartCollectionFormat cf;
        private boolean first = true;

        OapiStringBuilder(HttpPartCollectionFormat cf) {
            this.cf = cf;
        }

        public String toString() {
            return this.sb.toString();
        }

        private void delim(HttpPartCollectionFormat cf) {
            if (cf == HttpPartCollectionFormat.PIPES) {
                this.sb.append('|');
            } else if (cf == HttpPartCollectionFormat.SSV) {
                this.sb.append(' ');
            } else if (cf == HttpPartCollectionFormat.TSV) {
                this.sb.append('\t');
            } else {
                this.sb.append(',');
            }
        }

        OapiStringBuilder append(Object o) {
            if (!this.first) {
                this.delim(this.cf);
            }
            this.first = false;
            if (this.cf == HttpPartCollectionFormat.PIPES) {
                this.sb.append(StringUtils.escapeChars((String)Utils.s((Object)o), (AsciiSet)PIPE));
            } else if (this.cf == HttpPartCollectionFormat.SSV || this.cf == HttpPartCollectionFormat.TSV) {
                this.sb.append(Utils.s((Object)o));
            } else {
                this.sb.append(StringUtils.escapeChars((String)Utils.s((Object)o), (AsciiSet)COMMA));
            }
            return this;
        }

        OapiStringBuilder append(Object key, Object val) {
            if (!this.first) {
                this.delim(this.cf);
            }
            this.first = false;
            if (this.cf == HttpPartCollectionFormat.PIPES) {
                this.sb.append(StringUtils.escapeChars((String)Utils.s((Object)key), (AsciiSet)PIPE_OR_EQ)).append('=').append(StringUtils.escapeChars((String)Utils.s((Object)val), (AsciiSet)PIPE_OR_EQ));
            } else if (this.cf == HttpPartCollectionFormat.SSV || this.cf == HttpPartCollectionFormat.TSV) {
                this.sb.append(StringUtils.escapeChars((String)Utils.s((Object)key), (AsciiSet)EQ)).append('=').append(StringUtils.escapeChars((String)Utils.s((Object)val), (AsciiSet)EQ));
            } else {
                this.sb.append(StringUtils.escapeChars((String)Utils.s((Object)key), (AsciiSet)COMMA_OR_EQ)).append('=').append(StringUtils.escapeChars((String)Utils.s((Object)val), (AsciiSet)COMMA_OR_EQ));
            }
            return this;
        }
    }
}

