/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.rest.util.FinishableServletOutputStream;

public class MockServletResponse
implements HttpServletResponse {
    private String characterEncoding = "UTF-8";
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private int bufferSize;
    private Locale locale;
    private int sc;
    private String msg;
    private Map<String, String[]> headerMap = CollectionUtils.map();

    public static MockServletResponse create() {
        return new MockServletResponse();
    }

    public void addCookie(Cookie cookie) {
    }

    public void addDateHeader(String name, long date) {
        Instant instant = Instant.ofEpochMilli(date);
        DateTimeFormatter formatter = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneId.of("GMT"));
        this.headerMap.put(name, CollectionUtils.a(formatter.format(instant)));
    }

    public void addHeader(String name, String value) {
        this.headerMap.put(name, CollectionUtils.a(value));
    }

    public void addIntHeader(String name, int value) {
        this.headerMap.put(name, CollectionUtils.a(String.valueOf(value)));
    }

    public boolean containsHeader(String name) {
        return Utils.nn(this.getHeader(name));
    }

    public String encodeRedirectURL(String url) {
        return null;
    }

    public String encodeURL(String url) {
        return null;
    }

    public void flushBuffer() throws IOException {
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public String getHeader(String name) {
        String[] s = this.headerMap.get(name);
        return s == null || s.length == 0 ? null : s[0];
    }

    public Collection<String> getHeaderNames() {
        return this.headerMap.keySet();
    }

    public Collection<String> getHeaders(String name) {
        String[] s = this.headerMap.get(name);
        return s == null ? Collections.emptyList() : CollectionUtils.u(CollectionUtils.l(s));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getMessage() {
        return this.msg;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new FinishableServletOutputStream(this.baos);
    }

    public int getStatus() {
        return this.sc;
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.characterEncoding));
    }

    public MockServletResponse header(String name, String value) {
        this.setHeader(name, value);
        return this;
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void resetBuffer() {
    }

    public void sendError(int sc) throws IOException {
        this.sc = sc;
    }

    public void sendError(int sc, String msg) throws IOException {
        this.sc = sc;
        this.msg = msg;
    }

    public void sendRedirect(String location) throws IOException {
        this.sc = 302;
        this.headerMap.put("Location", CollectionUtils.a(location));
    }

    public void sendRedirect(String location, int sc, boolean clearBuffer) throws IOException {
        this.sc = sc;
        this.headerMap.put("Location", CollectionUtils.a(location));
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public void setCharacterEncoding(String charset) {
        this.characterEncoding = charset;
        this.updateContentTypeHeader();
    }

    public void setContentLength(int len) {
        this.header("Content-Length", String.valueOf(len));
    }

    public void setContentLengthLong(long len) {
        this.header("Content-Length", String.valueOf(len));
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
        this.updateContentTypeHeader();
    }

    public void setDateHeader(String name, long date) {
        Instant instant = Instant.ofEpochMilli(date);
        DateTimeFormatter formatter = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneId.of("GMT"));
        this.headerMap.put(name, CollectionUtils.a(formatter.format(instant)));
    }

    public void setHeader(String name, String value) {
        this.headerMap.put(name, CollectionUtils.a(value));
    }

    public void setIntHeader(String name, int value) {
        this.headerMap.put(name, CollectionUtils.a(String.valueOf(value)));
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public void setStatus(int sc) {
        this.sc = sc;
    }

    public MockServletResponse status(int value) {
        this.setStatus(value);
        return this;
    }

    private void updateContentTypeHeader() {
        Object contentType = this.getContentType();
        String charset = this.characterEncoding;
        if (Utils.nn(contentType) && Utils.nn(charset)) {
            if (((String)contentType).indexOf("charset=") != -1) {
                contentType = ((String)contentType).replaceAll("\\;\\s*charset=.*", "");
            }
            if (!"UTF-8".equalsIgnoreCase(charset)) {
                contentType = (String)contentType + ";charset=" + charset;
            }
            this.header("Content-Type", (String)contentType);
        }
    }

    byte[] getContent() throws IOException {
        this.baos.flush();
        return this.baos.toByteArray();
    }

    Map<String, String[]> getHeaders() {
        return this.headerMap;
    }
}

