/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.bean.openapi3.Example;
import org.apache.juneau.bean.openapi3.OpenApi;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.bean.openapi3.SchemaInfo;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class HeaderInfo
extends OpenApiElement {
    private String description;
    private String ref;
    private Boolean required;
    private Boolean explode;
    private Boolean deprecated;
    private Boolean allowEmptyValue;
    private Boolean allowReserved;
    private SchemaInfo schema;
    private Object example;
    private Map<String, Example> examples = CollectionUtils.map();

    public HeaderInfo() {
    }

    public HeaderInfo(HeaderInfo copyFrom) {
        super(copyFrom);
        this.description = copyFrom.description;
        this.example = copyFrom.example;
        this.allowEmptyValue = copyFrom.allowEmptyValue;
        this.schema = copyFrom.schema;
        this.allowReserved = copyFrom.allowReserved;
        this.required = copyFrom.required;
        this.ref = copyFrom.ref;
        this.explode = copyFrom.explode;
        this.deprecated = copyFrom.deprecated;
        if (Utils.nn(copyFrom.examples)) {
            this.examples.putAll(CollectionUtils.copyOf(copyFrom.examples, Example::copy));
        }
    }

    public HeaderInfo addExample(String name, Example example) {
        AssertionUtils.assertArgNotNull((String)"name", (Object)name);
        AssertionUtils.assertArgNotNull((String)"example", (Object)example);
        this.examples.put(name, example);
        return this;
    }

    public HeaderInfo copy() {
        return new HeaderInfo(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "description" -> ConverterUtils.toType((Object)this.getDescription(), type);
            case "required" -> ConverterUtils.toType((Object)this.getRequired(), type);
            case "explode" -> ConverterUtils.toType((Object)this.getExplode(), type);
            case "deprecated" -> ConverterUtils.toType((Object)this.getDeprecated(), type);
            case "allowEmptyValue" -> ConverterUtils.toType((Object)this.getAllowEmptyValue(), type);
            case "allowReserved" -> ConverterUtils.toType((Object)this.getAllowReserved(), type);
            case "$ref" -> ConverterUtils.toType((Object)this.getRef(), type);
            case "schema" -> ConverterUtils.toType((Object)this.getSchema(), type);
            case "x-example" -> ConverterUtils.toType((Object)this.getExample(), type);
            case "examples" -> ConverterUtils.toType(this.getExamples(), type);
            default -> super.get(property, type);
        });
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    @Beanp(value="x-example")
    public Object getExample() {
        return this.example;
    }

    public Map<String, Example> getExamples() {
        return Utils.nullIfEmpty(this.examples);
    }

    public Boolean getExplode() {
        return this.explode;
    }

    @Beanp(value="$ref")
    public String getRef() {
        return this.ref;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.nn((Object)this.ref), (Object)"$ref").addIf(Utils.nn((Object)this.allowEmptyValue), (Object)"allowEmptyValue").addIf(Utils.nn((Object)this.allowReserved), (Object)"allowReserved").addIf(Utils.nn((Object)this.deprecated), (Object)"deprecated").addIf(Utils.nn((Object)this.description), (Object)"description").addIf(Utils.ne(this.examples), (Object)"examples").addIf(Utils.nn((Object)this.explode), (Object)"explode").addIf(Utils.nn((Object)this.required), (Object)"required").addIf(Utils.nn((Object)this.schema), (Object)"schema").addIf(Utils.nn((Object)this.example), (Object)"x-example").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    public HeaderInfo resolveRefs(OpenApi openApi, Deque<String> refStack, int maxDepth) {
        if (Utils.nn((Object)this.ref)) {
            if (refStack.contains(this.ref) || refStack.size() >= maxDepth) {
                return this;
            }
            refStack.addLast(this.ref);
            HeaderInfo r = openApi.findRef(this.ref, HeaderInfo.class);
            r = r.resolveRefs(openApi, refStack, maxDepth);
            refStack.removeLast();
            return r;
        }
        return this;
    }

    @Override
    public HeaderInfo set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "$ref" -> this.setRef(Utils.s((Object)value));
            case "allowEmptyValue" -> this.setAllowEmptyValue(ConverterUtils.toBoolean((Object)value));
            case "allowReserved" -> this.setAllowReserved(ConverterUtils.toBoolean((Object)value));
            case "deprecated" -> this.setDeprecated(ConverterUtils.toBoolean((Object)value));
            case "description" -> this.setDescription(Utils.s((Object)value));
            case "examples" -> this.setExamples(ConverterUtils.toMapBuilder((Object)value, String.class, Example.class).sparse().build());
            case "explode" -> this.setExplode(ConverterUtils.toBoolean((Object)value));
            case "required" -> this.setRequired(ConverterUtils.toBoolean((Object)value));
            case "schema" -> this.setSchema((SchemaInfo)ConverterUtils.toType((Object)value, SchemaInfo.class));
            case "x-example" -> this.setExample(value);
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public HeaderInfo setAllowEmptyValue(Boolean value) {
        this.allowEmptyValue = value;
        return this;
    }

    public HeaderInfo setAllowReserved(Boolean value) {
        this.allowReserved = value;
        return this;
    }

    public HeaderInfo setDeprecated(Boolean value) {
        this.deprecated = value;
        return this;
    }

    public HeaderInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    @Beanp(value="x-example")
    public HeaderInfo setExample(Object value) {
        this.example = value;
        return this;
    }

    public HeaderInfo setExamples(Map<String, Example> value) {
        this.examples.clear();
        if (Utils.nn(value)) {
            this.examples.putAll(value);
        }
        return this;
    }

    public HeaderInfo setExplode(Boolean value) {
        this.explode = value;
        return this;
    }

    @Beanp(value="$ref")
    public HeaderInfo setRef(String value) {
        this.ref = value;
        return this;
    }

    public HeaderInfo setRequired(Boolean value) {
        this.required = value;
        return this;
    }

    public HeaderInfo setSchema(SchemaInfo value) {
        this.schema = value;
        return this;
    }

    @Override
    public HeaderInfo strict(Object value) {
        super.strict(value);
        return this;
    }

    @Override
    protected HeaderInfo strict() {
        super.strict();
        return this;
    }
}

