/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl.synccontext.named;

import java.util.Collection;
import java.util.Objects;
import java.util.TreeSet;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import shaded.org.eclipse.aether.metadata.Metadata;
import shaded.org.eclipse.aether.util.PathUtils;

public class GAVNameMapper
implements NameMapper {
    protected final boolean fileSystemFriendly;
    protected final String artifactPrefix;
    protected final String artifactSuffix;
    protected final String metadataPrefix;
    protected final String metadataSuffix;
    protected final String fieldSeparator;
    protected static final String MAVEN_METADATA = "maven-metadata.xml";

    public GAVNameMapper(boolean fileSystemFriendly, String artifactPrefix, String artifactSuffix, String metadataPrefix, String metadataSuffix, String fieldSeparator) {
        this.fileSystemFriendly = fileSystemFriendly;
        this.artifactPrefix = Objects.requireNonNull(artifactPrefix);
        this.artifactSuffix = Objects.requireNonNull(artifactSuffix);
        this.metadataPrefix = Objects.requireNonNull(metadataPrefix);
        this.metadataSuffix = Objects.requireNonNull(metadataSuffix);
        this.fieldSeparator = Objects.requireNonNull(fieldSeparator);
    }

    @Override
    public boolean isFileSystemFriendly() {
        return this.fileSystemFriendly;
    }

    @Override
    public Collection<String> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        TreeSet<String> keys = new TreeSet<String>();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                keys.add(this.getArtifactName(artifact));
            }
        }
        if (metadatas != null) {
            for (Metadata metadata : metadatas) {
                keys.add(this.getMetadataName(metadata));
            }
        }
        return keys;
    }

    protected String getArtifactName(Artifact artifact) {
        return this.artifactPrefix + artifact.getGroupId() + this.fieldSeparator + artifact.getArtifactId() + this.fieldSeparator + artifact.getBaseVersion() + this.artifactSuffix;
    }

    protected String getMetadataName(Metadata metadata) {
        String name = this.metadataPrefix;
        if (!metadata.getGroupId().isEmpty()) {
            name = name + metadata.getGroupId();
            if (!metadata.getArtifactId().isEmpty()) {
                name = name + this.fieldSeparator + metadata.getArtifactId();
                if (!metadata.getVersion().isEmpty()) {
                    name = name + this.fieldSeparator + metadata.getVersion();
                }
            }
            if (!MAVEN_METADATA.equals(metadata.getType())) {
                name = name + this.fieldSeparator + (this.fileSystemFriendly ? PathUtils.stringToPathSegment(metadata.getType()) : metadata.getType());
            }
        } else if (!MAVEN_METADATA.equals(metadata.getType())) {
            name = name + (this.fileSystemFriendly ? PathUtils.stringToPathSegment(metadata.getType()) : metadata.getType());
        }
        return name + this.metadataSuffix;
    }

    @Deprecated
    public static NameMapper gav() {
        return new GAVNameMapper(false, "artifact:", "", "metadata:", "", ":");
    }

    @Deprecated
    public static NameMapper fileGav() {
        return new GAVNameMapper(true, "artifact~", ".lock", "metadata~", ".lock", "~");
    }
}

