/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.nodemime;

import com.github.sommeri.less4j.core.problems.BugHappened;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class NodeMime {
    private static final String MIMETYPES_NODE_TYPES = "/mimetypes/node.types";
    private static final String MIMETYPES_MIME_TYPES = "/mimetypes/mime.types";
    private static final String FALLBACK_SUFFIX = "bin";
    private Map<String, String> typeDatabase = null;

    public String lookupMime(String path) {
        if (path == null) {
            return this.defaultType();
        }
        int indx = Math.max(Math.max(path.lastIndexOf("."), path.lastIndexOf("\\")), path.lastIndexOf("/"));
        String suffix = path.substring(indx + 1, path.length());
        return this.lookupBySuffix(suffix);
    }

    public String lookupCharset(String mimeType) {
        return this.lookupCharset(mimeType, null);
    }

    public String lookupCharset(String mimeType, String fallback) {
        if (mimeType == null) {
            return fallback;
        }
        return mimeType.startsWith("text") ? "UTF-8" : fallback;
    }

    private String lookupBySuffix(String suffix) {
        Map<String, String> typeDatabase = this.getTypeDatabase();
        String result = typeDatabase.get(suffix);
        return result != null ? result : this.defaultType();
    }

    private String defaultType() {
        return this.typeDatabase.get(FALLBACK_SUFFIX);
    }

    private Map<String, String> getTypeDatabase() {
        if (this.typeDatabase == null) {
            this.typeDatabase = new HashMap<String, String>();
            this.load(MIMETYPES_MIME_TYPES);
            this.load(MIMETYPES_NODE_TYPES);
        }
        return this.typeDatabase;
    }

    private void load(String path) {
        InputStream stream = path.getClass().getResourceAsStream(path);
        if (stream == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                this.loadLine(line);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new BugHappened(e, null);
        }
    }

    private void loadLine(String line) {
        String[] split = line.split("\\s+");
        String mimetype = split[0];
        for (int i = 1; i < split.length; ++i) {
            String suffix = split[i];
            this.typeDatabase.put(suffix, mimetype);
        }
    }

    public boolean isText(String mimetype) {
        if (mimetype == null) {
            return false;
        }
        return mimetype.contains("text");
    }
}

