/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.logging;

import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectExecutionEvent;
import org.apache.maven.execution.ProjectExecutionListener;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.apache.maven.logging.BuildEventListener;
import org.apache.maven.logging.ProjectBuildLogAppender;

public class LoggingExecutionListener
implements ExecutionListener,
ProjectExecutionListener {
    private final ExecutionListener delegate;
    private final BuildEventListener buildEventListener;

    public LoggingExecutionListener(ExecutionListener delegate, BuildEventListener buildEventListener) {
        this.delegate = delegate;
        this.buildEventListener = buildEventListener;
    }

    @Override
    public void beforeProjectExecution(ProjectExecutionEvent projectExecutionEvent) throws LifecycleExecutionException {
    }

    @Override
    public void beforeProjectLifecycleExecution(ProjectExecutionEvent projectExecutionEvent) throws LifecycleExecutionException {
    }

    @Override
    public void afterProjectExecutionSuccess(ProjectExecutionEvent projectExecutionEvent) throws LifecycleExecutionException {
    }

    @Override
    public void afterProjectExecutionFailure(ProjectExecutionEvent projectExecutionEvent) {
        Throwable t;
        MavenSession session = projectExecutionEvent.getSession();
        ReactorBuildStatus status = (ReactorBuildStatus)session.getRepositorySession().getData().get(ReactorBuildStatus.class);
        boolean halted = status != null ? status.isHalted() : (t = projectExecutionEvent.getCause()) instanceof RuntimeException || !(t instanceof Exception) || !"FAIL_NEVER".equals(session.getReactorFailureBehavior()) && !"FAIL_AT_END".equals(session.getReactorFailureBehavior());
        Throwable cause = projectExecutionEvent.getCause();
        this.buildEventListener.executionFailure(projectExecutionEvent.getProject().getArtifactId(), halted, cause != null ? cause.toString() : null);
    }

    @Override
    public void projectDiscoveryStarted(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.projectDiscoveryStarted(event);
    }

    @Override
    public void sessionStarted(ExecutionEvent event) {
        this.setMdc(event);
        this.buildEventListener.sessionStarted(event);
        this.delegate.sessionStarted(event);
    }

    @Override
    public void sessionEnded(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.sessionEnded(event);
    }

    @Override
    public void projectStarted(ExecutionEvent event) {
        this.setMdc(event);
        this.buildEventListener.projectStarted(event.getProject().getArtifactId());
        this.delegate.projectStarted(event);
    }

    @Override
    public void projectSucceeded(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.projectSucceeded(event);
        this.buildEventListener.projectFinished(event.getProject().getArtifactId());
    }

    @Override
    public void projectFailed(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.projectFailed(event);
        this.buildEventListener.projectFinished(event.getProject().getArtifactId());
    }

    @Override
    public void projectSkipped(ExecutionEvent event) {
        this.setMdc(event);
        this.buildEventListener.projectStarted(event.getProject().getArtifactId());
        this.delegate.projectSkipped(event);
        this.buildEventListener.projectFinished(event.getProject().getArtifactId());
    }

    @Override
    public void mojoStarted(ExecutionEvent event) {
        this.setMdc(event);
        this.buildEventListener.mojoStarted(event);
        this.delegate.mojoStarted(event);
    }

    @Override
    public void mojoSucceeded(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.mojoSucceeded(event);
    }

    @Override
    public void mojoFailed(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.mojoFailed(event);
    }

    @Override
    public void mojoSkipped(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.mojoSkipped(event);
    }

    @Override
    public void forkStarted(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.forkStarted(event);
        ProjectBuildLogAppender.setForkingProjectId(event.getProject().getArtifactId());
    }

    @Override
    public void forkSucceeded(ExecutionEvent event) {
        this.delegate.forkSucceeded(event);
        ProjectBuildLogAppender.setForkingProjectId(null);
    }

    @Override
    public void forkFailed(ExecutionEvent event) {
        this.delegate.forkFailed(event);
        ProjectBuildLogAppender.setForkingProjectId(null);
    }

    @Override
    public void forkedProjectStarted(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.forkedProjectStarted(event);
    }

    @Override
    public void forkedProjectSucceeded(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.forkedProjectSucceeded(event);
        ProjectBuildLogAppender.setProjectId(null);
    }

    @Override
    public void forkedProjectFailed(ExecutionEvent event) {
        this.setMdc(event);
        this.delegate.forkedProjectFailed(event);
        ProjectBuildLogAppender.setProjectId(null);
    }

    private void setMdc(ExecutionEvent event) {
        if (event.getProject() != null) {
            ProjectBuildLogAppender.setProjectId(event.getProject().getArtifactId());
        }
    }
}

