/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.internal.MavenPluginValidator;

@Named
@Singleton
class DefaultMavenPluginValidator
implements MavenPluginValidator {
    DefaultMavenPluginValidator() {
    }

    @Override
    public void validate(Artifact pluginArtifact, PluginDescriptor pluginDescriptor, List<String> errors) {
        if (!pluginArtifact.getGroupId().equals(pluginDescriptor.getGroupId())) {
            errors.add("Plugin's descriptor contains the wrong group ID: " + pluginDescriptor.getGroupId());
        }
        if (!pluginArtifact.getArtifactId().equals(pluginDescriptor.getArtifactId())) {
            errors.add("Plugin's descriptor contains the wrong artifact ID: " + pluginDescriptor.getArtifactId());
        }
        if (!pluginArtifact.getBaseVersion().equals(pluginDescriptor.getVersion())) {
            errors.add("Plugin's descriptor contains the wrong version: " + pluginDescriptor.getVersion());
        }
    }
}

