/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.security.GeneralSecurityException;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.util.security.KEM;
import org.apache.sshd.common.util.security.SecurityUtils;

public enum BuiltinKEM implements KEM,
NamedResource,
OptionalFeature
{
    mlkem768("mlkem768", "ML-KEM-768"),
    mlkem1024("mlkem1024", "ML-KEM-1024"),
    sntrup761("sntrup761", "SNTRUP-761");

    private String name;
    private KEM kem;

    private BuiltinKEM(String name, String algorithm) {
        KEM k;
        this.name = name;
        try {
            k = SecurityUtils.getKEM(algorithm);
        }
        catch (GeneralSecurityException e) {
            k = null;
        }
        this.kem = k;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSupported() {
        return this.kem != null && this.kem.isSupported();
    }

    @Override
    public KEM.Client getClient() {
        return this.kem.getClient();
    }

    @Override
    public KEM.Server getServer() {
        return this.kem.getServer();
    }
}

