/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib.component;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.webapp.ValidatorELTag;
import javax.servlet.jsp.JspException;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.validator.FileItemValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ValidateFileItemTag
extends ValidatorELTag {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(ValidateFileItemTag.class);
    private ValueExpression contentType;
    private ValueExpression maxSize;

    protected Validator createValidator() throws JspException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        FileItemValidator validator = (FileItemValidator)application.createValidator("org.apache.myfaces.tobago.FileItem");
        ELContext elContext = facesContext.getELContext();
        if (this.maxSize != null) {
            try {
                validator.setMaxSize((Integer)this.maxSize.getValue(elContext));
            }
            catch (NumberFormatException e) {
                LOG.warn(e.getMessage());
            }
        }
        if (this.contentType != null) {
            validator.setContentType(ComponentUtils.splitList((String)this.contentType.getValue(elContext)));
        }
        return validator;
    }

    public void release() {
        super.release();
        this.contentType = null;
        this.maxSize = null;
    }

    public void setMaxSize(ValueExpression maxSize) {
        this.maxSize = maxSize;
    }

    public void setContentType(ValueExpression contentType) {
        this.contentType = contentType;
    }
}

