/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.ProxyClassLoader;

final class ProxyClassPackages {
    private static final ConcurrentMap<String, Set<ProxyClassLoader>> packageCoverage = new ConcurrentHashMap<String, Set<ProxyClassLoader>>();

    private ProxyClassPackages() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addCoveredPackages(ProxyClassLoader loader, Iterable<String> coveredPackages) {
        ConcurrentMap<String, Set<ProxyClassLoader>> concurrentMap = packageCoverage;
        synchronized (concurrentMap) {
            for (String pkg : coveredPackages) {
                Set<ProxyClassLoader> delegates = (Set<ProxyClassLoader>)packageCoverage.get(pkg);
                if (delegates == null) {
                    delegates = Collections.singleton(loader);
                    packageCoverage.put(pkg, delegates);
                    continue;
                }
                if (delegates.size() == 1) {
                    delegates = new HashSet<ProxyClassLoader>(delegates);
                    packageCoverage.put(pkg, delegates);
                    delegates.add(loader);
                    continue;
                }
                delegates.add(loader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeCoveredPakcages(ProxyClassLoader loader) {
        ConcurrentMap<String, Set<ProxyClassLoader>> concurrentMap = packageCoverage;
        synchronized (concurrentMap) {
            packageCoverage.values().removeIf(set -> {
                if (set.contains(loader) && set.size() == 1) {
                    return true;
                }
                set.remove(loader);
                return false;
            });
        }
    }

    static Set<ProxyClassLoader> findCoveredPkg(String pkg) {
        return packageCoverage.computeIfPresent(pkg, (k, v) -> v);
    }
}

