/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.modules.editor.lib2.highlighting.CompoundAttributes;
import org.netbeans.modules.editor.lib2.highlighting.HighlightItem;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsList;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.spi.editor.highlighting.SplitOffsetHighlightsSequence;

class ViewPaintHighlights
implements SplitOffsetHighlightsSequence {
    private static final Logger LOG = Logger.getLogger(ViewPaintHighlights.class.getName());
    private static final HighlightItem[] EMPTY = new HighlightItem[0];
    private final HighlightsList paintHighlights;
    private int phIndex;
    private int phStartOffset;
    private int phStartSplitOffset;
    private int phEndOffset;
    private int phEndSplitOffset;
    private AttributeSet phAttrs;
    private int viewEndOffset;
    private HighlightItem[] cahItems;
    private int cahIndex;
    private int cahEndOffset;
    private int cahEndSplitOffset;
    private AttributeSet cahAttrs;
    private int offsetDiff;
    private int hiStartOffset;
    private int hiStartSplitOffset;
    private int hiEndOffset;
    private int hiEndSplitOffset;
    private AttributeSet hiAttrs;

    ViewPaintHighlights(HighlightsList paintHighlights) {
        this.paintHighlights = paintHighlights;
        this.updatePH(0);
    }

    void reset(EditorView view, int shift) {
        assert (shift >= 0) : "shift=" + shift + " < 0";
        int viewStartOffset = view.getStartOffset();
        int viewLength = view.getLength();
        assert (shift < viewLength) : "shift=" + shift + " >= viewLength=" + viewLength;
        this.viewEndOffset = viewStartOffset + viewLength;
        AttributeSet attrs = view.getAttributes();
        int startOffset = viewStartOffset + shift;
        if (ViewUtils.isCompoundAttributes(attrs)) {
            CompoundAttributes cAttrs = (CompoundAttributes)attrs;
            this.offsetDiff = viewStartOffset - cAttrs.startOffset();
            this.cahItems = cAttrs.highlightItems();
            if (shift == 0) {
                this.cahIndex = 0;
            } else {
                int cahOffset = startOffset - this.offsetDiff;
                this.cahIndex = this.findCAHIndex(cahOffset);
            }
            if (this.cahIndex >= this.cahItems.length) {
                throw new IllegalStateException("offsetDiff=" + this.offsetDiff + ", view=" + view + ", shift=" + shift + ", viewStartOffset+shift=" + startOffset + "\ncAttrs:\n" + cAttrs + "\n" + this + "docView:\n" + ((DocumentView)view.getParent().getParent()).toStringDetail());
            }
            HighlightItem cahItem = this.cahItems[this.cahIndex];
            this.cahEndOffset = cahItem.getEndOffset() + this.offsetDiff;
            this.cahEndSplitOffset = cahItem.getEndSplitOffset();
            this.cahAttrs = cahItem.getAttributes();
        } else {
            this.cahItems = EMPTY;
            this.cahIndex = -1;
            this.cahEndOffset = this.viewEndOffset;
            this.cahEndSplitOffset = 0;
            this.cahAttrs = attrs == null ? null : attrs;
        }
        if (startOffset < this.phStartOffset || this.phStartSplitOffset != 0) {
            this.updatePH(this.findPHIndex(startOffset));
        } else if (startOffset > this.phEndOffset || startOffset == this.phEndOffset && this.phEndSplitOffset == 0) {
            this.fetchNextPH();
            if (startOffset > this.phEndOffset || startOffset == this.phEndOffset && this.phEndSplitOffset == 0) {
                this.updatePH(this.findPHIndex(startOffset));
            }
        }
        this.hiStartOffset = this.hiEndOffset = startOffset;
        this.hiEndSplitOffset = 0;
        this.hiStartSplitOffset = 0;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("ViewPaintHighlights.reset: view=" + view.getDumpId() + ", startOffset=" + startOffset + " attrs=" + attrs + "\n    cahEndOffset=" + this.cahEndOffset + '_' + this.cahEndSplitOffset + ", phStartOffset=" + this.phStartOffset + '_' + this.phStartSplitOffset + ", phEndOffset=" + this.phEndOffset + '_' + this.phEndSplitOffset + "\n");
        }
    }

    @Override
    public boolean moveNext() {
        if (this.hiEndOffset >= this.viewEndOffset) {
            return false;
        }
        if (this.hiEndOffset > this.phEndOffset || this.hiEndOffset == this.phEndOffset && this.hiEndSplitOffset >= this.phEndSplitOffset) {
            this.fetchNextPH();
        }
        if (this.hiEndOffset > this.cahEndOffset || this.hiEndOffset == this.cahEndOffset && this.hiEndSplitOffset >= this.cahEndSplitOffset) {
            ++this.cahIndex;
            if (this.cahIndex >= this.cahItems.length) {
                this.hiStartOffset = this.hiEndOffset = this.viewEndOffset;
                return false;
            }
            HighlightItem hItem = this.cahItems[this.cahIndex];
            this.cahEndOffset = hItem.getEndOffset() + this.offsetDiff;
            this.cahEndSplitOffset = hItem.getEndSplitOffset();
            this.cahAttrs = hItem.getAttributes();
        }
        this.hiStartOffset = this.hiEndOffset;
        this.hiStartSplitOffset = this.hiEndSplitOffset;
        if (this.phEndOffset < this.cahEndOffset || this.phEndOffset == this.cahEndOffset && this.phEndSplitOffset <= this.cahEndSplitOffset) {
            if (this.phEndOffset >= this.viewEndOffset) {
                this.hiEndOffset = this.viewEndOffset;
                this.hiEndSplitOffset = 0;
            } else {
                this.hiEndOffset = this.phEndOffset;
                this.hiEndSplitOffset = this.phEndSplitOffset;
            }
        } else {
            this.hiEndOffset = this.cahEndOffset;
            this.hiEndSplitOffset = this.cahEndSplitOffset;
        }
        this.hiAttrs = this.cahAttrs;
        if (this.phAttrs != null) {
            AttributeSet attributeSet = this.hiAttrs = this.hiAttrs != null ? AttributesUtilities.createComposite(this.phAttrs, this.hiAttrs) : this.phAttrs;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("ViewPaintHighlights.moveNext-highlight: <" + this.getStartOffset() + "_" + this.getStartSplitOffset() + "," + this.getEndOffset() + "_" + this.getEndSplitOffset() + "> attrs=" + this.getAttributes() + "\n");
        }
        return true;
    }

    @Override
    public int getStartOffset() {
        return this.hiStartOffset;
    }

    @Override
    public int getStartSplitOffset() {
        return this.hiStartSplitOffset;
    }

    @Override
    public int getEndOffset() {
        return this.hiEndOffset;
    }

    @Override
    public int getEndSplitOffset() {
        return this.hiEndSplitOffset;
    }

    @Override
    public AttributeSet getAttributes() {
        return this.hiAttrs;
    }

    private int findCAHIndex(int cahOffset) {
        int low = 0;
        int high = this.cahItems.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int hEndOffset = this.cahItems[mid].getEndOffset();
            if (hEndOffset < cahOffset) {
                low = mid + 1;
                continue;
            }
            if (hEndOffset > cahOffset) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
            break;
        }
        return low;
    }

    private void updatePH(int index) {
        this.phIndex = index;
        if (this.phIndex > 0) {
            HighlightItem prevPHItem = this.paintHighlights.get(this.phIndex - 1);
            this.phStartOffset = prevPHItem.getEndOffset();
            this.phStartSplitOffset = prevPHItem.getEndSplitOffset();
        } else {
            this.phStartOffset = this.paintHighlights.startOffset();
            this.phStartSplitOffset = 0;
        }
        HighlightItem phItem = this.paintHighlights.get(this.phIndex);
        this.phEndOffset = phItem.getEndOffset();
        this.phEndSplitOffset = phItem.getEndSplitOffset();
        this.phAttrs = phItem.getAttributes();
    }

    private void fetchNextPH() {
        ++this.phIndex;
        if (this.phIndex >= this.paintHighlights.size()) {
            throw new IllegalStateException("phIndex=" + this.phIndex + " >= paintHighlights.size()=" + this.paintHighlights.size() + "\n" + this);
        }
        this.phStartOffset = this.phEndOffset;
        this.phStartSplitOffset = this.phEndSplitOffset;
        HighlightItem phItem = this.paintHighlights.get(this.phIndex);
        this.phEndOffset = phItem.getEndOffset();
        this.phEndSplitOffset = phItem.getEndSplitOffset();
        this.phAttrs = phItem.getAttributes();
    }

    private int findPHIndex(int offset) {
        int low = 0;
        int high = this.paintHighlights.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            HighlightItem phItem = this.paintHighlights.get(mid);
            int hEndOffset = phItem.getEndOffset();
            if (hEndOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (hEndOffset > offset) {
                high = mid - 1;
                continue;
            }
            if (phItem.getEndSplitOffset() != 0) {
                while (mid > 0) {
                    if ((phItem = this.paintHighlights.get(--mid)).getEndOffset() == offset) {
                        if (phItem.getEndSplitOffset() != 0) continue;
                        break;
                    }
                    ++mid;
                    break;
                }
            }
            low = mid + 1;
            break;
        }
        return low;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("ViewPaintHighlights: ph[").append(this.phIndex).append("]<").append(this.phStartOffset).append(",").append(this.phEndOffset).append('_').append(this.phEndSplitOffset).append("> attrs=").append(this.phAttrs).append('\n');
        sb.append("cah[").append(this.cahIndex).append("]#").append(this.cahItems.length);
        sb.append(" <?,").append(this.cahEndOffset).append("> attrs=").append(this.cahAttrs);
        sb.append(", viewEndOffset=").append(this.viewEndOffset).append(", offsetDiff=").append(this.offsetDiff);
        sb.append("\npaintHighlights:").append(this.paintHighlights);
        return sb.toString();
    }
}

