/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jackpot30.cmdline.lib;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import jpt.sun.source.util.JavacTask;
import jpt30.tools.ForwardingJavaFileManager;
import jpt30.tools.JavaCompiler;
import jpt30.tools.JavaFileManager;
import jpt30.tools.ToolProvider;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;

public class Utils {
    private static final Map<String, String> toIdRemap = new HashMap<String, String>(){
        {
            this.put("==", "equals");
            this.put("!=", "not_equals");
        }
    };
    private static final String PROTOCOL = "nbjrt";

    public static Map<String, String> computeId2DisplayName(Iterable<? extends HintDescription> descs) {
        HashMap<String, String> id2DisplayName = new HashMap<String, String>();
        for (HintDescription hintDescription : descs) {
            if (hintDescription.getMetadata() == null) continue;
            id2DisplayName.put(hintDescription.getMetadata().id, hintDescription.getMetadata().displayName);
        }
        return id2DisplayName;
    }

    public static String categoryName(String id, Map<String, String> id2DisplayName) {
        Object idDisplayName;
        if (id != null && id.startsWith("text/x-java:")) {
            id = id.substring("text/x-java:".length());
        }
        if ((idDisplayName = id2DisplayName.get(id)) == null) {
            idDisplayName = "unknown";
        }
        for (Map.Entry<String, String> remap : toIdRemap.entrySet()) {
            idDisplayName = ((String)idDisplayName).replace(remap.getKey(), remap.getValue());
        }
        idDisplayName = ((String)idDisplayName).replaceAll("[^A-Za-z0-9]", "_").replaceAll("_+", "_");
        idDisplayName = "[" + (String)idDisplayName + "] ";
        return idDisplayName;
    }

    public static ClassPath createDefaultBootClassPath() {
        String cp = System.getProperty("sun.boot.class.path");
        if (cp != null) {
            String[] paths;
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String path : paths = cp.split(Pattern.quote(System.getProperty("path.separator")))) {
                File f = new File(path);
                if (!f.canRead()) continue;
                FileObject fo = FileUtil.toFileObject(f);
                if (FileUtil.isArchiveFile(fo)) {
                    fo = FileUtil.getArchiveRoot(fo);
                }
                if (fo == null) continue;
                urls.add(fo.toURL());
            }
            return ClassPathSupport.createClassPath(urls.toArray(new URL[0]));
        }
        try {
            Class.forName("org.netbeans.ProxyURLStreamHandlerFactory").getMethod("register", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
        ArrayList<PathResourceImplementation> modules = new ArrayList<PathResourceImplementation>();
        File installDir = new File(System.getProperty("java.home"));
        URI imageURI = Utils.getImageURI(installDir);
        try {
            FileObject jrtRoot = URLMapper.findFileObject(imageURI.toURL());
            FileObject root = Utils.getModulesRoot(jrtRoot);
            for (FileObject module : root.getChildren()) {
                modules.add(ClassPathSupport.createResource(module.toURL()));
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        if (modules.isEmpty()) {
            throw new IllegalStateException("No modules!");
        }
        return ClassPathSupport.createClassPath(modules);
    }

    private static URI getImageURI(@NonNull File jdkHome) {
        try {
            return new URI(String.format("%s:%s!/%s", PROTOCOL, BaseUtilities.toURI(jdkHome).toString(), ""));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException();
        }
    }

    @NonNull
    private static FileObject getModulesRoot(@NonNull FileObject jrtRoot) {
        FileObject modules = jrtRoot.getFileObject("modules");
        return modules == null ? jrtRoot : modules;
    }

    public static void addExports() {
        JavaCompiler compilerTool = ToolProvider.getSystemJavaCompiler();
        class CurrentClassLoaderFM
        extends ForwardingJavaFileManager<JavaFileManager> {
            public CurrentClassLoaderFM(JavaFileManager delegate) {
                super(delegate);
            }

            @Override
            public ClassLoader getClassLoader(JavaFileManager.Location location) {
                return Utils.class.getClassLoader();
            }
        }
        try (CurrentClassLoaderFM fm = new CurrentClassLoaderFM(compilerTool.getStandardFileManager(d -> {}, null, null));){
            PrintWriter nullWriter = new PrintWriter(new StringWriter());
            ((JavacTask)compilerTool.getTask(nullWriter, fm, d -> {}, Arrays.asList("-proc:none", "-XDaccessInternalAPI"), Arrays.asList("java.lang.Object"), null)).analyze();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

