/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.util.Parameters;

public abstract class AbstractClassPathProvider
implements ClassPathProvider {
    private final List<ClassPathsChangeListener> listeners = new CopyOnWriteArrayList<ClassPathsChangeListener>();

    protected AbstractClassPathProvider() {
    }

    @CheckForNull
    public abstract ClassPath[] getProjectClassPaths(@NonNull String var1);

    @CheckForNull
    public abstract String[] getPropertyName(@NonNull SourceGroup var1, @NonNull String var2);

    public final void addClassPathsChangeListener(@NonNull ClassPathsChangeListener listener) {
        Parameters.notNull("listener", listener);
        this.listeners.add(listener);
    }

    public final void removeClassPathsChangeListener(@NonNull ClassPathsChangeListener listener) {
        Parameters.notNull("listener", listener);
        this.listeners.remove(listener);
    }

    protected final void fireClassPathsChange(@NonNull Collection<? extends String> changedClassPathTypes) {
        Parameters.notNull("changedClassPathTypes", changedClassPathTypes);
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassPathsChangeEvent evt = new ClassPathsChangeEvent(this, Collections.unmodifiableCollection(changedClassPathTypes));
        for (ClassPathsChangeListener l : this.listeners) {
            l.classPathsChange(evt);
        }
    }

    public static final class ClassPathsChangeEvent
    extends EventObject {
        private final Collection<? extends String> classPathTypes;

        private ClassPathsChangeEvent(@NonNull AbstractClassPathProvider source, @NonNull Collection<? extends String> classPathTypes) {
            super(source);
            this.classPathTypes = classPathTypes;
        }

        @NonNull
        public Collection<? extends String> getChangedClassPathTypes() {
            return this.classPathTypes;
        }
    }

    public static interface ClassPathsChangeListener
    extends EventListener {
        public void classPathsChange(@NonNull ClassPathsChangeEvent var1);
    }
}

