/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.CompilerOptionsQuery;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathModifier;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.impl.DefaultProjectModulesModifier;
import org.netbeans.modules.java.api.common.project.ui.ActionFilterNode;
import org.netbeans.modules.java.api.common.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.java.api.common.project.ui.LogicalViewProvider2;
import org.netbeans.modules.java.api.common.project.ui.ModuleNode;
import org.netbeans.modules.java.api.common.project.ui.PlatformNode;
import org.netbeans.modules.java.api.common.project.ui.ProjectNode;
import org.netbeans.modules.java.api.common.project.ui.customizer.AntArtifactItem;
import org.netbeans.modules.java.api.common.project.ui.customizer.EditMediator;
import org.netbeans.modules.java.api.common.util.CommonModuleUtils;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.ui.CustomizerUtilities;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.BaseUtilities;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public final class LibrariesNode
extends AbstractNode {
    private static final Image ICON_BADGE = ImageUtilities.loadImage("org/netbeans/modules/java/api/common/project/ui/resources/libraries-badge.png");
    public static final RequestProcessor rp = new RequestProcessor();
    private static Icon folderIconCache;
    private static Icon openedFolderIconCache;
    private final String displayName;
    private final Action[] librariesNodeActions;

    public LibrariesNode(String displayName, Project project, PropertyEvaluator eval, UpdateHelper helper, ReferenceHelper refHelper, String classPathProperty, String[] classPathIgnoreRef, String platformProperty, Action[] librariesNodeActions, String webModuleElementName, ClassPathSupport cs, Callback extraKeys) {
        this(displayName, project, eval, helper, refHelper, Collections.singletonList(classPathProperty), Arrays.asList(classPathIgnoreRef), platformProperty == null ? null : Pair.of(Pair.of(platformProperty, null), null), null, Collections.emptySet(), librariesNodeActions, webModuleElementName, cs, extraKeys, null, null);
    }

    private LibrariesNode(@NonNull String displayName, @NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper helper, @NonNull ReferenceHelper refHelper, @NonNull List<String> classPathProperties, @NonNull Collection<String> classPathIgnoreRef, @NullAllowed Pair<Pair<String, String>, ClassPath> boot, @NullAllowed Pair<Set<String>, ClassPath> modulePath, @NonNull Collection<String> modulePathIgnoreRef, @NullAllowed Action[] librariesNodeActions, @NullAllowed String webModuleElementName, @NonNull ClassPathSupport cs, @NullAllowed Callback extraKeys, @NullAllowed ClassPath sourcePath, @NullAllowed ClassPath moduleSourcePath) {
        super(new LibrariesChildren(project, eval, helper, refHelper, classPathProperties, classPathIgnoreRef, boot, modulePath, modulePathIgnoreRef, webModuleElementName, cs, extraKeys, sourcePath, moduleSourcePath), Lookups.fixed(project, new PathFinder()));
        this.displayName = displayName;
        this.librariesNodeActions = librariesNodeActions;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    @Override
    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    @Override
    public Action[] getActions(boolean context) {
        return this.librariesNodeActions;
    }

    @Override
    public boolean canCopy() {
        return false;
    }

    public static Action createAddProjectAction(Project p, SourceRoots sources) {
        return new AddProjectAction(p, sources::getRoots);
    }

    public static Action createAddLibraryAction(ReferenceHelper helper, SourceRoots sources, LibraryChooser.Filter filter) {
        return new AddLibraryAction(helper, sources::getRoots, filter != null ? filter : EditMediator.createLibraryFilter());
    }

    public static Action createAddFolderAction(AntProjectHelper p, SourceRoots sources) {
        return new AddFolderAction(p, sources::getRoots);
    }

    static synchronized Icon getFolderIcon(boolean opened) {
        if (openedFolderIconCache == null) {
            Node n = DataFolder.findFolder(FileUtil.getConfigRoot()).getNodeDelegate();
            openedFolderIconCache = ImageUtilities.image2Icon(n.getOpenedIcon(1));
            folderIconCache = ImageUtilities.image2Icon(n.getIcon(1));
        }
        if (opened) {
            return openedFolderIconCache;
        }
        return folderIconCache;
    }

    private Image computeIcon(boolean opened, int type) {
        Icon icon = LibrariesNode.getFolderIcon(opened);
        Image image = ((ImageIcon)icon).getImage();
        image = ImageUtilities.mergeImages(image, ICON_BADGE, 7, 7);
        return image;
    }

    private static void handlePCPMUnsupported(@NonNull Supplier<FileObject[]> sourceRoots, @NonNull UnsupportedOperationException e) {
        Object[] roots = sourceRoots.get();
        if (roots.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder().append("roots: ").append(Arrays.toString(roots)).append("\n");
        Exceptions.printStackTrace(Exceptions.attachMessage(e, sb.toString()));
    }

    @CheckForNull
    private static FileObject findModuleInfo(FileObject ... roots) {
        for (FileObject root : roots) {
            FileObject fo = root.getFileObject("module-info.java");
            if (fo == null) continue;
            return fo;
        }
        return null;
    }

    @CheckForNull
    private static URL resolveAntArtifact(@NonNull AntArtifact art, @NonNull URI loc) {
        FileObject prj = art.getProject().getProjectDirectory();
        File f = BaseUtilities.toFile(prj.toURI().resolve(loc));
        return FileUtil.urlForArchiveOrDir(f);
    }

    @NonNull
    private static URL[] toURLs(Library ... libraries) {
        ArrayList<URL> res = new ArrayList<URL>();
        for (Library library : libraries) {
            res.addAll(library.getContent("classpath"));
        }
        return res.toArray(new URL[0]);
    }

    @NonNull
    private static URL[] toURLs(AntArtifactItem ... artifacts) {
        ArrayList<URL> res = new ArrayList<URL>(artifacts.length);
        for (AntArtifactItem ai : artifacts) {
            URL resolved = LibrariesNode.resolveAntArtifact(ai.getArtifact(), ai.getArtifactURI());
            if (resolved == null) continue;
            res.add(resolved);
        }
        return res.toArray(new URL[0]);
    }

    private static SourceGroup findSourceGroup(FileObject fo, ClassPathModifier modifierImpl) {
        SourceGroup[] sgs;
        for (SourceGroup sg : sgs = modifierImpl.getExtensibleSourceGroups()) {
            if (fo != sg.getRootFolder() && !FileUtil.isParentOf(sg.getRootFolder(), fo) || !sg.contains(fo)) continue;
            return sg;
        }
        throw new AssertionError((Object)("Cannot find source group for '" + fo + "' in " + Arrays.asList(sgs)));
    }

    public static interface Callback {
        public List<Key> getExtraKeys();

        public Node[] createNodes(Key var1);
    }

    private static class LibrariesChildren
    extends Children.Keys<Key>
    implements PropertyChangeListener,
    ChangeListener {
        private static final String LIBRARY_PREFIX = "${libs.";
        private static final String ANT_ARTIFACT_PREFIX = "${reference.";
        private static final String FILE_REF_PREFIX = "${file.reference.";
        private static final String REF_PREFIX = "${";
        private static final String LIBRARIES_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/libraries.gif";
        private static final String ARCHIVE_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/jar.gif";
        private final PropertyEvaluator eval;
        private final UpdateHelper helper;
        private final ReferenceHelper refHelper;
        private final Set<String> classPathProperties;
        private final Pair<Pair<String, String>, ClassPath> boot;
        private final Pair<Set<String>, ClassPath> modulePath;
        private final Set<String> classPathIgnoreRef;
        private final Set<String> modulePathIgnoreRef;
        private final String webModuleElementName;
        private final ClassPathSupport cs;
        private final SourceLevelQuery.Result slResult;
        private final ClassPath sourcePath;
        private final ClassPath moduleSourcePath;
        private Callback extraKeys;
        private Project project;
        private RootsListener fsListener;
        private final AtomicReference<CompilerOptionsQuery.Result> coResult;
        private final AtomicReference<PropertyChangeListener[]> sourceRootsListener;

        LibrariesChildren(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper helper, @NonNull ReferenceHelper refHelper, @NonNull List<String> classPathProperties, @NonNull Collection<String> classPathIgnoreRef, @NullAllowed Pair<Pair<String, String>, ClassPath> boot, @NullAllowed Pair<Set<String>, ClassPath> modulePath, @NonNull Collection<String> modulePathIgnoreRef, @NullAllowed String webModuleElementName, @NonNull ClassPathSupport cs, @NullAllowed Callback extraKeys, @NullAllowed ClassPath sourcePath, @NullAllowed ClassPath moduleSourcePath) {
            this.eval = eval;
            this.helper = helper;
            this.refHelper = refHelper;
            this.classPathProperties = new LinkedHashSet<String>(classPathProperties);
            this.classPathIgnoreRef = new HashSet<String>(classPathIgnoreRef);
            this.boot = boot;
            this.modulePath = modulePath != null ? modulePath : Pair.of(Collections.emptySet(), null);
            this.modulePathIgnoreRef = new HashSet<String>(modulePathIgnoreRef);
            this.webModuleElementName = webModuleElementName;
            this.cs = cs;
            this.extraKeys = extraKeys;
            this.project = project;
            this.slResult = SourceLevelQuery.getSourceLevel2(this.helper.getAntProjectHelper().getProjectDirectory());
            this.sourcePath = sourcePath;
            this.moduleSourcePath = moduleSourcePath;
            this.coResult = new AtomicReference();
            this.sourceRootsListener = new AtomicReference();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            boolean propRoots = "roots".equals(propName);
            if (this.classPathProperties.contains(propName) || this.modulePath.first().contains(propName) || propRoots || "libraries".equals(propName) || "entries".equals(propName)) {
                this.reset(propRoots);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.reset(false);
        }

        @Override
        protected void addNotify() {
            this.eval.addPropertyChangeListener(WeakListeners.propertyChange(this, this.eval));
            this.slResult.addChangeListener(WeakListeners.change(this, this.slResult));
            LibraryManager lm = this.refHelper.getProjectLibraryManager();
            if (lm == null) {
                lm = LibraryManager.getDefault();
            }
            lm.addPropertyChangeListener(WeakListeners.propertyChange(this, lm));
            if (this.modulePath.second() != null) {
                this.modulePath.second().addPropertyChangeListener(WeakListeners.propertyChange(this, this.modulePath.second()));
            }
            this.listenOnCompilerOptions();
            if (this.sourcePath != null) {
                this.sourcePath.addPropertyChangeListener(WeakListeners.propertyChange(this, this.sourcePath));
            }
            this.setKeys(this.getKeys());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void removeNotify() {
            this.eval.removePropertyChangeListener(this);
            if (this.refHelper.getProjectLibraryManager() != null) {
                this.refHelper.getProjectLibraryManager().removePropertyChangeListener(this);
            } else {
                LibraryManager.getDefault().removePropertyChangeListener(this);
            }
            LibrariesChildren librariesChildren = this;
            synchronized (librariesChildren) {
                if (this.fsListener != null) {
                    this.fsListener.removePropertyChangeListener(this);
                    this.fsListener = null;
                }
            }
            this.setKeys(Collections.emptySet());
        }

        @Override
        protected Node[] createNodes(Key key) {
            Node[] result = null;
            switch (key.getType()) {
                case 0: {
                    result = new Node[]{PlatformNode.create(this.project, this.eval, this.boot, this.cs)};
                    break;
                }
                case 3: {
                    result = new Node[]{new ProjectNode(key.getProject(), key.getArtifactLocation(), this.helper, key.getClassPathId(), key.getEntryId(), this.webModuleElementName, this.cs, this.refHelper, key.getPreRemoveAction(), key.getPostRemoveAction(), !key.shared)};
                    break;
                }
                case 1: {
                    Node[] nodeArray;
                    FilterNode afn = ActionFilterNode.forLibrary(PackageView.createPackageView(key.getSourceGroup()), this.helper, key.getClassPathId(), key.getEntryId(), this.webModuleElementName, this.cs, this.refHelper, key.getPreRemoveAction(), key.getPostRemoveAction(), !key.shared);
                    if (afn == null) {
                        nodeArray = new Node[]{};
                    } else {
                        Node[] nodeArray2 = new Node[1];
                        nodeArray = nodeArray2;
                        nodeArray2[0] = afn;
                    }
                    result = nodeArray;
                    break;
                }
                case 2: {
                    Node[] nodeArray;
                    FilterNode afn = ActionFilterNode.forArchive(PackageView.createPackageView(key.getSourceGroup()), this.helper, this.eval, key.getClassPathId(), key.getEntryId(), this.webModuleElementName, this.cs, this.refHelper, key.getPreRemoveAction(), key.getPostRemoveAction(), !key.shared);
                    if (afn == null) {
                        nodeArray = new Node[]{};
                    } else {
                        Node[] nodeArray3 = new Node[1];
                        nodeArray = nodeArray3;
                        nodeArray3[0] = afn;
                    }
                    result = nodeArray;
                    break;
                }
                case 5: {
                    Node[] nodeArray;
                    FilterNode afn = ActionFilterNode.forRoot(PackageView.createPackageView(key.getSourceGroup()), this.helper, key.getClassPathId(), key.getEntryId(), this.webModuleElementName, this.cs, this.refHelper, key.getPreRemoveAction(), key.getPostRemoveAction(), !key.shared);
                    if (afn == null) {
                        nodeArray = new Node[]{};
                    } else {
                        Node[] nodeArray4 = new Node[1];
                        nodeArray = nodeArray4;
                        nodeArray4[0] = afn;
                    }
                    result = nodeArray;
                    break;
                }
                case 6: {
                    result = new Node[]{new ModuleNode(key.getEntryId(), key.getArtifactLocation(), key.getPreRemoveAction(), key.getPostRemoveAction())};
                    break;
                }
                case 4: {
                    result = this.extraKeys.createNodes(key);
                }
            }
            if (result == null) {
                assert (false) : "Unknown key type";
                result = new Node[]{};
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Key> getKeys() {
            boolean supportsModules;
            EditableProperties projectSharedProps = this.helper.getProperties("nbproject/project.properties");
            EditableProperties projectPrivateProps = this.helper.getProperties("nbproject/private/private.properties");
            EditableProperties privateProps = PropertyUtils.getGlobalProperties();
            ArrayList<URL> rootsList = new ArrayList<URL>();
            ArrayList<Key> result = new ArrayList<Key>();
            String sl = this.slResult.getSourceLevel();
            boolean bl = supportsModules = sl != null && CommonModuleUtils.JDK9.compareTo(new SpecificationVersion(sl)) <= 0;
            if (supportsModules && this.moduleSourcePath != null && this.sourcePath != null) {
                Collection srcRoots = this.sourcePath.entries().stream().map(e -> e.getURL()).collect(Collectors.toList());
                Collection librariesChildren = Arrays.stream(this.moduleSourcePath.getRoots()).flatMap(fo -> Arrays.stream(fo.getChildren())).map(fo -> {
                    if (fo.isFolder() && !fo.getName().startsWith(".")) {
                        return Pair.of(fo.getNameExt(), fo.toURL());
                    }
                    return null;
                }).filter(p -> p != null).sorted((a, b) -> ((String)a.first()).compareTo((String)b.first())).collect(Collectors.toList());
                HashSet<String> relPaths = new HashSet<String>();
                for (Object modRoot : librariesChildren) {
                    Iterator iterator = srcRoots.iterator();
                    while (iterator.hasNext()) {
                        String mef;
                        URL srcRoot = (URL)iterator.next();
                        String sef = srcRoot.toExternalForm();
                        if (!sef.startsWith(mef = ((URL)((Pair)modRoot).second()).toExternalForm())) continue;
                        relPaths.add(sef.substring(mef.length()));
                    }
                }
                if (!relPaths.isEmpty()) {
                    librariesChildren.stream().collect(Collectors.groupingBy(p -> (String)p.first())).entrySet().stream().map(e -> Pair.of((String)e.getKey(), ((List)e.getValue()).stream().map(Pair::second).collect(Collectors.toList()))).map(p -> {
                        try {
                            URL srcRoot = new URL(((URL)((List)p.second()).get(0)).toExternalForm() + (String)relPaths.iterator().next());
                            URL bin = Arrays.stream(BinaryForSourceQuery.findBinaryRoots(srcRoot).getRoots()).filter(FileUtil::isArchiveArtifact).findFirst().orElse(null);
                            if (bin != null) {
                                String modName = (String)p.first();
                                return Key.module(modName, bin.toURI(), null, atfc -> {
                                    FileObject modInfo = LibrariesNode.findModuleInfo(this.sourcePath.getRoots());
                                    if (modInfo != null) {
                                        DefaultProjectModulesModifier.removeRequiredModules(modInfo, Collections.singleton(modName));
                                    }
                                });
                            }
                        }
                        catch (MalformedURLException | URISyntaxException ex) {
                            Exceptions.printStackTrace(ex);
                        }
                        return null;
                    }).filter(k -> k != null).forEach(result::add);
                }
            }
            for (String string : this.classPathProperties) {
                result.addAll(this.getKeys(projectSharedProps, projectPrivateProps, privateProps, string, this.classPathIgnoreRef, CPMapper.INSTANCE, null, null, rootsList));
            }
            if (supportsModules) {
                Map<String, List<URL>> patches;
                RemoveFromModuleInfo rfmi = new RemoveFromModuleInfo(this.helper, this.eval, this.sourcePath);
                for (String modulePathProperty : this.modulePath.first()) {
                    result.addAll(this.getKeys(projectSharedProps, projectPrivateProps, privateProps, modulePathProperty, this.modulePathIgnoreRef, MPMapper.INSTANCE, rfmi, null, rootsList));
                }
                CompilerOptionsQuery.Result result2 = this.coResult.get();
                if (result2 != null && !(patches = CommonModuleUtils.getPatches(result2)).isEmpty()) {
                    IdentityHashMap patchesByKey = new IdentityHashMap();
                    for (Key key : result) {
                        try {
                            String moduleName;
                            List<URL> modulePatches;
                            URI uri2 = key.toURI();
                            if (uri2 == null || (modulePatches = patches.get(moduleName = SourceUtils.getModuleName(uri2.toURL()))) == null) continue;
                            patchesByKey.put(key, modulePatches.stream().map(url -> {
                                File f = FileUtil.archiveOrDirForURL(url);
                                if (f != null) {
                                    Collection<SourceGroup> sgs = CPMapper.INSTANCE.apply(Pair.of(f, new ArrayList()));
                                    return sgs.isEmpty() ? null : Key.file(sgs.iterator().next(), "", "", null, null, true);
                                }
                                return null;
                            }).filter(k -> k != null).collect(Collectors.toList()));
                        }
                        catch (MalformedURLException e2) {
                            Exceptions.printStackTrace(e2);
                        }
                    }
                    ArrayList<Key> patchedResult = new ArrayList<Key>();
                    for (Key k2 : result) {
                        List p2 = (List)patchesByKey.get(k2);
                        if (p2 != null) {
                            patchedResult.addAll(p2);
                        }
                        patchedResult.add(k2);
                    }
                    result = patchedResult;
                }
                if (this.modulePath.second() != null) {
                    Set filter = this.modulePath.second().entries().stream().map(e -> {
                        try {
                            return e.getURL().toURI();
                        }
                        catch (URISyntaxException exc) {
                            Exceptions.printStackTrace(exc);
                            return null;
                        }
                    }).filter(uri -> uri != null).collect(Collectors.toSet());
                    Iterator it = result.iterator();
                    while (it.hasNext()) {
                        Key key = (Key)it.next();
                        if (filter.contains(key.toURI())) continue;
                        it.remove();
                    }
                }
            }
            if (this.boot != null) {
                result.add(Key.platform());
            }
            RootsListener rootsListener = new RootsListener(rootsList);
            rootsListener.addPropertyChangeListener(this);
            LibrariesChildren librariesChildren = this;
            synchronized (librariesChildren) {
                this.fsListener = rootsListener;
            }
            if (this.extraKeys != null) {
                result.addAll(this.extraKeys.getExtraKeys());
            }
            return result;
        }

        private Set<URL> computeOtherRootLibraries() {
            Sources s = ProjectUtils.getSources(this.project);
            if (s == null || this.sourcePath == null) {
                return Collections.emptySet();
            }
            HashSet<URL> refs = new HashSet<URL>();
            for (SourceGroup sg : s.getSourceGroups("java")) {
                ClassPath sPath = ClassPath.getClassPath(sg.getRootFolder(), "classpath/source");
                if (Arrays.equals(this.sourcePath.getRoots(), sPath.getRoots())) continue;
                ClassPath cp = ClassPath.getClassPath(sg.getRootFolder(), "classpath/compile");
                for (ClassPath.Entry e : cp.entries()) {
                    URL u = e.getURL();
                    refs.add(u);
                    if (!"jar".equals(u.getProtocol()) || !u.getPath().contains("!")) continue;
                    String str = u.toExternalForm().substring(4);
                    int index = str.indexOf("!");
                    try {
                        refs.add(new URL(str.substring(0, index)));
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
            return refs;
        }

        private List<Key> getKeys(@NonNull EditableProperties projectSharedProps, @NonNull EditableProperties projectPrivateProps, @NonNull EditableProperties privateProps, @NonNull String currentClassPath, @NonNull Set<String> toIgnre, @NonNull Function<Pair<File, Collection<? super URL>>, Collection<SourceGroup>> fileRefMapper, @NullAllowed Consumer<Pair<String, String>> preRemoveAction, @NullAllowed Consumer<Pair<String, String>> postRemoveAction, @NonNull List<URL> rootsList) {
            ArrayList<Key> result = new ArrayList<Key>();
            String raw = projectSharedProps.getProperty(currentClassPath);
            if (raw == null) {
                raw = projectPrivateProps.getProperty(currentClassPath);
            }
            if (raw == null) {
                raw = privateProps.getProperty(currentClassPath);
            }
            if (raw == null) {
                return result;
            }
            ArrayList<String> pe = new ArrayList<String>(Arrays.asList(PropertyUtils.tokenizePath(raw)));
            Set<URL> otherSourceRoots = null;
            while (pe.size() > 0) {
                String prop = (String)pe.remove(0);
                String propName = CommonProjectUtils.getAntPropertyName(prop);
                if (toIgnre.contains(propName)) continue;
                if (prop.startsWith(LIBRARY_PREFIX)) {
                    String eval = prop.substring(LIBRARY_PREFIX.length(), prop.lastIndexOf(46));
                    Library lib = this.refHelper.findLibrary(eval);
                    if (lib == null) continue;
                    if (otherSourceRoots == null) {
                        otherSourceRoots = this.computeOtherRootLibraries();
                    }
                    ImageIcon libIcon = ImageUtilities.loadImageIcon(LIBRARIES_ICON, false);
                    boolean shared = false;
                    for (URL rootUrl : lib.getContent("classpath")) {
                        String displayName;
                        rootsList.add(rootUrl);
                        FileObject root = URLMapper.findFileObject(rootUrl);
                        if (root == null || !root.isFolder()) continue;
                        shared |= otherSourceRoots.contains(URLMapper.findURL(root, 0));
                        if ("jar".equals(rootUrl.getProtocol())) {
                            file = FileUtil.getArchiveFile(root);
                            displayName = ((FileObject)file).getNameExt();
                        } else {
                            file = FileUtil.toFile(root);
                            displayName = file != null ? ((File)file).getAbsolutePath() : root.getNameExt();
                        }
                        displayName = MessageFormat.format(NbBundle.getMessage(LibrariesNode.class, "TXT_LibraryPartFormat"), lib.getDisplayName(), displayName);
                        LibrariesSourceGroup sg = new LibrariesSourceGroup(root, displayName, libIcon, libIcon);
                        result.add(Key.library(sg, currentClassPath, propName, preRemoveAction, postRemoveAction, shared));
                    }
                    continue;
                }
                if (prop.startsWith(ANT_ARTIFACT_PREFIX)) {
                    Object[] ref = this.refHelper.findArtifactAndLocation(prop);
                    if (otherSourceRoots == null) {
                        otherSourceRoots = this.computeOtherRootLibraries();
                    }
                    if (ref[0] == null || ref[1] == null) continue;
                    AntArtifact artifact = (AntArtifact)ref[0];
                    URI uri = (URI)ref[1];
                    URL root = null;
                    try {
                        URI absoluteURI = uri.isAbsolute() ? uri : artifact.getProject().getProjectDirectory().toURI().resolve(uri);
                        root = absoluteURI.toURL();
                    }
                    catch (MalformedURLException absoluteURI) {
                        // empty catch block
                    }
                    result.add(Key.project(artifact, uri, currentClassPath, propName, preRemoveAction, postRemoveAction, otherSourceRoots.contains(root)));
                    continue;
                }
                if (prop.startsWith(FILE_REF_PREFIX)) {
                    String evaluatedRef;
                    if (otherSourceRoots == null) {
                        otherSourceRoots = this.computeOtherRootLibraries();
                    }
                    if ((evaluatedRef = this.eval.getProperty(propName)) == null) continue;
                    File file = this.helper.getAntProjectHelper().resolveFile(evaluatedRef);
                    Collection<SourceGroup> sgs = fileRefMapper.apply(Pair.of(file, rootsList));
                    for (SourceGroup sg : sgs) {
                        result.add(Key.fileReference(sg, currentClassPath, propName, preRemoveAction, postRemoveAction, otherSourceRoots.contains(sg.getRootFolder().toURL())));
                    }
                    continue;
                }
                if (prop.startsWith(REF_PREFIX)) {
                    result.addAll(this.getKeys(projectSharedProps, projectPrivateProps, privateProps, propName, toIgnre, fileRefMapper, preRemoveAction, postRemoveAction, rootsList));
                    continue;
                }
                if (otherSourceRoots == null) {
                    otherSourceRoots = this.computeOtherRootLibraries();
                }
                File file = this.helper.getAntProjectHelper().resolveFile(prop);
                Collection<SourceGroup> sgs = fileRefMapper.apply(Pair.of(file, rootsList));
                for (SourceGroup sg : sgs) {
                    result.add(Key.file(sg, currentClassPath, propName, preRemoveAction, postRemoveAction, otherSourceRoots.contains(sg.getRootFolder())));
                }
            }
            return result;
        }

        private void listenOnCompilerOptions() {
            if (this.coResult.get() == null && this.sourcePath != null) {
                FileObject[] rootFos = this.sourcePath.getRoots();
                if (rootFos.length > 0) {
                    CompilerOptionsQuery.Result cor;
                    PropertyChangeListener[] ls = this.sourceRootsListener.getAndSet(null);
                    if (ls != null) {
                        this.sourcePath.removePropertyChangeListener(ls[1]);
                    }
                    if (this.coResult.compareAndSet(null, cor = CompilerOptionsQuery.getOptions(rootFos[0]))) {
                        cor.addChangeListener(WeakListeners.change(this, cor));
                    }
                } else {
                    PropertyChangeListener[] ls = this.sourceRootsListener.get();
                    if (ls == null && this.sourceRootsListener.compareAndSet(null, ls = new PropertyChangeListener[]{e -> {
                        if ("roots".equals(e.getPropertyName())) {
                            this.listenOnCompilerOptions();
                            this.reset(false);
                        }
                    }, WeakListeners.propertyChange(ls[0], this.sourcePath)})) {
                        this.sourcePath.addPropertyChangeListener(ls[1]);
                    }
                }
            }
        }

        private static SourceGroup createFileSourceGroup(File file, Collection<? super URL> rootsList) {
            String displayName;
            Icon icon;
            Icon openedIcon;
            URL url = FileUtil.urlForArchiveOrDir(file);
            if (url == null) {
                return null;
            }
            if ("jar".equals(url.getProtocol())) {
                openedIcon = ImageUtilities.loadImageIcon(ARCHIVE_ICON, false);
                icon = openedIcon;
                displayName = file.getName();
            } else {
                icon = LibrariesNode.getFolderIcon(false);
                openedIcon = LibrariesNode.getFolderIcon(true);
                displayName = file.getAbsolutePath();
            }
            rootsList.add(url);
            FileObject root = URLMapper.findFileObject(url);
            if (root != null) {
                return new LibrariesSourceGroup(root, displayName, icon, openedIcon);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset(boolean testBroken) {
            LibrariesChildren librariesChildren = this;
            synchronized (librariesChildren) {
                if (this.fsListener != null) {
                    this.fsListener.removePropertyChangeListener(this);
                    this.fsListener = null;
                }
            }
            rp.post(() -> {
                LogicalViewProvider2 lvp;
                this.setKeys(this.getKeys());
                if (testBroken && (lvp = this.project.getLookup().lookup(LogicalViewProvider2.class)) != null) {
                    lvp.testBroken();
                }
            });
        }

        private static final class CPMapper
        implements Function<Pair<File, Collection<? super URL>>, Collection<SourceGroup>> {
            static final Function<Pair<File, Collection<? super URL>>, Collection<SourceGroup>> INSTANCE = new CPMapper();

            private CPMapper() {
            }

            @Override
            @NonNull
            public Collection<SourceGroup> apply(@NonNull Pair<File, Collection<? super URL>> param) {
                Collection<? super URL> rootsList;
                File file = param.first();
                SourceGroup sg = LibrariesChildren.createFileSourceGroup(file, rootsList = param.second());
                return sg != null ? Collections.singleton(sg) : Collections.emptySet();
            }
        }

        private static final class RemoveFromModuleInfo
        implements Consumer<Pair<String, String>> {
            private final UpdateHelper helper;
            private final PropertyEvaluator eval;
            private final ClassPath sourcePath;

            RemoveFromModuleInfo(@NonNull UpdateHelper helper, @NonNull PropertyEvaluator eval, @NullAllowed ClassPath sourcePath) {
                this.helper = helper;
                this.eval = eval;
                this.sourcePath = sourcePath;
            }

            @Override
            public void accept(@NonNull Pair<String, String> t) {
                String ref = this.eval.evaluate(t.second());
                if (ref != null) {
                    for (FileObject[] srcRoots : this.findSourceRoots()) {
                        FileObject moduleInfo = LibrariesNode.findModuleInfo(srcRoots);
                        if (moduleInfo == null) continue;
                        Set<String> modules = Arrays.stream(PropertyUtils.tokenizePath(ref)).flatMap(pe -> ModulesFinder.INSTANCE.apply(this.helper.getAntProjectHelper().resolveFile((String)pe)).stream()).map(FileUtil::urlForArchiveOrDir).filter(url -> url != null).map(url -> SourceUtils.getModuleName(url, true)).filter(name -> name != null).collect(Collectors.toSet());
                        DefaultProjectModulesModifier.removeRequiredModules(moduleInfo, modules);
                    }
                }
            }

            @NonNull
            private FileObject[][] findSourceRoots() {
                Predicate<FileObject> accepts;
                ArrayList<FileObject[]> res = new ArrayList<FileObject[]>();
                if (this.sourcePath != null) {
                    res.add(this.sourcePath.getRoots());
                    HashSet rs = new HashSet();
                    this.sourcePath.entries().stream().map(ClassPath.Entry::getURL).forEach(rs::add);
                    accepts = p -> {
                        List<URL> s4t = Arrays.asList(UnitTestForSourceQuery.findSources(p));
                        return !s4t.isEmpty() && rs.containsAll(s4t);
                    };
                } else {
                    accepts = p -> true;
                }
                Project p2 = FileOwnerQuery.getOwner(this.helper.getAntProjectHelper().getProjectDirectory());
                if (p2 != null) {
                    HashSet<ClassPath> seen = new HashSet<ClassPath>();
                    for (SourceGroup sg : ProjectUtils.getSources(p2).getSourceGroups("java")) {
                        FileObject[] sr;
                        ClassPath src = ClassPath.getClassPath(sg.getRootFolder(), "classpath/source");
                        if (src == null || !seen.add(src) || !Arrays.stream(sr = src.getRoots()).allMatch(accepts)) continue;
                        res.add(sr);
                    }
                }
                return (FileObject[][])res.toArray((T[])new FileObject[0][]);
            }
        }

        private static final class MPMapper
        implements Function<Pair<File, Collection<? super URL>>, Collection<SourceGroup>> {
            static final Function<Pair<File, Collection<? super URL>>, Collection<SourceGroup>> INSTANCE = new MPMapper();

            private MPMapper() {
            }

            @Override
            @NonNull
            public Collection<SourceGroup> apply(@NonNull Pair<File, Collection<? super URL>> param) {
                Collection<File> modules = ModulesFinder.INSTANCE.apply(param.first());
                return modules.stream().map(f -> LibrariesChildren.createFileSourceGroup(f, (Collection)param.second())).filter(sg -> sg != null).collect(Collectors.toList());
            }
        }

        private static final class ModulesFinder
        implements Function<File, Collection<File>> {
            static Function<File, Collection<File>> INSTANCE = new ModulesFinder();

            private ModulesFinder() {
            }

            @Override
            @NonNull
            public Collection<File> apply(@NonNull File file) {
                ArrayList<File> entries = new ArrayList<File>();
                if (file.isDirectory()) {
                    if (new File(file, "module-info.class").exists()) {
                        entries.add(file);
                    } else {
                        Optional.ofNullable(file.listFiles(f -> {
                            try {
                                return FileUtil.isArchiveFile(BaseUtilities.toURI(f).toURL());
                            }
                            catch (MalformedURLException e) {
                                Exceptions.printStackTrace(e);
                                return false;
                            }
                        })).ifPresent(fs -> Collections.addAll(entries, fs));
                    }
                } else {
                    entries.add(file);
                }
                return entries;
            }
        }
    }

    private static final class PathFinder
    implements org.netbeans.spi.project.ui.PathFinder {
        PathFinder() {
        }

        @Override
        public Node findPath(Node root, Object target) {
            Node node;
            org.netbeans.spi.project.ui.PathFinder pf;
            Node result = null;
            Node[] nodeArray = root.getChildren().getNodes(true);
            int n = nodeArray.length;
            for (int i = 0; i < n && ((pf = (node = nodeArray[i]).getLookup().lookup(org.netbeans.spi.project.ui.PathFinder.class)) == null || (result = pf.findPath(node, target)) == null); ++i) {
            }
            return result;
        }
    }

    private static class AddProjectAction
    extends AbstractAction
    implements ContextAwareAction {
        private final Project project;
        private final Supplier<FileObject[]> sources;

        public AddProjectAction(Project project, Supplier<FileObject[]> sources) {
            super(NbBundle.getMessage(LibrariesNode.class, "LBL_AddProject_Action"));
            this.project = project;
            this.sources = sources;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AntArtifactItem[] ai = AntArtifactItem.showAntArtifactItemChooser(new String[]{"jar", "folder"}, this.project, null);
            if (ai != null) {
                this.addArtifacts(ai);
            }
        }

        @Override
        public boolean isEnabled() {
            return this.sources.get().length > 0;
        }

        private void addArtifacts(AntArtifactItem[] artifactItems) {
            FileObject[] roots = this.sources.get();
            if (roots.length == 0) {
                return;
            }
            FileObject projectSourcesArtifact = roots[0];
            AntArtifact[] artifacts = new AntArtifact[artifactItems.length];
            URI[] artifactURIs = new URI[artifactItems.length];
            for (int i = 0; i < artifactItems.length; ++i) {
                artifacts[i] = artifactItems[i].getArtifact();
                artifactURIs[i] = artifactItems[i].getArtifactURI();
            }
            try {
                FileObject moduleInfo = LibrariesNode.findModuleInfo(roots);
                String cpType = moduleInfo != null ? "modules/compile" : "classpath/compile";
                ProjectClassPathModifier.addAntArtifacts(artifacts, artifactURIs, projectSourcesArtifact, cpType);
                DefaultProjectModulesModifier.extendModuleInfo(moduleInfo, Arrays.asList(LibrariesNode.toURLs(artifactItems)));
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace(ioe);
            }
            catch (UnsupportedOperationException e) {
                LibrariesNode.handlePCPMUnsupported(this.sources, e);
            }
        }

        @Override
        @NonNull
        public Action createContextAwareInstance(@NonNull Lookup actionContext) {
            ClassPath scp = actionContext.lookup(ClassPath.class);
            Supplier<FileObject[]> ctx = scp != null ? scp::getRoots : this.sources;
            return new AddProjectAction(this.project, ctx);
        }
    }

    private static class AddLibraryAction
    extends AbstractAction
    implements ContextAwareAction {
        private final LibraryChooser.Filter filter;
        private final Supplier<FileObject[]> sources;
        private ReferenceHelper refHelper;

        public AddLibraryAction(ReferenceHelper refHelper, Supplier<FileObject[]> sources, LibraryChooser.Filter filter) {
            super(NbBundle.getMessage(LibrariesNode.class, "LBL_AddLibrary_Action"));
            this.refHelper = refHelper;
            this.sources = sources;
            this.filter = filter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Set<Library> added = LibraryChooser.showDialog(this.refHelper.getProjectLibraryManager(), this.filter, CustomizerUtilities.getLibraryChooserImportHandler(this.refHelper));
            if (added != null) {
                this.addLibraries(added.toArray(new Library[0]));
            }
        }

        @Override
        public boolean isEnabled() {
            return this.sources.get().length > 0;
        }

        private void addLibraries(Library[] libraries) {
            FileObject[] roots = this.sources.get();
            if (roots.length == 0) {
                return;
            }
            FileObject projectSourcesArtifact = roots[0];
            try {
                FileObject moduleInfo = LibrariesNode.findModuleInfo(roots);
                String cpType = moduleInfo != null ? "modules/compile" : "classpath/compile";
                ProjectClassPathModifier.addLibraries(libraries, projectSourcesArtifact, cpType);
                DefaultProjectModulesModifier.extendModuleInfo(moduleInfo, Arrays.asList(LibrariesNode.toURLs(libraries)));
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace(ioe);
            }
            catch (UnsupportedOperationException e) {
                LibrariesNode.handlePCPMUnsupported(this.sources, e);
            }
        }

        @Override
        @NonNull
        public Action createContextAwareInstance(Lookup actionContext) {
            ClassPath scp = actionContext.lookup(ClassPath.class);
            Supplier<FileObject[]> ctx = scp != null ? scp::getRoots : this.sources;
            return new AddLibraryAction(this.refHelper, ctx, this.filter);
        }
    }

    private static class AddFolderAction
    extends AbstractAction
    implements ContextAwareAction {
        private final AntProjectHelper helper;
        private final Supplier<FileObject[]> sources;

        public AddFolderAction(AntProjectHelper helper, Supplier<FileObject[]> sources) {
            super(NbBundle.getMessage(LibrariesNode.class, "LBL_AddFolder_Action"));
            this.helper = helper;
            this.sources = sources;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileChooser chooser = this.helper.isSharableProject() ? new FileChooser(this.helper, true) : new FileChooser(FileUtil.toFile(this.helper.getProjectDirectory()), null);
            chooser.enableVariableBasedSelection(true);
            chooser.setFileHidingEnabled(false);
            FileUtil.preventFileChooserSymlinkTraversal(chooser, null);
            chooser.setFileSelectionMode(2);
            chooser.setMultiSelectionEnabled(true);
            chooser.setDialogTitle(NbBundle.getMessage(LibrariesNode.class, "LBL_AddJar_DialogTitle"));
            chooser.setAcceptAllFileFilterUsed(false);
            SimpleFileFilter fileFilter = new SimpleFileFilter(NbBundle.getMessage(LibrariesNode.class, "LBL_ZipJarFolderFilter"));
            chooser.setFileFilter(fileFilter);
            File curDir = EditMediator.getLastUsedClassPathFolder();
            chooser.setCurrentDirectory(curDir);
            int option = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
            if (option == 0) {
                String[] filePaths;
                try {
                    filePaths = chooser.getSelectedPaths();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace(ex);
                    return;
                }
                this.addJarOrFolder(filePaths, chooser.getSelectedPathVariables(), fileFilter, FileUtil.toFile(this.helper.getProjectDirectory()));
                curDir = FileUtil.normalizeFile(chooser.getCurrentDirectory());
                EditMediator.setLastUsedClassPathFolder(curDir);
            }
        }

        @Override
        public boolean isEnabled() {
            return this.sources.get().length > 0;
        }

        private void addJarOrFolder(String[] filePaths, String[] pathBasedVariables, FileFilter fileFilter, File base) {
            FileObject[] roots = this.sources.get();
            if (roots.length == 0) {
                return;
            }
            try {
                FileObject projectSourcesArtifact = roots[0];
                ArrayList<URI> toAdd = new ArrayList<URI>(filePaths.length);
                ArrayList<URL> toAddURLs = new ArrayList<URL>(toAdd.size());
                Function<File, Collection<File>> moduleFinder = LibrariesChildren.ModulesFinder.INSTANCE;
                for (int i = 0; i < filePaths.length; ++i) {
                    URI u;
                    Collection<File> sgs;
                    File fl = PropertyUtils.resolveFile(base, filePaths[i]);
                    FileObject fo = FileUtil.toFileObject(fl);
                    assert (fo != null || !fl.canRead()) : fl;
                    if (fo == null || !fileFilter.accept(fl)) continue;
                    boolean isFolderOfModules = false;
                    if (fo.isFolder() && ((sgs = moduleFinder.apply(fl)).size() != 1 || !fl.equals(sgs.iterator().next()))) {
                        isFolderOfModules = true;
                    }
                    if (!isFolderOfModules) {
                        Optional.ofNullable(FileUtil.urlForArchiveOrDir(fl)).ifPresent(toAddURLs::add);
                    }
                    boolean isArchiveFile = FileUtil.isArchiveFile(fo);
                    if (pathBasedVariables == null) {
                        u = LibrariesSupport.convertFilePathToURI(filePaths[i]);
                    } else {
                        try {
                            Object path = pathBasedVariables[i];
                            if (!isArchiveFile && !((String)path).endsWith("/")) {
                                path = (String)path + "/";
                            }
                            u = new URI(null, null, (String)path, null);
                        }
                        catch (URISyntaxException ex) {
                            Exceptions.printStackTrace(ex);
                            u = LibrariesSupport.convertFilePathToURI(filePaths[i]);
                        }
                    }
                    if (isArchiveFile) {
                        try {
                            new JarFile(fl);
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(LibrariesNode.class, "LBL_Corrupted_JAR", fl), NbBundle.getMessage(LibrariesNode.class, "LBL_Corrupted_JAR_title"), 2);
                            continue;
                        }
                        u = LibrariesSupport.getArchiveRoot(u);
                    } else if (!u.toString().endsWith("/")) {
                        try {
                            u = new URI(u.toString() + "/");
                        }
                        catch (URISyntaxException ex) {
                            throw new AssertionError((Object)ex);
                        }
                    }
                    assert (u != null);
                    toAdd.add(u);
                }
                Project prj = FileOwnerQuery.getOwner(this.helper.getProjectDirectory());
                ClassPathModifier modifierImpl = prj.getLookup().lookup(ClassPathModifier.class);
                if (modifierImpl == null) {
                    throw new IllegalStateException(String.format("Project: %s (located in: %s) does not provide ClassPathModifier in Lookup.", prj, FileUtil.getFileDisplayName(prj.getProjectDirectory())));
                }
                FileObject moduleInfo = LibrariesNode.findModuleInfo(roots);
                String cpType = moduleInfo != null ? "modules/compile" : "classpath/compile";
                modifierImpl.addRoots(toAdd.toArray(new URI[0]), LibrariesNode.findSourceGroup(projectSourcesArtifact, modifierImpl), cpType, 3);
                DefaultProjectModulesModifier.extendModuleInfo(moduleInfo, toAddURLs);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace(ioe);
            }
        }

        @Override
        public Action createContextAwareInstance(Lookup actionContext) {
            ClassPath scp = actionContext.lookup(ClassPath.class);
            Supplier<FileObject[]> ctx = scp != null ? scp::getRoots : this.sources;
            return new AddFolderAction(this.helper, ctx);
        }
    }

    private static class RootsListener
    implements FileChangeListener {
        static final String PROP_ROOTS = "roots";
        private final PropertyChangeSupport support = new PropertyChangeSupport(this);
        private final Collection<File> listensOn;
        private final AtomicInteger state = new AtomicInteger();

        /*
         * WARNING - void declaration
         */
        RootsListener(List<? extends URL> roots) {
            this.listensOn = new HashSet<File>();
            for (URL uRL : roots) {
                try {
                    void var3_3;
                    URL archiveURL = FileUtil.getArchiveFile(uRL);
                    if (archiveURL != null) {
                        URL uRL2 = archiveURL;
                    }
                    this.listensOn.add(BaseUtilities.toFile(var3_3.toURI()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }

        public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull("listener", listener);
            if (!this.state.compareAndSet(0, 1)) {
                throw new IllegalStateException("Already in state: " + this.state.get());
            }
            this.support.addPropertyChangeListener(listener);
            for (File f : this.listensOn) {
                FileUtil.addFileChangeListener(this, f);
            }
        }

        public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull("listener", listener);
            if (!this.state.compareAndSet(1, 2)) {
                throw new IllegalStateException("Already in state: " + this.state.get());
            }
            this.support.removePropertyChangeListener(listener);
            for (File f : this.listensOn) {
                FileUtil.removeFileChangeListener(this, f);
            }
        }

        @Override
        public void fileFolderCreated(FileEvent fe) {
            this.fire();
        }

        @Override
        public void fileDataCreated(FileEvent fe) {
            this.fire();
        }

        @Override
        public void fileChanged(FileEvent fe) {
            this.fire();
        }

        @Override
        public void fileDeleted(FileEvent fe) {
            this.fire();
        }

        @Override
        public void fileRenamed(FileRenameEvent fe) {
            this.fire();
        }

        @Override
        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        private void fire() {
            this.support.firePropertyChange(PROP_ROOTS, null, null);
        }
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private final Set<String> extensions;

        public SimpleFileFilter(String description) {
            this.description = description;
            this.extensions = new HashSet<String>();
            this.extensions.addAll(FileUtil.getMIMETypeExtensions("application/x-java-archive"));
        }

        @Override
        public boolean accept(File f) {
            block5: {
                if (f.isDirectory()) {
                    return true;
                }
                try {
                    if (!this.extensions.isEmpty()) {
                        String fileName = f.getName();
                        int index = fileName.lastIndexOf(46);
                        if (index > 0 && index < fileName.length() - 1) {
                            return this.extensions.contains(fileName.substring(index + 1));
                        }
                        break block5;
                    }
                    return FileUtil.isArchiveFile(BaseUtilities.toURI(f).toURL());
                }
                catch (MalformedURLException mue) {
                    Exceptions.printStackTrace(mue);
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    public static final class Key {
        static final int TYPE_PLATFORM = 0;
        static final int TYPE_LIBRARY = 1;
        static final int TYPE_FILE_REFERENCE = 2;
        static final int TYPE_PROJECT = 3;
        static final int TYPE_OTHER = 4;
        static final int TYPE_FILE = 5;
        static final int TYPE_MODULE = 6;
        private int type;
        private String classPathId;
        private String entryId;
        private SourceGroup sg;
        private AntArtifact antArtifact;
        private URI uri;
        private String anID;
        private final Consumer<Pair<String, String>> preRemoveAction;
        private final Consumer<Pair<String, String>> postRemoveAction;
        private final boolean shared;

        private static Key platform() {
            return new Key();
        }

        private static Key project(@NonNull AntArtifact a, @NonNull URI uri, @NonNull String classPathId, @NonNull String entryId, @NullAllowed Consumer<Pair<String, String>> preRemoveAction, @NullAllowed Consumer<Pair<String, String>> postRemoveAction, boolean shared) {
            return new Key(a, uri, classPathId, entryId, preRemoveAction, postRemoveAction, shared);
        }

        private static Key library(@NonNull SourceGroup sg, @NonNull String classPathId, @NonNull String entryId, @NullAllowed Consumer<Pair<String, String>> preRemoveAction, @NullAllowed Consumer<Pair<String, String>> postRemoveAction, boolean shared) {
            return new Key(1, sg, classPathId, entryId, preRemoveAction, postRemoveAction, shared);
        }

        private static Key fileReference(@NonNull SourceGroup sg, @NonNull String classPathId, @NonNull String entryId, @NullAllowed Consumer<Pair<String, String>> preRemoveAction, @NullAllowed Consumer<Pair<String, String>> postRemoveAction, boolean shared) {
            return new Key(2, sg, classPathId, entryId, preRemoveAction, postRemoveAction, shared);
        }

        private static Key file(@NonNull SourceGroup sg, @NonNull String classPathId, @NonNull String entryId, @NullAllowed Consumer<Pair<String, String>> preRemoveAction, @NullAllowed Consumer<Pair<String, String>> postRemoveAction, boolean shared) {
            return new Key(5, sg, classPathId, entryId, preRemoveAction, postRemoveAction, shared);
        }

        @NonNull
        private static Key module(@NonNull String moduleName, @NonNull URI uri, @NullAllowed Consumer<Pair<String, String>> preRemoveAction, @NullAllowed Consumer<Pair<String, String>> postRemoveAction) {
            return new Key(moduleName, uri, preRemoveAction, postRemoveAction);
        }

        public Key(String anID) {
            this.type = 4;
            this.anID = anID;
            this.postRemoveAction = null;
            this.preRemoveAction = null;
            this.shared = false;
        }

        private Key() {
            this.type = 0;
            this.postRemoveAction = null;
            this.preRemoveAction = null;
            this.shared = false;
        }

        private Key(@NonNull String moduleName, @NonNull URI uri, @NullAllowed Consumer<Pair<String, String>> preRemoveAction, @NullAllowed Consumer<Pair<String, String>> postRemoveAction) {
            assert (moduleName != null);
            assert (uri != null);
            this.type = 6;
            this.entryId = moduleName;
            this.uri = uri;
            this.preRemoveAction = preRemoveAction;
            this.postRemoveAction = postRemoveAction;
            this.shared = false;
        }

        private Key(int type, @NonNull SourceGroup sg, @NonNull String classPathId, @NonNull String entryId, @NullAllowed Consumer<Pair<String, String>> preRemoveAction, @NullAllowed Consumer<Pair<String, String>> postRemoveAction, boolean shared) {
            assert (type == 1 || type == 2 || type == 5);
            this.type = type;
            this.sg = sg;
            this.classPathId = classPathId;
            this.entryId = entryId;
            this.preRemoveAction = preRemoveAction;
            this.postRemoveAction = postRemoveAction;
            this.shared = shared;
        }

        private Key(@NonNull AntArtifact a, @NonNull URI uri, @NonNull String classPathId, @NonNull String entryId, @NullAllowed Consumer<Pair<String, String>> preRemoveAction, @NullAllowed Consumer<Pair<String, String>> postRemoveAction, boolean shared) {
            this.type = 3;
            this.antArtifact = a;
            this.uri = uri;
            this.classPathId = classPathId;
            this.entryId = entryId;
            this.preRemoveAction = preRemoveAction;
            this.postRemoveAction = postRemoveAction;
            this.shared = shared;
        }

        public int getType() {
            return this.type;
        }

        public String getClassPathId() {
            return this.classPathId;
        }

        public String getEntryId() {
            return this.entryId;
        }

        public SourceGroup getSourceGroup() {
            return this.sg;
        }

        public AntArtifact getProject() {
            return this.antArtifact;
        }

        public URI getArtifactLocation() {
            return this.uri;
        }

        public String getID() {
            return this.anID;
        }

        @CheckForNull
        URI toURI() {
            if (this.sg != null) {
                return this.sg.getRootFolder().toURI();
            }
            if (this.antArtifact != null) {
                return Optional.ofNullable(LibrariesNode.resolveAntArtifact(this.antArtifact, this.uri)).map(u -> {
                    try {
                        return u.toURI();
                    }
                    catch (URISyntaxException ex) {
                        Exceptions.printStackTrace(ex);
                        return null;
                    }
                }).orElse(null);
            }
            if (this.type == 6) {
                return this.uri;
            }
            return null;
        }

        @CheckForNull
        Consumer<Pair<String, String>> getPreRemoveAction() {
            return this.preRemoveAction;
        }

        @CheckForNull
        Consumer<Pair<String, String>> getPostRemoveAction() {
            return this.postRemoveAction;
        }

        public int hashCode() {
            int hashCode = this.type << 16;
            switch (this.type) {
                case 1: 
                case 2: 
                case 5: {
                    hashCode ^= this.sg == null ? 0 : this.sg.hashCode();
                    break;
                }
                case 3: {
                    hashCode ^= this.antArtifact == null ? 0 : this.antArtifact.hashCode();
                    break;
                }
                case 6: {
                    hashCode ^= this.entryId.hashCode();
                    break;
                }
                case 4: {
                    hashCode ^= this.anID.hashCode();
                }
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (other.type != this.type) {
                return false;
            }
            switch (this.type) {
                case 1: 
                case 2: 
                case 5: {
                    return (this.sg == null ? other.sg == null : this.sg.equals(other.sg)) && (this.classPathId == null ? other.classPathId == null : this.classPathId.equals(other.classPathId)) && (this.entryId == null ? other.entryId == null : this.entryId.equals(other.entryId));
                }
                case 3: {
                    return (this.antArtifact == null ? other.antArtifact == null : this.antArtifact.equals(other.antArtifact)) && (this.classPathId == null ? other.classPathId == null : this.classPathId.equals(other.classPathId)) && (this.entryId == null ? other.entryId == null : this.entryId.equals(other.entryId));
                }
                case 0: {
                    return true;
                }
                case 6: {
                    return this.entryId.equals(other.entryId) && this.uri.equals(other.uri);
                }
                case 4: {
                    return this.anID.equals(other.anID);
                }
            }
            throw new IllegalStateException();
        }
    }

    public static final class Builder {
        private final Project project;
        private final PropertyEvaluator eval;
        private final UpdateHelper helper;
        private final ReferenceHelper refHelper;
        private final ClassPathSupport cs;
        private final Set<String> classPathIgnoreRef = new HashSet<String>();
        private final Set<String> modulePathIgnoreRef = new HashSet<String>();
        private final List<Action> librariesNodeActions = new ArrayList<Action>();
        private final List<String> classPathProperties = new ArrayList<String>();
        private String name = NbBundle.getMessage(LibrariesNode.class, "TXT_LibrariesNode");
        private Pair<Pair<String, String>, ClassPath> boot = Pair.of(Pair.of(null, null), null);
        private Pair<Set<String>, ClassPath> modulePath;
        private String webModuleElementName;
        private NodeList<Key> extraNodes;
        private ClassPath sourcePath;
        private ClassPath moduleSourcePath;

        public Builder(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper helper, @NonNull ReferenceHelper refHelper, @NonNull ClassPathSupport cs) {
            Parameters.notNull("project", project);
            Parameters.notNull("eval", eval);
            Parameters.notNull("helper", helper);
            Parameters.notNull("refHelper", refHelper);
            Parameters.notNull("cs", cs);
            this.project = project;
            this.eval = eval;
            this.helper = helper;
            this.refHelper = refHelper;
            this.cs = cs;
        }

        @NonNull
        public Builder setName(@NonNull String name) {
            Parameters.notNull("name", name);
            this.name = name;
            return this;
        }

        @NonNull
        public Builder addClassPathIgnoreRefs(String ... refs) {
            Parameters.notNull("refs", refs);
            Collections.addAll(this.classPathIgnoreRef, refs);
            return this;
        }

        @NonNull
        public Builder addClassPathProperties(String ... propNames) {
            Parameters.notNull("propNames", propNames);
            Collections.addAll(this.classPathProperties, propNames);
            return this;
        }

        @NonNull
        public Builder setPlatformType(@NonNull String platformType) {
            Parameters.notNull("platformType", platformType);
            this.boot = Pair.of(Pair.of(this.boot.first().first(), platformType), this.boot.second());
            return this;
        }

        @NonNull
        public Builder setPlatformProperty(@NonNull String platformProperty) {
            Parameters.notNull("platformProperty", platformProperty);
            this.boot = Pair.of(Pair.of(platformProperty, this.boot.first().second()), this.boot.second());
            return this;
        }

        @NonNull
        public Builder setBootPath(@NonNull ClassPath bootPath) {
            Parameters.notNull("bootPath", bootPath);
            this.boot = Pair.of(this.boot.first(), bootPath);
            return this;
        }

        @NonNull
        public Builder addLibrariesNodeActions(Action ... actions) {
            Parameters.notNull("actions", actions);
            Collections.addAll(this.librariesNodeActions, actions);
            return this;
        }

        @NonNull
        public Builder setWebModuleElementName(@NonNull String elementName) {
            Parameters.notNull("elementName", elementName);
            this.webModuleElementName = elementName;
            return this;
        }

        @NonNull
        public Builder setExtraNodes(@NonNull NodeList<Key> extraNodes) {
            Parameters.notNull("extraNodes", extraNodes);
            this.extraNodes = extraNodes;
            return this;
        }

        @NonNull
        public Builder setModuleInfoBasedPath(@NonNull ClassPath moduleInfoBasedClassPath) {
            Parameters.notNull("moduleInfoBasedClassPath", moduleInfoBasedClassPath);
            this.modulePath = Pair.of(this.modulePath == null ? new HashSet() : this.modulePath.first(), moduleInfoBasedClassPath);
            return this;
        }

        @NonNull
        public Builder addModulePathProperties(String ... props) {
            Parameters.notNull("props", props);
            if (this.modulePath == null) {
                this.modulePath = Pair.of(new HashSet(), null);
            }
            Collections.addAll((Collection)this.modulePath.first(), props);
            return this;
        }

        @NonNull
        public Builder addModulePathIgnoreRefs(String ... refs) {
            Parameters.notNull("refs", refs);
            Collections.addAll(this.modulePathIgnoreRef, refs);
            return this;
        }

        @NonNull
        public Builder setSourcePath(@NonNull ClassPath sourcePath) {
            Parameters.notNull("sourcePath", sourcePath);
            this.sourcePath = sourcePath;
            return this;
        }

        @NonNull
        public Builder setModuleSourcePath(@NonNull ClassPath moduleSourcePath) {
            Parameters.notNull("moduleSourcePath", moduleSourcePath);
            this.moduleSourcePath = moduleSourcePath;
            return this;
        }

        @NonNull
        public LibrariesNode build() {
            Pair<Pair<String, String>, ClassPath> _boot = this.boot;
            if (_boot.first().first() == null) {
                if (_boot.second() != null || _boot.first().second() != null) {
                    throw new IllegalStateException("PlatformType or bootPath given but no platformProperty");
                }
                _boot = null;
            }
            return new LibrariesNode(this.name, this.project, this.eval, this.helper, this.refHelper, this.classPathProperties, this.classPathIgnoreRef, _boot, this.modulePath, this.modulePathIgnoreRef, this.librariesNodeActions.toArray(new Action[0]), this.webModuleElementName, this.cs, this.extraNodes != null ? new CallBackImpl(this.extraNodes) : null, this.sourcePath, this.moduleSourcePath);
        }

        private static final class CallBackImpl
        implements Callback {
            private final NodeList<Key> delegate;

            CallBackImpl(@NonNull NodeList<Key> nodeList) {
                Parameters.notNull("nodeList", nodeList);
                this.delegate = nodeList;
            }

            @Override
            @NonNull
            public List<Key> getExtraKeys() {
                return this.delegate.keys();
            }

            @Override
            @NonNull
            public Node[] createNodes(Key key) {
                Node[] nodeArray;
                Node node = this.delegate.node(key);
                if (node != null) {
                    Node[] nodeArray2 = new Node[1];
                    nodeArray = nodeArray2;
                    nodeArray2[0] = node;
                } else {
                    nodeArray = new Node[]{};
                }
                return nodeArray;
            }
        }
    }
}

