/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.BreakTree;
import jpt.sun.source.tree.CaseTree;
import jpt.sun.source.tree.ContinueTree;
import jpt.sun.source.tree.EnhancedForLoopTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.ForLoopTree;
import jpt.sun.source.tree.IfTree;
import jpt.sun.source.tree.LabeledStatementTree;
import jpt.sun.source.tree.LineMap;
import jpt.sun.source.tree.LiteralTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.NewClassTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.SwitchTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.tree.WhileLoopTree;
import jpt.sun.source.util.SourcePositions;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.Name;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.ArithmeticUtilities;
import org.netbeans.modules.java.hints.bugs.ArrayStringConversions;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.util.NbBundle;

public class Tiny {
    private static final Set<String> METHOD_NAME = new HashSet<String>(Arrays.asList("getString", "getBoolean", "getByte", "getShort", "getInt", "getLong", "getFloat", "getDouble", "getBigDecimal", "getBytes", "getDate", "getTime", "getTimestamp", "getAsciiStream", "getUnicodeStream", "getBinaryStream", "getObject", "getCharacterStream", "getBigDecimal", "updateNull", "updateBoolean", "updateByte", "updateShort", "updateInt", "updateLong", "updateFloat", "updateDouble", "updateBigDecimal", "updateString", "updateBytes", "updateDate", "updateTime", "updateTimestamp", "updateAsciiStream", "updateBinaryStream", "updateCharacterStream", "updateObject", "updateObject", "getObject", "getRef", "getBlob", "getClob", "getArray", "getDate", "getTime", "getTimestamp", "getURL", "updateRef", "updateBlob", "updateClob", "updateArray", "getRowId", "updateRowId", "updateNString", "updateNClob", "getNClob", "getSQLXML", "updateSQLXML", "getNString", "getNCharacterStream", "updateNCharacterStream", "updateAsciiStream", "updateBinaryStream", "updateCharacterStream", "updateBlob", "updateClob", "updateNClob", "updateNCharacterStream", "updateAsciiStream", "updateBinaryStream", "updateCharacterStream", "updateBlob", "updateClob", "updateNClob"));

    public static ErrorDescription singleCharRegex(HintContext ctx) {
        String value;
        Tree constant = ((MethodInvocationTree)ctx.getPath().getLeaf()).getArguments().get(0);
        TreePath constantTP = new TreePath(ctx.getPath(), constant);
        if (constantTP.getLeaf().getKind() == Tree.Kind.STRING_LITERAL && (value = (String)((LiteralTree)constantTP.getLeaf()).getValue()) != null && value.length() == 1 && Tiny.isRegExControlCharacter(value.charAt(0))) {
            String fixDisplayName = NbBundle.getMessage(Tiny.class, "FIX_single-char-regex");
            String displayName = NbBundle.getMessage(Tiny.class, "ERR_single-char-regex");
            Fix fix = JavaFixUtilities.rewriteFix(ctx, fixDisplayName, constantTP, "\"\\\\" + value.charAt(0) + "\"");
            return ErrorDescriptionFactory.forTree(ctx, constant, displayName, fix);
        }
        return null;
    }

    private static boolean isRegExControlCharacter(char c) {
        return c == '.' || c == '$' || c == '|' || c == '^' || c == '?' || c == '*' || c == '+' || c == '\\' || c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}';
    }

    public static ErrorDescription newObject(HintContext ctx) {
        String displayName = NbBundle.getMessage(Tiny.class, "ERR_newObject");
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), displayName, new Fix[0]);
    }

    public static List<ErrorDescription> systemArrayCopy(HintContext ctx) {
        String displayName;
        String treeDisplayName;
        LinkedList<ErrorDescription> result = new LinkedList<ErrorDescription>();
        for (String objName : Arrays.asList("$src", "$dest")) {
            TreePath obj = ctx.getVariables().get(objName);
            TypeMirror type = ctx.getInfo().getTrees().getTypeMirror(obj);
            if (!Utilities.isValidType(type) || type.getKind() == TypeKind.ARRAY) continue;
            treeDisplayName = Utilities.shortDisplayName(ctx.getInfo(), (ExpressionTree)obj.getLeaf());
            displayName = NbBundle.getMessage(Tiny.class, "ERR_system_arraycopy_notarray", treeDisplayName);
            result.add(ErrorDescriptionFactory.forTree(ctx, obj, displayName, new Fix[0]));
        }
        for (String countName : Arrays.asList("$srcPos", "$destPos", "$length")) {
            TreePath count = ctx.getVariables().get(countName);
            Number value = ArithmeticUtilities.compute(ctx.getInfo(), count, true);
            if (value == null || value.intValue() >= 0) continue;
            treeDisplayName = Utilities.shortDisplayName(ctx.getInfo(), (ExpressionTree)count.getLeaf());
            displayName = NbBundle.getMessage(Tiny.class, "ERR_system_arraycopy_negative", treeDisplayName);
            result.add(ErrorDescriptionFactory.forTree(ctx, count, displayName, new Fix[0]));
        }
        return result;
    }

    public static ErrorDescription equalsNull(HintContext ctx) {
        String fixDisplayName = NbBundle.getMessage(Tiny.class, "FIX_equalsNull");
        Fix fix = JavaFixUtilities.rewriteFix(ctx, fixDisplayName, ctx.getPath(), "$obj == null");
        String displayName = NbBundle.getMessage(Tiny.class, "ERR_equalsNull");
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), displayName, fix);
    }

    public static ErrorDescription varTypeDiamondOperator(HintContext ctx) {
        TreePath path = ctx.getPath();
        Boolean isVarUsed = ctx.getInfo().getTreeUtilities().isVarType(path);
        if (!isVarUsed.booleanValue()) {
            return null;
        }
        VariableTree vt = (VariableTree)ctx.getPath().getLeaf();
        NewClassTree nct = (NewClassTree)vt.getInitializer();
        Element constructorCand = ctx.getInfo().getTrees().getElement(new TreePath(ctx.getPath(), nct));
        if (constructorCand.getKind() != ElementKind.CONSTRUCTOR) {
            return null;
        }
        ExecutableElement constructor = (ExecutableElement)constructorCand;
        for (VariableElement variableElement : constructor.getParameters()) {
            DeclaredType dt;
            if (variableElement.asType().getKind() != TypeKind.DECLARED || (dt = (DeclaredType)variableElement.asType()).getTypeArguments().isEmpty()) continue;
            return null;
        }
        String displayName = NbBundle.getMessage(Tiny.class, "ERR_varTypeDiamondOperator");
        return ErrorDescriptionFactory.forTree(ctx, path, displayName, new Fix[0]);
    }

    public static ErrorDescription resultSet(HintContext ctx) {
        TypeElement resultSet = ctx.getInfo().getElements().getTypeElement("java.sql.ResultSet");
        String methodName = ctx.getVariableNames().get("$method");
        if (resultSet == null || !METHOD_NAME.contains(methodName)) {
            return null;
        }
        TreePath columnIndex = ctx.getVariables().get("$columnIndex");
        Number value = ArithmeticUtilities.compute(ctx.getInfo(), columnIndex, true);
        if (value == null) {
            return null;
        }
        int intValue = value.intValue();
        if (intValue > 0) {
            return null;
        }
        Element methodEl = ctx.getInfo().getTrees().getElement(ctx.getPath());
        if (methodEl == null || methodEl.getKind() != ElementKind.METHOD) {
            return null;
        }
        ExecutableElement methodElement = (ExecutableElement)methodEl;
        boolean found = false;
        for (ExecutableElement e : ElementFilter.methodsIn(resultSet.getEnclosedElements())) {
            if (e.equals(methodEl)) {
                found = true;
                break;
            }
            if (!ctx.getInfo().getElements().overrides(methodElement, e, (TypeElement)methodElement.getEnclosingElement())) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        String key = intValue == 0 ? "ERR_ResultSetZero" : "ERR_ResultSetNegative";
        String displayName = NbBundle.getMessage(Tiny.class, key);
        return ErrorDescriptionFactory.forName(ctx, columnIndex, displayName, new Fix[0]);
    }

    public static ErrorDescription indentation(HintContext ctx) {
        List<? extends StatementTree> parentStatements;
        StatementTree firstStatement;
        Tree found = ctx.getPath().getLeaf();
        switch (found.getKind()) {
            case IF: {
                IfTree it = (IfTree)found;
                if (it.getElseStatement() != null) {
                    firstStatement = it.getElseStatement();
                    break;
                }
                firstStatement = it.getThenStatement();
                break;
            }
            case WHILE_LOOP: {
                firstStatement = ((WhileLoopTree)found).getStatement();
                break;
            }
            case FOR_LOOP: {
                firstStatement = ((ForLoopTree)found).getStatement();
                break;
            }
            case ENHANCED_FOR_LOOP: {
                firstStatement = ((EnhancedForLoopTree)found).getStatement();
                break;
            }
            default: {
                return null;
            }
        }
        if (firstStatement != null && firstStatement.getKind() == Tree.Kind.BLOCK) {
            return null;
        }
        Tree parent = ctx.getPath().getParentPath().getLeaf();
        switch (parent.getKind()) {
            case BLOCK: {
                parentStatements = ((BlockTree)parent).getStatements();
                break;
            }
            case CASE: {
                parentStatements = ((CaseTree)parent).getStatements();
                break;
            }
            default: {
                return null;
            }
        }
        int index = parentStatements.indexOf(found);
        if (index < 0 || index + 1 >= parentStatements.size()) {
            return null;
        }
        Tree secondStatement = parentStatements.get(index + 1);
        int firstIndent = Tiny.indent(ctx, firstStatement);
        int secondIndent = Tiny.indent(ctx, secondStatement);
        if (firstIndent == -1 || secondIndent == -1 || firstIndent != secondIndent) {
            return null;
        }
        return ErrorDescriptionFactory.forTree(ctx, secondStatement, Bundle.ERR_indentation(), new Fix[0]);
    }

    private static int indent(HintContext ctx, Tree t) {
        long start = ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getInfo().getCompilationUnit(), t);
        LineMap lm = ctx.getInfo().getCompilationUnit().getLineMap();
        if (start == -1L) {
            return -1;
        }
        long lno = lm.getLineNumber(start);
        if (lno < 1L) {
            return -1;
        }
        long lineStart = lm.getStartPosition(lno);
        String text = ctx.getInfo().getText();
        CodeStyle cs = CodeStyle.getDefault(ctx.getInfo().getFileObject());
        int indent = 0;
        while (start-- > lineStart) {
            char c = text.charAt((int)start);
            if (c == ' ') {
                ++indent;
                continue;
            }
            if (c == '\t') {
                indent += cs.getTabSize();
                continue;
            }
            return -1;
        }
        return indent;
    }

    public static ErrorDescription switchCaseLabelMismatch(HintContext ctx) {
        Element e;
        TreePath path = ctx.getPath();
        if (path.getLeaf().getKind() != Tree.Kind.CASE) {
            return null;
        }
        CompilationInfo ci = ctx.getInfo();
        TreePath switchPath = path.getParentPath();
        Tree swTree = switchPath.getLeaf();
        assert (swTree.getKind() == Tree.Kind.SWITCH);
        ExpressionTree xp = ((SwitchTree)swTree).getExpression();
        TypeMirror m = ci.getTrees().getTypeMirror(new TreePath(switchPath, xp));
        boolean enumType = false;
        if (m != null && m.getKind() == TypeKind.DECLARED && (e = ((DeclaredType)m).asElement()) != null && e.getKind() == ElementKind.ENUM) {
            enumType = true;
        }
        TreePath stPath = ctx.getVariables().get("$stmt");
        TreePath lPath = stPath.getParentPath();
        final LabeledStatementTree lt = (LabeledStatementTree)lPath.getLeaf();
        Name l = lt.getLabel();
        final CompilationInfo info = ctx.getInfo();
        Boolean b = (Boolean)new ErrorAwareTreePathScanner<Boolean, Void>(){

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                if (r1 == null) {
                    return r2;
                }
                if (r2 == null) {
                    return r1;
                }
                return r1 != false || r2 != false;
            }

            @Override
            public Boolean visitContinue(ContinueTree node, Void p) {
                StatementTree t = info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath());
                return lt == t || lt.getStatement() == t;
            }

            @Override
            public Boolean visitBreak(BreakTree node, Void p) {
                StatementTree t = info.getTreeUtilities().getBreakContinueTarget(this.getCurrentPath());
                return lt == t || lt.getStatement() == t;
            }
        }.scan(path, (Void)null);
        if (Boolean.TRUE == b) {
            return null;
        }
        ArrayList<Object> options = new ArrayList<Object>();
        HashSet<Element> resolved = new HashSet<Element>();
        if (enumType) {
            TypeElement te = (TypeElement)((DeclaredType)m).asElement();
            for (Element element : te.getEnclosedElements()) {
                if (element.getKind() != ElementKind.ENUM_CONSTANT || !element.getSimpleName().equals(l)) continue;
                options.add(l.toString());
                break;
            }
        } else {
            for (CaseTree caseTree : ((SwitchTree)swTree).getCases()) {
                Element outer;
                Element el;
                ExpressionTree expressionTree = caseTree.getExpression();
                if (expressionTree == null || expressionTree.getKind() != Tree.Kind.IDENTIFIER && expressionTree.getKind() != Tree.Kind.MEMBER_SELECT || (el = info.getTrees().getElement(new TreePath(path, caseTree.getExpression()))) == null) continue;
                if (expressionTree.getKind() == Tree.Kind.IDENTIFIER && Tiny.tryResolveIdentifier(info, lPath, m, resolved, l.toString())) {
                    options.add(0, l.toString());
                }
                if ((outer = el.getEnclosingElement()) == null || outer.getKind() != ElementKind.CLASS && outer.getKind() != ElementKind.INTERFACE && outer.getKind() != ElementKind.RECORD && outer.getKind() != ElementKind.ENUM) continue;
                TypeElement tel = (TypeElement)outer;
                String x = tel.getSimpleName() + "." + l.toString();
                if (Tiny.tryResolveIdentifier(info, lPath, m, resolved, x)) {
                    options.add(x);
                    continue;
                }
                x = tel.getQualifiedName().toString() + "." + l.toString();
                if (!Tiny.tryResolveIdentifier(info, lPath, m, resolved, x)) continue;
                options.add(x);
            }
        }
        if (options.isEmpty()) {
            return ErrorDescriptionFactory.forName(ctx, lt, Bundle.TEXT_MissingSwitchCase(), new Fix[0]);
        }
        ArrayList<Fix> fixes = new ArrayList<Fix>(options.size());
        for (String string : options) {
            fixes.add(JavaFixUtilities.rewriteFix(ctx, Bundle.FIX_AddMissingSwitchCase(string), lPath, "case " + string + ": $stmt;"));
        }
        return ErrorDescriptionFactory.forName(ctx, lt, Bundle.TEXT_MissingSwitchCase(), fixes.toArray(new Fix[0]));
    }

    private static boolean tryResolveIdentifier(CompilationInfo info, TreePath place, TypeMirror expectedType, Set<Element> resolved, String ident) {
        SourcePositions[] positions = new SourcePositions[1];
        ExpressionTree et = info.getTreeUtilities().parseExpression(ident, positions);
        TypeMirror unqType = info.getTreeUtilities().attributeTree(et, info.getTrees().getScope(place));
        Element e = info.getTrees().getElement(new TreePath(place, et));
        if (!Utilities.isValidType(unqType) || e == null || e.getKind() != ElementKind.FIELD && e.getKind() != ElementKind.ENUM_CONSTANT) {
            return false;
        }
        if (!resolved.add(e)) {
            return false;
        }
        return info.getTypes().isAssignable(unqType, expectedType);
    }

    public static List<ErrorDescription> hashCodeOnArray(HintContext ctx) {
        TreePath arrayRef;
        CompilationInfo ci = ctx.getInfo();
        boolean enableDeep = ArrayStringConversions.canContainArrays(ci, arrayRef = ctx.getVariables().get("$v"));
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>(enableDeep ? 2 : 1);
        TreePathHandle handle = TreePathHandle.create(ctx.getPath(), ci);
        result.add(ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), Bundle.TEXT_HashCodeOnArray(), new HashCodeFix(false, handle).toEditorFix()));
        if (enableDeep) {
            result.add(ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), Bundle.TEXT_HashCodeOnArray(), new HashCodeFix(true, handle).toEditorFix()));
        }
        return result;
    }

    private static final class HashCodeFix
    extends JavaFix {
        private final boolean deep;

        public HashCodeFix(boolean deep, TreePathHandle handle) {
            super(handle);
            this.deep = deep;
        }

        @Override
        protected String getText() {
            return this.deep ? Bundle.FIX_UseArraysDeepHashCode() : Bundle.FIX_UseArraysHashCode();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            Tree t = ctx.getPath().getLeaf();
            if (t.getKind() != Tree.Kind.METHOD_INVOCATION) {
                return;
            }
            MethodInvocationTree mi = (MethodInvocationTree)t;
            if (mi.getMethodSelect().getKind() != Tree.Kind.MEMBER_SELECT) {
                return;
            }
            MemberSelectTree selector = (MemberSelectTree)mi.getMethodSelect();
            TreeMaker maker = ctx.getWorkingCopy().getTreeMaker();
            MemberSelectTree ms = maker.MemberSelect(maker.QualIdent("java.util.Arrays"), this.deep ? "deepHashCode" : "hashCode");
            MethodInvocationTree nue = maker.MethodInvocation(Collections.emptyList(), ms, Collections.singletonList(selector.getExpression()));
            ctx.getWorkingCopy().rewrite(t, nue);
        }
    }
}

