/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.CaseTree;
import jpt.sun.source.tree.ExpressionStatementTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.IfTree;
import jpt.sun.source.tree.InstanceOfTree;
import jpt.sun.source.tree.ParenthesizedTree;
import jpt.sun.source.tree.PatternTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.SwitchTree;
import jpt.sun.source.tree.ThrowTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.Feature;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.MatcherUtilities;

public class ConvertToSwitchPatternInstanceOf {
    public static ErrorDescription trivial(HintContext ctx) {
        if (!Feature.SWITCH_PATTERN.isEnabled(ctx.getInfo())) {
            return null;
        }
        TreePath parent = ctx.getPath().getParentPath();
        if (parent.getLeaf().getKind() == Tree.Kind.IF) {
            return null;
        }
        Tree ifPath = ctx.getPath().getLeaf();
        String expr0 = null;
        expr0 = ctx.getVariables().get("$expr0").getLeaf().toString();
        int matchVarIndex = 1;
        while (ifPath != null && ifPath.getKind() == Tree.Kind.IF) {
            IfTree it = (IfTree)ifPath;
            if (MatcherUtilities.matches(ctx, new TreePath(ctx.getPath(), it.getCondition()), "($expr" + ++matchVarIndex + " instanceof $typeI" + matchVarIndex + ")", true) && MatcherUtilities.matches(ctx, new TreePath(ctx.getPath(), it.getThenStatement()), "{ $typeV" + matchVarIndex + " $var" + matchVarIndex + " = ($typeC" + matchVarIndex + ") $expr" + matchVarIndex + "; $other" + matchVarIndex + "$;}", true)) {
                if (!ctx.getVariables().get("$expr" + matchVarIndex).getLeaf().toString().equals(expr0)) {
                    return null;
                }
                for (TreePath treePath : ctx.getMultiVariables().get("$other" + matchVarIndex + "$")) {
                    if (treePath.getLeaf().getKind() != Tree.Kind.BREAK && treePath.getLeaf().getKind() != Tree.Kind.CONTINUE) continue;
                    return null;
                }
                TypeMirror typeI = ctx.getInfo().getTrees().getTypeMirror(ctx.getVariables().get("$typeI" + matchVarIndex));
                TypeMirror typeMirror = ctx.getInfo().getTrees().getTypeMirror(ctx.getVariables().get("$typeC" + matchVarIndex));
                if (!ctx.getInfo().getTypes().isSameType(typeI, typeMirror)) {
                    System.err.println("different types (" + typeI + ", " + typeMirror + ") in " + ctx.getInfo().getFileObject());
                    return null;
                }
            } else {
                return null;
            }
            ifPath = it.getElseStatement();
        }
        if (ifPath != null && ifPath.getKind() == Tree.Kind.BLOCK) {
            Fix fix = new FixImpl(ctx.getInfo(), ctx.getPath(), true, Collections.emptySet()).toEditorFix();
            return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_ConvertToSwitchPatternInstanceOf(), fix);
        }
        return null;
    }

    public static ErrorDescription patternMatchToSwitch(HintContext ctx) {
        if (!Feature.SWITCH_PATTERN.isEnabled(ctx.getInfo())) {
            return null;
        }
        TreePath parent = ctx.getPath().getParentPath();
        if (parent.getLeaf().getKind() == Tree.Kind.IF) {
            return null;
        }
        Tree ifPath = ctx.getPath().getLeaf();
        String expr0 = null;
        expr0 = ctx.getVariables().get("$expr0").getLeaf().toString();
        int matchVarIndex = 1;
        while (ifPath != null && ifPath.getKind() == Tree.Kind.IF) {
            IfTree it = (IfTree)ifPath;
            if (MatcherUtilities.matches(ctx, new TreePath(ctx.getPath(), it.getCondition()), "($expr" + ++matchVarIndex + " instanceof $typeI" + matchVarIndex + " $var" + matchVarIndex + ")", true) && MatcherUtilities.matches(ctx, new TreePath(ctx.getPath(), it.getThenStatement()), "{ $other" + matchVarIndex + "$;}", true)) {
                if (ctx.getMultiVariables().get("$other" + matchVarIndex + "$").isEmpty()) {
                    return null;
                }
                if (!ctx.getVariables().get("$expr" + matchVarIndex).getLeaf().toString().equals(expr0)) {
                    return null;
                }
                for (TreePath treePath : ctx.getMultiVariables().get("$other" + matchVarIndex + "$")) {
                    if (treePath.getLeaf().getKind() != Tree.Kind.BREAK && treePath.getLeaf().getKind() != Tree.Kind.CONTINUE) continue;
                    return null;
                }
            } else {
                return null;
            }
            ifPath = it.getElseStatement();
        }
        Fix fix = new FixPatternMatchToSwitch(ctx.getInfo(), ctx.getPath(), false, Collections.emptySet()).toEditorFix();
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), Bundle.ERR_ConvertToSwitchPatternInstanceOf(), fix);
    }

    public static ErrorDescription switchPatternMatchToSwitchNull(HintContext ctx) {
        int indexOfSwitch;
        SwitchTree switchTree = (SwitchTree)ctx.getPath().getLeaf();
        if (!ConvertToSwitchPatternInstanceOf.isPatternMatch(switchTree)) {
            return null;
        }
        ExpressionTree expression = ((ParenthesizedTree)switchTree.getExpression()).getExpression();
        Tree parent = ctx.getPath().getParentPath().getLeaf();
        if (parent.getKind() == Tree.Kind.BLOCK) {
            indexOfSwitch = ((BlockTree)parent).getStatements().indexOf(switchTree);
            if (indexOfSwitch < 1) {
                return null;
            }
        } else {
            return null;
        }
        Tree ifTree = ((BlockTree)parent).getStatements().get(indexOfSwitch - 1);
        if (ifTree.getKind() != Tree.Kind.IF || !MatcherUtilities.matches(ctx, new TreePath(ctx.getPath(), ((IfTree)ifTree).getCondition()), "($expr0 == null)", true) || !ctx.getVariables().get("$expr0").getLeaf().toString().equals(expression.toString())) {
            return null;
        }
        Fix fix = new FixSwitchPatternMatchToSwitchNull(ctx.getInfo(), ctx.getPath().getParentPath(), indexOfSwitch).toEditorFix();
        return ErrorDescriptionFactory.forTree(ctx, ifTree, Bundle.ERR_ConvertToSwitchPatternInstanceOf(), fix);
    }

    public static boolean isPatternMatch(Tree node) {
        try {
            return node.getClass().getField("patternSwitch").getBoolean(node);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean isValidCaseTree(Tree tree) {
        return tree instanceof BlockTree || tree instanceof ExpressionStatementTree || tree instanceof ThrowTree;
    }

    private static final class FixImpl
    extends JavaFix {
        private final boolean removeFirst;

        public FixImpl(CompilationInfo info, TreePath main, boolean removeFirst, Set<TreePath> replaceOccurrences) {
            super(info, main);
            this.removeFirst = removeFirst;
        }

        @Override
        protected String getText() {
            return Bundle.FIX_ConvertToSwitchPatternInstanceOf();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath main = ctx.getPath();
            LinkedList<CaseTree> ctl = new LinkedList<CaseTree>();
            Tree ifPath = ctx.getPath().getLeaf();
            int matchVarIndex = 1;
            ArrayList<IfTree> ifTrees = new ArrayList<IfTree>();
            while (ifPath != null && ifPath.getKind() == Tree.Kind.IF) {
                ++matchVarIndex;
                IfTree it = (IfTree)ifPath;
                ifTrees.add(it);
                ifPath = it.getElseStatement();
            }
            InstanceOfTree iot = null;
            for (IfTree ifTree : ifTrees) {
                LinkedList<Tree> caseBindPattern = new LinkedList<Tree>();
                iot = (InstanceOfTree)((ParenthesizedTree)ifTree.getCondition()).getExpression();
                StatementTree bt = ifTree.getThenStatement();
                VariableTree var = (VariableTree)((BlockTree)bt).getStatements().get(0);
                StatementTree thenBlock = this.removeFirst ? wc.getTreeMaker().removeBlockStatement((BlockTree)bt, 0) : bt;
                caseBindPattern.add(wc.getTreeMaker().BindingPattern(wc.getTreeMaker().Variable(wc.getTreeMaker().Modifiers(EnumSet.noneOf(Modifier.class)), var.getName().toString(), iot.getType(), null)));
                BlockTree blockTree = (BlockTree)thenBlock;
                StatementTree statementTree = blockTree.getStatements().size() == 1 && ConvertToSwitchPatternInstanceOf.isValidCaseTree(blockTree.getStatements().get(0)) ? (Tree)blockTree.getStatements().get(0) : thenBlock;
                CaseTree caseMultipleSwitchPatterns = wc.getTreeMaker().CasePatterns(caseBindPattern, statementTree);
                ctl.add(caseMultipleSwitchPatterns);
            }
            BlockTree elseTree = (BlockTree)ifPath;
            if (elseTree == null) {
                elseTree = wc.getTreeMaker().Block(new ArrayList(), false);
            }
            BlockTree defaultTree = elseTree.getStatements().size() == 1 && ConvertToSwitchPatternInstanceOf.isValidCaseTree(elseTree.getStatements().get(0)) ? (Tree)elseTree.getStatements().get(0) : elseTree;
            CaseTree caseMultipleSwitchPatterns = wc.getTreeMaker().Case(Collections.emptyList(), defaultTree);
            ctl.add(caseMultipleSwitchPatterns);
            wc.rewrite((IfTree)main.getLeaf(), wc.getTreeMaker().Switch(iot.getExpression(), ctl));
        }
    }

    private static final class FixPatternMatchToSwitch
    extends JavaFix {
        private final boolean removeFirst;

        public FixPatternMatchToSwitch(CompilationInfo info, TreePath main, boolean removeFirst, Set<TreePath> replaceOccurrences) {
            super(info, main);
            this.removeFirst = removeFirst;
        }

        @Override
        protected String getText() {
            return Bundle.FIX_ConvertToSwitchPatternInstanceOf();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath main = ctx.getPath();
            LinkedList<CaseTree> ctl = new LinkedList<CaseTree>();
            InstanceOfTree iot = null;
            Tree ifPath = ctx.getPath().getLeaf();
            int matchVarIndex = 1;
            ArrayList<Object> ifTrees = new ArrayList<Object>();
            while (ifPath != null && ifPath.getKind() == Tree.Kind.IF) {
                ++matchVarIndex;
                IfTree it = (IfTree)ifPath;
                ifTrees.add(it);
                ifPath = it.getElseStatement();
            }
            for (IfTree ifTree : ifTrees) {
                LinkedList<PatternTree> caseBindPattern = new LinkedList<PatternTree>();
                iot = (InstanceOfTree)((ParenthesizedTree)ifTree.getCondition()).getExpression();
                StatementTree bt = ifTree.getThenStatement();
                StatementTree thenBlock = this.removeFirst ? wc.getTreeMaker().removeBlockStatement((BlockTree)bt, 0) : bt;
                PatternTree pattern = iot.getPattern();
                caseBindPattern.add(pattern);
                BlockTree blockTree = (BlockTree)thenBlock;
                StatementTree statementTree = blockTree.getStatements().size() == 1 && ConvertToSwitchPatternInstanceOf.isValidCaseTree(blockTree.getStatements().get(0)) ? (Tree)blockTree.getStatements().get(0) : thenBlock;
                CaseTree caseMultipleSwitchPatterns = wc.getTreeMaker().CasePatterns(caseBindPattern, statementTree);
                ctl.add(caseMultipleSwitchPatterns);
            }
            BlockTree elseTree = (BlockTree)ifPath;
            if (elseTree == null) {
                elseTree = wc.getTreeMaker().Block(new ArrayList(), false);
            }
            BlockTree blockTree = elseTree.getStatements().size() == 1 && ConvertToSwitchPatternInstanceOf.isValidCaseTree(elseTree.getStatements().get(0)) ? (Tree)elseTree.getStatements().get(0) : elseTree;
            CaseTree casePatterns = wc.getTreeMaker().Case(Collections.emptyList(), blockTree);
            ctl.add(casePatterns);
            wc.rewrite((IfTree)main.getLeaf(), wc.getTreeMaker().Switch(iot.getExpression(), ctl));
        }
    }

    private static final class FixSwitchPatternMatchToSwitchNull
    extends JavaFix {
        private final int indexOfSwitch;

        public FixSwitchPatternMatchToSwitchNull(CompilationInfo info, TreePath path, int indexOfSwitch) {
            super(info, path);
            this.indexOfSwitch = indexOfSwitch;
        }

        @Override
        protected String getText() {
            return Bundle.FIX_ConvertToSwitchPatternInstanceOf();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath main = ctx.getPath();
            TreeMaker make = wc.getTreeMaker();
            LinkedList<IdentifierTree> caseNullLabel = new LinkedList<IdentifierTree>();
            SwitchTree switchTree = (SwitchTree)((BlockTree)main.getLeaf()).getStatements().get(this.indexOfSwitch);
            Tree ifTree = ((BlockTree)main.getLeaf()).getStatements().get(this.indexOfSwitch - 1);
            StatementTree thenStatement = ((IfTree)ifTree).getThenStatement();
            caseNullLabel.add(wc.getTreeMaker().Identifier("null"));
            BlockTree blockTree = (BlockTree)thenStatement;
            BlockTree statementTree = blockTree.getStatements().size() == 1 && ConvertToSwitchPatternInstanceOf.isValidCaseTree(blockTree.getStatements().get(0)) ? (Tree)blockTree.getStatements().get(0) : blockTree;
            CaseTree caseMultipleSwitchPatterns = wc.getTreeMaker().CasePatterns(caseNullLabel, statementTree);
            SwitchTree insertSwitchCase = make.insertSwitchCase(switchTree, 0, caseMultipleSwitchPatterns);
            wc.rewrite(switchTree, insertSwitchCase);
            BlockTree removeBlockStatement = make.removeBlockStatement((BlockTree)main.getLeaf(), this.indexOfSwitch - 1);
            wc.rewrite(main.getLeaf(), removeBlockStatement);
        }
    }
}

