/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.project.ui.ProjectProblemsProviders;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

final class FixPlatform
extends JPanel {
    private static final RequestProcessor WORKER = new RequestProcessor(FixPlatform.class);
    private final String propertName;
    private final String requiredPlatformId;
    private final PropertyEvaluator eval;
    private final AntProjectHelper helper;
    private final BrokenReferencesSupport.PlatformUpdatedCallBack callback;
    private final JButton ok;
    private JButton create;
    private JLabel hint;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel label1;
    private JComboBox<JavaPlatform> platforms;

    FixPlatform(@NonNull String propertyName, @NonNull String requiredPlatformId, @NullAllowed String platformType, @NonNull PropertyEvaluator eval, @NonNull AntProjectHelper helper, @NullAllowed BrokenReferencesSupport.PlatformUpdatedCallBack callback, @NonNull JButton ok) {
        Parameters.notNull("propertyName", propertyName);
        Parameters.notNull("requiredPlatformId", requiredPlatformId);
        Parameters.notNull("eval", eval);
        Parameters.notNull("helper", helper);
        Parameters.notNull("ok", ok);
        this.propertName = propertyName;
        this.requiredPlatformId = requiredPlatformId;
        this.eval = eval;
        this.helper = helper;
        this.callback = callback;
        this.ok = ok;
        this.initComponents();
        ok.setEnabled(false);
        this.platforms.setModel(new PlatformsModel(requiredPlatformId, platformType));
        this.platforms.setRenderer(new PlatformsRenderer());
        this.platforms.addActionListener(ae -> {
            JavaPlatform jp = (JavaPlatform)this.platforms.getSelectedItem();
            ok.setEnabled(jp != null && !jp.getInstallFolders().isEmpty());
        });
    }

    final Future<ProjectProblemsProvider.Result> resolve() {
        JavaPlatform selected = (JavaPlatform)this.platforms.getSelectedItem();
        if (selected == null) {
            return ProjectProblemsProviders.future(ProjectProblemsProvider.Result.create(ProjectProblemsProvider.Status.UNRESOLVED));
        }
        String antName = FixPlatform.getJavaPlatformAntName(selected);
        if (this.requiredPlatformId.equals(antName)) {
            return ProjectProblemsProviders.future(ProjectProblemsProvider.Result.create(ProjectProblemsProvider.Status.RESOLVED));
        }
        return WORKER.submit(() -> ProjectManager.mutex().writeAccess(() -> {
            try {
                EditableProperties ep = this.helper.getProperties("nbproject/project.properties");
                ep.setProperty(this.propertName, antName);
                this.helper.putProperties("nbproject/project.properties", ep);
                if (this.callback != null) {
                    this.callback.platformPropertyUpdated(selected);
                }
                Project p = FileOwnerQuery.getOwner(this.helper.getProjectDirectory());
                ProjectManager.getDefault().saveProject(p);
                return ProjectProblemsProvider.Result.create(ProjectProblemsProvider.Status.RESOLVED);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace(ioe);
                return ProjectProblemsProvider.Result.create(ProjectProblemsProvider.Status.UNRESOLVED);
            }
        }));
    }

    private void initComponents() {
        this.label1 = new JLabel();
        this.jLabel1 = new JLabel();
        this.create = new JButton();
        this.jLabel2 = new JLabel();
        this.platforms = new JComboBox();
        this.hint = new JLabel();
        Mnemonics.setLocalizedText(this.label1, NbBundle.getMessage(FixPlatform.class, "LBL_MissingPlatform", FixPlatform.getHtmlColor(FixPlatform.getErrorForeground()), this.requiredPlatformId));
        Mnemonics.setLocalizedText(this.jLabel1, NbBundle.getMessage(FixPlatform.class, "LBL_CreateNewPlatform"));
        Mnemonics.setLocalizedText(this.create, NbBundle.getMessage(FixPlatform.class, "FixPlatform.create.text"));
        this.create.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixPlatform.this.createActionPerformed(evt);
            }
        });
        this.jLabel2.setLabelFor(this.platforms);
        Mnemonics.setLocalizedText(this.jLabel2, NbBundle.getMessage(FixPlatform.class, "LBL_UseExistingPlatform"));
        Mnemonics.setLocalizedText(this.hint, NbBundle.getMessage(FixPlatform.class, "LBL_PlatformHint", this.requiredPlatformId));
        this.hint.setFocusable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hint, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.label1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.create).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.platforms, 0, -1, Short.MAX_VALUE))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.label1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.create)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.platforms, -2, -1, -2)).addGap(22, 22, 22).addComponent(this.hint).addContainerGap(67, Short.MAX_VALUE)));
    }

    private void createActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer(null);
    }

    private static String getJavaPlatformAntName(@NonNull JavaPlatform jp) {
        return jp.getProperties().get("platform.ant.name");
    }

    @NonNull
    private static Color getErrorForeground() {
        Color result = UIManager.getDefaults().getColor("nb.errorForeground");
        if (result == null) {
            result = Color.RED;
        }
        return result;
    }

    @NonNull
    private static String getHtmlColor(@NonNull Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        StringBuilder result = new StringBuilder();
        result.append("#");
        String rs = Integer.toHexString(r);
        String gs = Integer.toHexString(g);
        String bs = Integer.toHexString(b);
        if (r < 16) {
            result.append('0');
        }
        result.append(rs);
        if (g < 16) {
            result.append('0');
        }
        result.append(gs);
        if (b < 16) {
            result.append('0');
        }
        result.append(bs);
        return result.toString();
    }

    private static final class PlatformsModel
    extends AbstractListModel<JavaPlatform>
    implements ComboBoxModel<JavaPlatform>,
    PropertyChangeListener {
        private final String requiredPlatformId;
        private final String platformType;
        private final JavaPlatformManager pm;
        private final BrokenPlatform broken;
        private JavaPlatform[] platforms;
        private JavaPlatform selected;

        PlatformsModel(@NonNull String requiredPlatformId, @NullAllowed String platformType) {
            Parameters.notNull("requiredPlatformId", requiredPlatformId);
            this.requiredPlatformId = requiredPlatformId;
            this.platformType = platformType;
            this.broken = new BrokenPlatform(requiredPlatformId);
            this.pm = JavaPlatformManager.getDefault();
            this.pm.addPropertyChangeListener(WeakListeners.propertyChange(this, this.pm));
            this.init();
        }

        @Override
        public int getSize() {
            return this.platforms.length;
        }

        @Override
        public JavaPlatform getElementAt(int index) {
            return this.platforms[index];
        }

        private void init() {
            JavaPlatform toSelect;
            ArrayList<BrokenPlatform> newPlatfs = new ArrayList<BrokenPlatform>();
            Arrays.stream(this.pm.getPlatforms(null, new Specification(this.platformType, null))).filter(jp -> !jp.getInstallFolders().isEmpty()).forEach(newPlatfs::add);
            Optional<JavaPlatform> resolved = newPlatfs.stream().filter(jp -> this.requiredPlatformId.equals(FixPlatform.getJavaPlatformAntName(jp))).findAny();
            if (resolved.isPresent()) {
                toSelect = resolved.get();
            } else {
                toSelect = this.broken;
                newPlatfs.add(this.broken);
            }
            newPlatfs.sort((p1, p2) -> {
                if (p1 == this.broken) {
                    return -1;
                }
                if (p2 == this.broken) {
                    return 1;
                }
                return p1.getDisplayName().compareTo(p2.getDisplayName());
            });
            this.platforms = newPlatfs.toArray(new JavaPlatform[0]);
            this.setSelectedItem(toSelect);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selected = (JavaPlatform)anItem;
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent evt) {
            Mutex.EVENT.readAccess(() -> {
                int up = this.platforms == null ? 0 : this.platforms.length;
                this.init();
                up = Math.max(up, this.platforms.length);
                this.fireContentsChanged(this, 0, up);
            });
        }
    }

    private static final class PlatformsRenderer
    extends DefaultListCellRenderer {
        private PlatformsRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(@NonNull JList<?> list, @NonNull Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof JavaPlatform) {
                JavaPlatform jp = (JavaPlatform)value;
                value = jp.getDisplayName();
                if (jp.getInstallFolders().isEmpty()) {
                    value = String.format("<html><font color=\"%s\">%s</font>", FixPlatform.getHtmlColor(FixPlatform.getErrorForeground()), value);
                }
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private static final class BrokenPlatform
    extends JavaPlatform {
        private final String id;

        BrokenPlatform(@NonNull String id) {
            this.id = id;
        }

        @Override
        public String getDisplayName() {
            return this.id;
        }

        @Override
        public Map<String, String> getProperties() {
            return Collections.singletonMap("platform.ant.name", this.id);
        }

        @Override
        public ClassPath getBootstrapLibraries() {
            return ClassPath.EMPTY;
        }

        @Override
        public ClassPath getStandardLibraries() {
            return ClassPath.EMPTY;
        }

        @Override
        public String getVendor() {
            return "";
        }

        @Override
        public Specification getSpecification() {
            return new Specification(null, null);
        }

        @Override
        public Collection<FileObject> getInstallFolders() {
            return Collections.emptySet();
        }

        @Override
        public FileObject findTool(String toolName) {
            return null;
        }

        @Override
        public ClassPath getSourceFolders() {
            return ClassPath.EMPTY;
        }

        @Override
        public List<URL> getJavadocFolders() {
            return Collections.emptyList();
        }
    }
}

