/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.spi.indexing.PathRecognizer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public final class PathRecognizerRegistry {
    private static final Logger LOG = Logger.getLogger(PathRecognizerRegistry.class.getName());
    private static PathRecognizerRegistry instance;
    private final Lookup.Result<? extends PathRecognizer> lookupResult;
    private final LookupListener tracker = new LookupListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resultChanged(LookupEvent ev) {
            LOG.fine("resultChanged: reseting cached PathRecognizers");
            PathRecognizerRegistry pathRecognizerRegistry = PathRecognizerRegistry.this;
            synchronized (pathRecognizerRegistry) {
                PathRecognizerRegistry.this.cachedData = null;
            }
        }
    };
    private Object[] cachedData;

    public static synchronized PathRecognizerRegistry getDefault() {
        if (instance == null) {
            instance = new PathRecognizerRegistry();
        }
        return instance;
    }

    public Set<String> getSourceIds() {
        Object[] data = this.getData();
        return (Set)data[0];
    }

    public Set<String> getLibraryIds() {
        Object[] data = this.getData();
        return (Set)data[1];
    }

    public Set<String> getBinaryLibraryIds() {
        Object[] data = this.getData();
        return (Set)data[2];
    }

    public Set<String> getMimeTypes() {
        Object[] data = this.getData();
        return (Set)data[3];
    }

    public Set<String> getLibraryIdsForSourceId(String id) {
        Object[] data = this.getData();
        Set[] arr = (Set[])((Map)data[4]).get(id);
        return arr != null ? arr[0] : Collections.emptySet();
    }

    public Set<String> getBinaryLibraryIdsForSourceId(String id) {
        Object[] data = this.getData();
        Set[] arr = (Set[])((Map)data[4]).get(id);
        return arr != null ? arr[1] : Collections.emptySet();
    }

    public Set<String> getLibraryIdsForLibraryId(String id) {
        Object[] data = this.getData();
        Set[] arr = (Set[])((Map)data[5]).get(id);
        return arr != null ? arr[0] : Collections.emptySet();
    }

    public Set<String> getBinaryLibraryIdsForLibraryId(String id) {
        Object[] data = this.getData();
        Set[] arr = (Set[])((Map)data[5]).get(id);
        return arr != null ? arr[1] : Collections.emptySet();
    }

    public Set<String> getSourceIdsForBinaryLibraryId(String id) {
        Object[] data = this.getData();
        Set[] arr = (Set[])((Map)data[6]).get(id);
        return arr != null ? arr[0] : Collections.emptySet();
    }

    public Set<String> getMimeTypesForSourceId(String id) {
        Object[] data = this.getData();
        Set[] arr = (Set[])((Map)data[4]).get(id);
        return arr != null ? arr[2] : Collections.emptySet();
    }

    public Set<String> getMimeTypesForLibraryId(String id) {
        Object[] data = this.getData();
        Set[] arr = (Set[])((Map)data[5]).get(id);
        return arr != null ? arr[2] : Collections.emptySet();
    }

    public Set<String> getMimeTypesForBinaryLibraryId(String id) {
        Object[] data = this.getData();
        Set[] arr = (Set[])((Map)data[6]).get(id);
        return arr != null ? arr[2] : Collections.emptySet();
    }

    private PathRecognizerRegistry() {
        this.lookupResult = Lookup.getDefault().lookupResult(PathRecognizer.class);
        this.lookupResult.addLookupListener(WeakListeners.create(LookupListener.class, this.tracker, this.lookupResult));
    }

    private synchronized Object[] getData() {
        if (this.cachedData == null) {
            HashSet<String> sourceIds = new HashSet<String>();
            HashSet<String> libraryIds = new HashSet<String>();
            HashSet<String> binaryLibraryIds = new HashSet<String>();
            HashSet<String> mimeTypes = new HashSet<String>();
            HashMap<String, Set[]> sidsMap = new HashMap<String, Set[]>();
            HashMap<String, Set[]> lidsMap = new HashMap<String, Set[]>();
            HashMap<String, Set[]> blidsMap = new HashMap<String, Set[]>();
            Collection<? extends PathRecognizer> recognizers = this.lookupResult.allInstances();
            for (PathRecognizer pathRecognizer : recognizers) {
                Set[] set;
                Set<String> sids = pathRecognizer.getSourcePathIds();
                Set<String> lids = pathRecognizer.getLibraryPathIds();
                Set<String> blids = pathRecognizer.getBinaryLibraryPathIds();
                Set<String> mts = pathRecognizer.getMimeTypes();
                if (sids != null) {
                    sourceIds.addAll(sids);
                    for (String sid : sids) {
                        if (sidsMap.containsKey(sid)) continue;
                        set = new Set[]{lids == null ? Collections.emptySet() : Collections.unmodifiableSet(lids), blids == null ? Collections.emptySet() : Collections.unmodifiableSet(blids), mts == null ? Collections.emptySet() : Collections.unmodifiableSet(mts)};
                        sidsMap.put(sid, set);
                    }
                }
                if (lids != null) {
                    libraryIds.addAll(lids);
                    for (String lid : lids) {
                        if (lidsMap.containsKey(lid)) continue;
                        set = new Set[]{lids == null ? Collections.emptySet() : Collections.unmodifiableSet(lids), blids == null ? Collections.emptySet() : Collections.unmodifiableSet(blids), mts == null ? Collections.emptySet() : Collections.unmodifiableSet(mts)};
                        lidsMap.put(lid, set);
                    }
                }
                if (blids != null) {
                    binaryLibraryIds.addAll(blids);
                    for (String blid : blids) {
                        if (blidsMap.containsKey(blid)) continue;
                        set = new Set[]{sids == null ? Collections.emptySet() : Collections.unmodifiableSet(sids), lids == null ? Collections.emptySet() : Collections.unmodifiableSet(lids), mts == null ? Collections.emptySet() : Collections.unmodifiableSet(mts)};
                        blidsMap.put(blid, set);
                    }
                }
                if (mts != null) {
                    mimeTypes.addAll(mts);
                }
                LOG.log(Level.FINE, "PathRecognizer {0} supplied sids={1}, lids={2}, blids={3}, mts={4}", new Object[]{pathRecognizer.toString(), sids, lids, blids, mts});
            }
            this.cachedData = new Object[]{Collections.unmodifiableSet(sourceIds), Collections.unmodifiableSet(libraryIds), Collections.unmodifiableSet(binaryLibraryIds), Collections.unmodifiableSet(mimeTypes), Collections.unmodifiableMap(sidsMap), Collections.unmodifiableMap(lidsMap), Collections.unmodifiableMap(blidsMap)};
        }
        return this.cachedData;
    }
}

