/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.project.ui.groups.Bundle;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.GroupsMenu;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ManageGroupsPanel
extends JPanel
implements PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor(ManageGroupsPanel.class.getName());
    static final String NONE_GOUP = "(none)";
    private JList groupList;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JButton propertiesButton;
    private JButton removeAllButton;
    private JButton removeButton;
    private JLabel selectionLabel;

    public ManageGroupsPanel() {
        this.initComponents();
        DefaultListModel<String> model = new DefaultListModel<String>();
        String selectedValue = null;
        for (Group g : Group.allGroups()) {
            model.addElement(g.getName());
            if (!g.equals(Group.getActiveGroup())) continue;
            selectedValue = g.getName();
        }
        model.addElement(NONE_GOUP);
        this.groupList.setModel(model);
        this.groupList.setSelectedValue(selectedValue == null ? NONE_GOUP : selectedValue, true);
        this.groupList.setEnabled(model.getSize() > 0);
        this.groupList.setSelectionMode(2);
        this.groupList.addListSelectionListener(e -> this.firePropertyChange("selection", null, null));
        this.groupList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    RP.post(() -> Group.setActiveGroup(ManageGroupsPanel.this.getSelectedGroups()[0], false));
                    Window w = SwingUtilities.getWindowAncestor(ManageGroupsPanel.this);
                    if (w != null) {
                        w.setVisible(false);
                        w.dispose();
                    }
                }
            }
        });
        boolean isReady = this.isReady();
        boolean isNoneGroupSelected = this.isNoneGroupSelected();
        this.removeButton.setEnabled(isReady && this.isAtLeastOneGroupSelected() && !isNoneGroupSelected);
        this.removeAllButton.setEnabled(isReady && model.getSize() > 1);
        this.propertiesButton.setEnabled(isReady && this.isExactlyOneGroupSelected() && !isNoneGroupSelected);
        this.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("selection")) {
                boolean isNoneGroupSelected1 = this.isNoneGroupSelected();
                this.removeButton.setEnabled(this.isAtLeastOneGroupSelected() && !isNoneGroupSelected1);
                this.removeAllButton.setEnabled(this.groupList.getModel().getSize() > 1);
                this.propertiesButton.setEnabled(this.isExactlyOneGroupSelected() && !isNoneGroupSelected1);
                this.groupList.setEnabled(this.groupList.getModel().getSize() > 0);
            }
        });
    }

    private boolean isReady() {
        ListModel model = this.groupList.getModel();
        return model.getSize() == Group.allGroups().size() + 1;
    }

    private boolean isNoneGroupSelected() {
        Group[] selectedGroups;
        for (Group groupIter : selectedGroups = this.getSelectedGroups()) {
            if (groupIter != null) continue;
            return true;
        }
        return false;
    }

    private boolean isAtLeastOneGroupSelected() {
        return this.groupList.getSelectedValuesList().size() >= 1;
    }

    final boolean isExactlyOneGroupSelected() {
        return this.groupList.getSelectedValuesList().size() == 1;
    }

    Group[] getSelectedGroups() {
        Group[] selection = new Group[this.groupList.getSelectedValuesList().size()];
        for (int i = 0; i < this.groupList.getSelectedValuesList().size(); ++i) {
            String groupName = (String)this.groupList.getSelectedValuesList().get(i);
            for (Group g : Group.allGroups()) {
                if (g.getName().equals(groupName)) {
                    selection[i] = g;
                    continue;
                }
                if (!NONE_GOUP.equals(groupName)) continue;
                selection[i] = null;
            }
        }
        return selection;
    }

    private void removeGroups(Iterable<Group> groups) {
        DefaultListModel model = (DefaultListModel)this.groupList.getModel();
        for (Group groupIter : groups) {
            if (groupIter == null) continue;
            model.removeElement(groupIter.getName());
            RP.post(groupIter::destroy);
        }
    }

    private void initComponents() {
        this.selectionLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.groupList = new JList();
        this.propertiesButton = new JButton();
        this.removeButton = new JButton();
        this.removeAllButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.selectionLabel.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText(this.selectionLabel, NbBundle.getMessage(ManageGroupsPanel.class, "ManageGroupsPanel.selectionLabel.text"));
        this.selectionLabel.setVerticalTextPosition(1);
        this.jScrollPane1.setViewportView(this.groupList);
        Mnemonics.setLocalizedText(this.propertiesButton, NbBundle.getMessage(ManageGroupsPanel.class, "ManageGroupsPanel.propertiesButton.text"));
        this.propertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageGroupsPanel.this.propertiesButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.removeButton, NbBundle.getMessage(ManageGroupsPanel.class, "ManageGroupsPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageGroupsPanel.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.removeAllButton, NbBundle.getMessage(ManageGroupsPanel.class, "ManageGroupsPanel.removeAllButton.text"));
        this.removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManageGroupsPanel.this.removeAllButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 352, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.removeAllButton, -1, 106, Short.MAX_VALUE).addComponent(this.propertiesButton, -1, -1, Short.MAX_VALUE).addComponent(this.removeButton, -1, -1, Short.MAX_VALUE))).addComponent(this.jSeparator2).addGroup(layout.createSequentialGroup().addComponent(this.selectionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.selectionLabel).addComponent(this.jSeparator1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.propertiesButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeAllButton).addGap(0, 101, Short.MAX_VALUE)).addComponent(this.jScrollPane1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2)));
    }

    private void propertiesButtonActionPerformed(ActionEvent evt) {
        Group selectedGroup = this.getSelectedGroups()[0];
        selectedGroup.addChangeListener(this);
        GroupsMenu.openProperties(selectedGroup);
        selectedGroup.removeChangeListener(this);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation(Bundle.ManageGroupsPanel_wrn_remove_selected_groups_msg(), Bundle.ManageGroupsPanel_wrn_remove_selected_groups_title(), 0, 3);
        if (DialogDisplayer.getDefault().notify(d) == NotifyDescriptor.YES_OPTION) {
            this.removeGroups(Arrays.asList(this.getSelectedGroups()));
        }
    }

    private void removeAllButtonActionPerformed(ActionEvent evt) {
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation(Bundle.ManageGroupsPanel_wrn_remove_all_groups_msg(), Bundle.ManageGroupsPanel_wrn_remove_all_groups_title(), 0, 3);
        if (DialogDisplayer.getDefault().notify(d) == NotifyDescriptor.YES_OPTION) {
            this.removeGroups(Group.allGroups());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("groupRename")) {
            String oldGroupName = (String)event.getOldValue();
            String newGroupName = (String)event.getNewValue();
            DefaultListModel model = (DefaultListModel)this.groupList.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                if (!((String)model.getElementAt(i)).equals(oldGroupName)) continue;
                model.setElementAt(newGroupName, i);
            }
        }
    }
}

