/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl.request;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.security.proxied.entity.ProxiedEntityEncoder;
import org.apache.nifi.security.proxied.entity.StandardProxiedEntityEncoder;
import org.apache.nifi.toolkit.client.RequestConfig;

public class ProxiedEntityRequestConfig
implements RequestConfig {
    private static final String PROXIED_ENTITIES_CHAIN_HEADER = "X-ProxiedEntitiesChain";
    private final String[] proxiedEntities;

    public ProxiedEntityRequestConfig(String ... proxiedEntities) {
        this.proxiedEntities = Objects.requireNonNull(proxiedEntities);
    }

    @Override
    public Map<String, String> getHeaders() {
        String proxiedEntitiesValue = this.getProxiedEntitiesValue(this.proxiedEntities);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (proxiedEntitiesValue != null) {
            headers.put(PROXIED_ENTITIES_CHAIN_HEADER, proxiedEntitiesValue);
        }
        return headers;
    }

    private String getProxiedEntitiesValue(String[] proxiedEntities) {
        if (proxiedEntities == null) {
            return null;
        }
        List proxiedEntityChain = Arrays.stream(proxiedEntities).map(arg_0 -> ((ProxiedEntityEncoder)StandardProxiedEntityEncoder.getInstance()).getEncodedEntity(arg_0)).collect(Collectors.toList());
        return StringUtils.join(proxiedEntityChain, (String)"");
    }
}

