/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.processors;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.ProcessorResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.ProcessorClient;
import org.apache.nifi.web.api.entity.ProcessorEntity;

public class ProcessorClearState
extends AbstractNiFiCommand<ProcessorResult> {
    public ProcessorClearState() {
        super("processor-clear-state", ProcessorResult.class);
    }

    @Override
    public String getDescription() {
        return "Clears the state of a processor.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PROC_ID.createOption());
    }

    @Override
    public ProcessorResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String procId = this.getRequiredArg(properties, CommandOption.PROC_ID);
        ProcessorClient processorClient = client.getProcessorClient();
        ProcessorEntity processor = processorClient.getProcessor(procId);
        if (!processor.getComponent().getState().equals("STOPPED")) {
            throw new NiFiClientException("The processor should be STOPPED before clearing its cache.");
        }
        processorClient.clearProcessorState(procId);
        return new ProcessorResult(this.getResultType(properties), processor);
    }
}

