/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.registry;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.RegistryFlowsResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.entity.VersionedFlowsEntity;

public class ListFlows
extends AbstractNiFiCommand<RegistryFlowsResult> {
    public ListFlows() {
        super("list-flows", RegistryFlowsResult.class);
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.REGISTRY_CLIENT_ID.createOption());
        this.addOption(CommandOption.FLOW_BRANCH.createOption());
        this.addOption(CommandOption.BUCKET_ID.createOption());
    }

    @Override
    public String getDescription() {
        return "Returns the list of flows in a given branch and bucket seen by the specified registry client.";
    }

    @Override
    public RegistryFlowsResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String regClientId = this.getRequiredArg(properties, CommandOption.REGISTRY_CLIENT_ID);
        String branchName = this.getRequiredArg(properties, CommandOption.FLOW_BRANCH);
        String bucketId = this.getRequiredArg(properties, CommandOption.BUCKET_ID);
        VersionedFlowsEntity flows = client.getFlowClient().getFlowRegistryFlows(regClientId, branchName, bucketId);
        return new RegistryFlowsResult(this.getResultType(properties), flows);
    }
}

