/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.entity.ReportingTasksEntity;

public class ReportingTasksResult
extends AbstractWritableResult<ReportingTasksEntity> {
    private final ReportingTasksEntity reportingTasksEntity;

    public ReportingTasksResult(ResultType resultType, ReportingTasksEntity reportingTasksEntity) {
        super(resultType);
        this.reportingTasksEntity = Objects.requireNonNull(reportingTasksEntity);
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Set tasksEntities = this.reportingTasksEntity.getReportingTasks();
        if (tasksEntities == null) {
            return;
        }
        List taskDTOS = tasksEntities.stream().map(ReportingTaskEntity::getComponent).sorted(Comparator.comparing(ReportingTaskDTO::getName)).collect(Collectors.toList());
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 5, 40, true).column("ID", 36, 36, false).column("Type", 5, 40, true).column("Run Status", 10, 20, false).build();
        for (int i = 0; i < taskDTOS.size(); ++i) {
            ReportingTaskDTO taskDTO = (ReportingTaskDTO)taskDTOS.get(i);
            String[] typeSplit = taskDTO.getType().split("\\.", -1);
            table.addRow(String.valueOf(i + 1), taskDTO.getName(), taskDTO.getId(), typeSplit[typeSplit.length - 1], taskDTO.getState());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public ReportingTasksEntity getResult() {
        return this.reportingTasksEntity;
    }
}

