/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.TenantDTO;
import org.apache.nifi.web.api.dto.UserDTO;
import org.apache.nifi.web.api.entity.UsersEntity;

public class UsersResult
extends AbstractWritableResult<UsersEntity> {
    private final UsersEntity usersEntity;

    public UsersResult(ResultType resultType, UsersEntity usersEntity) {
        super(resultType);
        this.usersEntity = Objects.requireNonNull(usersEntity);
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Collection userEntities = this.usersEntity.getUsers();
        if (userEntities == null) {
            return;
        }
        List userDTOS = userEntities.stream().map(s -> s.getComponent()).collect(Collectors.toList());
        Collections.sort(userDTOS, Comparator.comparing(TenantDTO::getIdentity));
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 5, 40, false).column("ID", 36, 36, false).column("Member of", 20, 40, true).build();
        for (int i = 0; i < userDTOS.size(); ++i) {
            UserDTO userDTO = (UserDTO)userDTOS.get(i);
            table.addRow(String.valueOf(i + 1), userDTO.getIdentity(), userDTO.getId(), userDTO.getUserGroups().stream().map(u -> u.getComponent().getIdentity()).collect(Collectors.joining(", ")));
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public UsersEntity getResult() {
        return this.usersEntity;
    }
}

