/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.encoding;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(UrlDecoder.class);
    private final boolean decodePlus;
    public static final UrlDecoder QUERY_INSTANCE = new UrlDecoder(true);
    public static final UrlDecoder PATH_INSTANCE = new UrlDecoder(false);

    private UrlDecoder(boolean decodePlus) {
        this.decodePlus = decodePlus;
    }

    public String decode(String s, String enc) {
        Args.notNull(enc, "enc");
        try {
            return this.decode(s, Charset.forName(enc));
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            throw new RuntimeException(new UnsupportedEncodingException(enc));
        }
    }

    public String decode(String source, Charset charset) {
        if (source == null || source.isEmpty()) {
            return source;
        }
        Args.notNull(charset, "charset");
        int length = source.length();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 < length) {
                    char hex1 = source.charAt(i + 1);
                    char hex2 = source.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    if (u != -1 && l != -1) {
                        bos.write((char)((u << 4) + l));
                        i += 2;
                    }
                    changed = true;
                    continue;
                }
                LOG.info("Incomplete trailing escape (%) pattern in '{}'. The escape character (%) will be ignored.", (Object)source);
                changed = true;
                continue;
            }
            if (ch == '+') {
                if (this.decodePlus) {
                    bos.write(32);
                    changed = true;
                    continue;
                }
                bos.write(ch);
                continue;
            }
            bos.write(ch);
        }
        String result = changed ? new String(bos.toByteArray(), charset) : source;
        return result.replace("\u0000", "NULL");
    }
}

