/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.app;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.map.IMap;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.db.dto.room.Whiteboard;
import org.apache.openmeetings.db.dto.room.Whiteboards;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.room.RoomFile;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.manager.IWhiteboardManager;
import org.apache.openmeetings.db.util.ApplicationHelper;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.room.wb.WbAction;
import org.apache.openmeetings.web.room.wb.WbWebSocketHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WhiteboardManager
implements IWhiteboardManager {
    private static final Logger log = LoggerFactory.getLogger(WhiteboardManager.class);
    private final Map<Long, Whiteboards> onlineWbs = new ConcurrentHashMap<Long, Whiteboards>();
    private static final String WBS_KEY = "WBS_KEY";
    @Inject
    private Application app;

    private IMap<Long, Whiteboards> map() {
        return this.app.hazelcast.getMap(WBS_KEY);
    }

    void init() {
        this.map().addEntryListener((MapListener)new WbListener(), true);
        this.map().entrySet().forEach(e -> this.onlineWbs.put((Long)e.getKey(), (Whiteboards)e.getValue()));
    }

    private static String getDefaultName(Long langId, int num) {
        StringBuilder sb = new StringBuilder(LabelDao.getString((String)"615", (long)langId));
        if (num > 0) {
            sb.append(" ").append(num);
        }
        return sb.toString();
    }

    private boolean contains(Long roomId) {
        return this.onlineWbs.containsKey(roomId);
    }

    public void reset(Long roomId, Long userId) {
        if (roomId == null) {
            return;
        }
        try {
            if (this.contains(roomId) && this.map().tryLock((Object)roomId, 1L, TimeUnit.SECONDS)) {
                try {
                    this.onlineWbs.remove(roomId);
                    this.map().delete((Object)roomId);
                }
                finally {
                    this.map().unlock((Object)roomId);
                }
            }
            new Thread(() -> {
                ApplicationHelper.ensureApplication();
                User u = new User();
                u.setId(userId);
                WebSocketHelper.sendRoom((RoomMessage)new RoomMessage(roomId, u, RoomMessage.Type.WB_RELOAD));
            }).start();
        }
        catch (InterruptedException e) {
            log.warn("Unexpected exception while map clean-up", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public Whiteboards get(Long roomId) {
        return this.get(roomId, null);
    }

    private Whiteboards getOrCreate(Long roomId, Consumer<Whiteboards> consumer) {
        if (roomId == null) {
            return null;
        }
        Whiteboards wbs = this.onlineWbs.get(roomId);
        if (wbs == null) {
            wbs = new Whiteboards(roomId);
            if (consumer != null) {
                consumer.accept(wbs);
            }
        }
        return wbs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initFiles(Room r, Long langId, TriConsumer<Whiteboards, Whiteboard, List<RoomFile>> creator) {
        if (!this.contains(r.getId()) && r.getFiles() != null && !r.getFiles().isEmpty() && this.map().tryLock((Object)r.getId())) {
            try {
                this.getOrCreate(r.getId(), wbs -> {
                    r.getFiles().stream().sorted((rf1, rf2) -> (int)(rf1.getWbIdx() - rf2.getWbIdx())).collect(Collectors.groupingBy(RoomFile::getWbIdx)).forEach((wbIdx, fileList) -> {
                        log.trace("WBS init, processing idx {}", wbIdx);
                        Whiteboard wb = WhiteboardManager.add(wbs, langId);
                        wbs.setActiveWb(wb.getId());
                        creator.accept((Whiteboards)wbs, wb, (List<RoomFile>)fileList);
                    });
                    this.update((Whiteboards)wbs);
                });
            }
            finally {
                this.map().unlock((Object)r.getId());
            }
        }
    }

    public Whiteboards get(Long roomId, Long langId) {
        Whiteboards wbs = this.getOrCreate(roomId, inWbs -> {
            if (inWbs.getWhiteboards().isEmpty()) {
                Whiteboard wb = WhiteboardManager.add(inWbs, langId);
                inWbs.setActiveWb(wb.getId());
                this.update((Whiteboards)inWbs);
            }
        });
        if (wbs == null) {
            return null;
        }
        return wbs;
    }

    public Set<Map.Entry<Long, Whiteboard>> list(long roomId) {
        Whiteboards wbs = this.get(roomId);
        return wbs.getWhiteboards().entrySet();
    }

    public Whiteboard add(long roomId, Long langId) {
        Whiteboards wbs = this.get(roomId);
        Whiteboard wb = WhiteboardManager.add(wbs, langId);
        this.update(wbs);
        return wb;
    }

    private static Whiteboard add(Whiteboards wbs, Long langId) {
        Whiteboard wb = new Whiteboard(WhiteboardManager.getDefaultName(langId == null ? OpenmeetingsVariables.getDefaultLang() : langId, wbs.count()));
        wbs.add(wb);
        return wb;
    }

    public Whiteboard clear(long roomId, Long wbId) {
        Whiteboards wbs = this.get(roomId);
        Whiteboard wb = wbs.get(wbId);
        if (wb != null) {
            wb.clear();
            this.update(wbs);
        }
        return wb;
    }

    public void clearAll(Long roomId, long wbId, boolean redo, BiConsumer<Whiteboard, Boolean> addUndo) {
        Whiteboard wb = this.get(roomId).get(Long.valueOf(wbId));
        if (wb == null) {
            return;
        }
        if (addUndo != null) {
            addUndo.accept(wb, redo);
        }
        wb = this.clear(roomId, wbId);
        WbWebSocketHelper.sendWbAll(roomId, WbAction.CLEAR_ALL, new JSONObject().put("wbId", wbId));
        WbWebSocketHelper.sendWbAll(roomId, WbAction.SET_SIZE, wb.getAddJson());
    }

    public void cleanSlide(Long roomId, long wbId, int slide, BiConsumer<Whiteboard, JSONArray> consumer) {
        Whiteboard wb = this.get(roomId).get(Long.valueOf(wbId));
        JSONArray arr = wb.clearSlide(slide);
        if (arr.length() != 0) {
            this.update(roomId, wb);
            if (consumer != null) {
                consumer.accept(wb, arr);
            }
            WbWebSocketHelper.sendWbAll(roomId, WbAction.CLEAR_SLIDE, new JSONObject().put("wbId", wbId).put("slide", slide));
        }
    }

    public Whiteboard remove(long roomId, long wbId, long prevWbId) {
        Whiteboards wbs = this.get(roomId);
        Whiteboard wb = (Whiteboard)wbs.getWhiteboards().remove(wbId);
        if (prevWbId > -1L) {
            wbs.setActiveWb(prevWbId);
        }
        this.update(wbs);
        return wb;
    }

    public void activate(long roomId, Long wbId) {
        Whiteboards wbs = this.get(roomId);
        wbs.setActiveWb(wbId.longValue());
        this.update(wbs);
    }

    public void update(long roomId, Whiteboard wb) {
        Whiteboards wbs = this.get(roomId);
        wbs.update(wb);
        this.update(wbs);
    }

    private void update(Whiteboards wbs) {
        this.onlineWbs.put(wbs.getRoomId(), wbs);
        new Thread(() -> this.map().put((Object)wbs.getRoomId(), (Object)wbs)).start();
    }

    public class WbListener
    implements EntryAddedListener<Long, Whiteboards>,
    EntryUpdatedListener<Long, Whiteboards>,
    EntryRemovedListener<Long, Whiteboards> {
        public void entryAdded(EntryEvent<Long, Whiteboards> event) {
            log.trace("WbListener::Add");
            WhiteboardManager.this.onlineWbs.put((Long)event.getKey(), (Whiteboards)event.getValue());
        }

        public void entryUpdated(EntryEvent<Long, Whiteboards> event) {
            log.trace("WbListener::Update");
            WhiteboardManager.this.onlineWbs.put((Long)event.getKey(), (Whiteboards)event.getValue());
        }

        public void entryRemoved(EntryEvent<Long, Whiteboards> event) {
            log.trace("WbListener::Remove");
            WhiteboardManager.this.onlineWbs.remove(event.getKey());
        }
    }

    @FunctionalInterface
    public static interface TriConsumer<T, U, S> {
        public void accept(T var1, U var2, S var3);
    }
}

