/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.openmeetings.web.user.InviteUserMessageDialog;
import org.apache.openmeetings.web.user.rooms.RoomListPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class InviteUserToRoomDialog
extends Modal<String> {
    private static final long serialVersionUID = 1L;
    private RoomListPanel publicRooms;
    private RoomListPanel privateRooms;
    private final InviteUserMessageDialog inviteMsg = new InviteUserMessageDialog("inviteMsg");
    private Long userId;
    @Inject
    private RoomDao roomDao;
    @Inject
    private UserDao userDao;

    public InviteUserToRoomDialog(String id) {
        super(id);
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("1131"));
        this.addButton((Component)OmModalCloseButton.of());
        Component[] componentArray = new Component[1];
        this.publicRooms = new InviteRoomListPanel("publicRooms", new ArrayList<Room>(), this.getString("1135"));
        componentArray[0] = this.publicRooms;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.privateRooms = new InviteRoomListPanel("privateRooms", new ArrayList<Room>(), this.getString("1135"));
        componentArray2[0] = this.privateRooms;
        this.add(componentArray2);
        this.add(new Component[]{this.inviteMsg});
        super.onInitialize();
    }

    private List<Room> getPrivateRooms(Long userId1, Long userId2, RoomDao roomDao) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        ArrayList<Long> orgIds2 = new ArrayList<Long>();
        for (GroupUser gu : this.userDao.get(userId1).getGroupUsers()) {
            orgIds.add(gu.getGroup().getId());
        }
        for (GroupUser gu : this.userDao.get(userId2).getGroupUsers()) {
            orgIds2.add(gu.getGroup().getId());
        }
        orgIds.retainAll(orgIds2);
        ArrayList<Room> result = new ArrayList<Room>();
        for (Long orgId : orgIds) {
            result.addAll(roomDao.getGroupRooms(orgId.longValue()));
        }
        return result;
    }

    public void show(IPartialPageRequestHandler handler, Long userId) {
        this.userId = userId;
        this.publicRooms.update(handler, this.roomDao.getPublicRooms());
        this.privateRooms.update(handler, this.getPrivateRooms(WebSession.getUserId(), userId, this.roomDao));
        super.show(handler);
    }

    private class InviteRoomListPanel
    extends RoomListPanel {
        private static final long serialVersionUID = 1L;

        public InviteRoomListPanel(String id, List<Room> rooms, String label) {
            super(id, rooms, label);
        }

        @Override
        public void onRoomEnter(AjaxRequestTarget target, Long roomId) {
            InviteUserToRoomDialog.this.inviteMsg.show((IPartialPageRequestHandler)target, roomId, InviteUserToRoomDialog.this.userId);
        }
    }
}

