/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.document.DefaultDocumentFormatRegistry;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.job.AbstractConversionJob;
import org.jodconverter.core.job.AbstractConversionJobWithSourceFormatUnspecified;
import org.jodconverter.core.job.AbstractConverter;
import org.jodconverter.core.job.AbstractSourceDocumentSpecs;
import org.jodconverter.core.job.AbstractTargetDocumentSpecs;
import org.jodconverter.core.job.SourceDocumentSpecs;
import org.jodconverter.core.job.TargetDocumentSpecs;
import org.jodconverter.core.office.InstalledOfficeManagerHolder;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.task.OfficeTask;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.core.util.StringUtils;
import org.jodconverter.local.filter.DefaultFilterChain;
import org.jodconverter.local.filter.Filter;
import org.jodconverter.local.filter.FilterChain;
import org.jodconverter.local.office.ExternalOfficeManager;
import org.jodconverter.local.task.LoadDocumentMode;
import org.jodconverter.local.task.LocalConversionTask;

public final class LocalConverter
extends AbstractConverter {
    public static final boolean DEFAULT_APPLY_DEFAULT_LOAD_PROPS = true;
    public static final boolean DEFAULT_USE_UNSAFE_QUIET_UPDATE = false;
    public static final LoadDocumentMode DEFAULT_LOAD_DOCUMENT_MODE = LoadDocumentMode.AUTO;
    public static final String DEFAULT_LOAD_DOCUMENT_MODE_STRING = "auto";
    public static final Map<String, Object> DEFAULT_LOAD_PROPERTIES;
    private final LoadDocumentMode loadDocumentMode;
    private final Map<String, Object> loadProperties;
    private final Map<String, Object> storeProperties;
    private final FilterChain filterChain;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull LocalConverter make() {
        return LocalConverter.builder().build();
    }

    public static @NonNull LocalConverter make(@NonNull OfficeManager officeManager) {
        return ((Builder)LocalConverter.builder().officeManager(officeManager)).build();
    }

    private LocalConverter(OfficeManager officeManager, DocumentFormatRegistry formatRegistry, LoadDocumentMode loadDocumentMode, Map<String, Object> loadProperties, Map<String, Object> storeProperties, FilterChain filterChain) {
        super(officeManager, formatRegistry);
        this.loadDocumentMode = loadDocumentMode;
        this.loadProperties = loadProperties;
        this.storeProperties = storeProperties;
        this.filterChain = filterChain;
    }

    protected @NonNull AbstractConversionJobWithSourceFormatUnspecified convert(@NonNull AbstractSourceDocumentSpecs source) {
        return new LocalConversionJobWithSourceFormatUnspecified(source);
    }

    static {
        HashMap<String, Comparable<Boolean>> loadProperties = new HashMap<String, Comparable<Boolean>>();
        loadProperties.put("Hidden", Boolean.valueOf(true));
        loadProperties.put("ReadOnly", Boolean.valueOf(true));
        loadProperties.put("UpdateDocMode", Short.valueOf((short)0));
        DEFAULT_LOAD_PROPERTIES = Collections.unmodifiableMap(loadProperties);
    }

    public static final class Builder
    extends AbstractConverter.AbstractConverterBuilder<Builder> {
        private boolean applyDefaultLoadProperties = true;
        private boolean useUnsafeQuietUpdate = false;
        private LoadDocumentMode loadDocumentMode = DEFAULT_LOAD_DOCUMENT_MODE;
        private FilterChain filterChain;
        private Map<String, Object> loadProperties;
        private Map<String, Object> storeProperties;

        private Builder() {
        }

        public @NonNull LocalConverter build() {
            OfficeManager manager = this.officeManager;
            if (manager == null && (manager = InstalledOfficeManagerHolder.getInstance()) == null) {
                throw new IllegalStateException("An office manager is required in order to build a converter.");
            }
            HashMap<String, Object> loadProperties = new HashMap<String, Object>();
            if (this.applyDefaultLoadProperties) {
                loadProperties.putAll(DEFAULT_LOAD_PROPERTIES);
                if (this.useUnsafeQuietUpdate) {
                    loadProperties.put("UpdateDocMode", (short)1);
                }
            }
            if (this.loadProperties != null) {
                loadProperties.putAll(this.loadProperties);
            }
            return new LocalConverter(manager, this.formatRegistry == null ? DefaultDocumentFormatRegistry.getInstance() : this.formatRegistry, this.loadDocumentMode, loadProperties, this.storeProperties, this.filterChain);
        }

        public @NonNull Builder applyDefaultLoadProperties(boolean applyDefaultLoadProperties) {
            this.applyDefaultLoadProperties = applyDefaultLoadProperties;
            return this;
        }

        public @NonNull Builder useUnsafeQuietUpdate(boolean useUnsafeQuietUpdate) {
            this.useUnsafeQuietUpdate = useUnsafeQuietUpdate;
            return this;
        }

        public @NonNull Builder loadDocumentMode(@Nullable LoadDocumentMode loadDocumentMode) {
            if (loadDocumentMode != null) {
                this.loadDocumentMode = loadDocumentMode;
            }
            return this;
        }

        public @NonNull Builder loadDocumentMode(@Nullable String loadDocumentMode) {
            return StringUtils.isBlank((String)loadDocumentMode) ? this : this.loadDocumentMode(LoadDocumentMode.valueOf(loadDocumentMode.toUpperCase()));
        }

        public @NonNull Builder loadProperty(@NonNull String name, @NonNull Object value) {
            AssertUtils.notNull((Object)name, (String)"name must not be null");
            AssertUtils.notNull((Object)value, (String)"value must not be null");
            if (this.loadProperties == null) {
                this.loadProperties = new HashMap<String, Object>();
            }
            this.loadProperties.put(name, value);
            return this;
        }

        public @NonNull Builder loadProperties(@NonNull Map<@NonNull String, @NonNull Object> loadProperties) {
            AssertUtils.notNull(loadProperties, (String)"loadProperties must not be null");
            if (this.loadProperties == null) {
                this.loadProperties = new HashMap<String, Object>();
            }
            this.loadProperties.putAll(loadProperties);
            return this;
        }

        public @NonNull Builder filterChain(Filter ... filters) {
            AssertUtils.notEmpty((Object[])filters, (String)"filters must not be null nor empty");
            this.filterChain = new DefaultFilterChain(filters);
            return this;
        }

        public @NonNull Builder filterChain(@NonNull FilterChain filterChain) {
            AssertUtils.notNull((Object)filterChain, (String)"filterChain must not be null");
            this.filterChain = filterChain;
            return this;
        }

        public @NonNull Builder storeProperty(@NonNull String name, @NonNull Object value) {
            AssertUtils.notNull((Object)name, (String)"name must not be null");
            AssertUtils.notNull((Object)value, (String)"value must not be null");
            if (this.storeProperties == null) {
                this.storeProperties = new HashMap<String, Object>();
            }
            this.storeProperties.put(name, value);
            return this;
        }

        public @NonNull Builder storeProperties(@NonNull Map<@NonNull String, @NonNull Object> storeProperties) {
            AssertUtils.notNull(storeProperties, (String)"storeProperties must not be null");
            if (this.storeProperties == null) {
                this.storeProperties = new HashMap<String, Object>();
            }
            this.storeProperties.putAll(storeProperties);
            return this;
        }
    }

    private class LocalConversionJob
    extends AbstractConversionJob {
        private LocalConversionJob(AbstractSourceDocumentSpecs source, AbstractTargetDocumentSpecs target) {
            super(source, target);
        }

        public void doExecute() throws OfficeException {
            boolean useStreamAdapters = LocalConverter.this.loadDocumentMode == LoadDocumentMode.REMOTE || LocalConverter.this.loadDocumentMode == LoadDocumentMode.AUTO && LocalConverter.this.officeManager instanceof ExternalOfficeManager;
            LocalConversionTask task = new LocalConversionTask((SourceDocumentSpecs)this.source, (TargetDocumentSpecs)this.target, useStreamAdapters, LocalConverter.this.loadProperties, LocalConverter.this.storeProperties, LocalConverter.this.filterChain);
            LocalConverter.this.officeManager.execute((OfficeTask)task);
        }
    }

    private class LocalConversionJobWithSourceFormatUnspecified
    extends AbstractConversionJobWithSourceFormatUnspecified {
        private LocalConversionJobWithSourceFormatUnspecified(AbstractSourceDocumentSpecs source) {
            super(source, LocalConverter.this.officeManager, LocalConverter.this.formatRegistry);
        }

        protected @NonNull AbstractConversionJob to(@NonNull AbstractTargetDocumentSpecs target) {
            return new LocalConversionJob(this.source, target);
        }
    }
}

