/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.util.BeamSearchContextGenerator;
import opennlp.tools.util.Cache;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.SequenceValidator;

public class BeamSearch
implements SequenceClassificationModel {
    public static final String BEAM_SIZE_PARAMETER = "BeamSize";
    private static final Object[] EMPTY_ADDITIONAL_CONTEXT = new Object[0];
    protected final int size;
    protected final MaxentModel model;
    private final double[] probs;
    private Cache<String[], double[]> contextsCache;
    private static final int zeroLog = -100000;

    public BeamSearch(int size, MaxentModel model) {
        this(size, model, 0);
    }

    public BeamSearch(int size, MaxentModel model, int cacheSize) {
        this.size = size;
        this.model = model;
        if (cacheSize > 0) {
            this.contextsCache = new Cache(cacheSize);
        }
        this.probs = new double[model.getNumOutcomes()];
    }

    @Override
    public <T> Sequence[] bestSequences(int numSequences, T[] sequence, Object[] additionalContext, double minSequenceScore, BeamSearchContextGenerator<T> cg, SequenceValidator<T> validator) {
        PriorityQueue<Sequence> prev = new PriorityQueue<Sequence>(this.size);
        PriorityQueue<Sequence> next = new PriorityQueue<Sequence>(this.size);
        prev.add(new Sequence());
        if (additionalContext == null) {
            additionalContext = EMPTY_ADDITIONAL_CONTEXT;
        }
        for (int i = 0; i < sequence.length; ++i) {
            int sz = StrictMath.min(this.size, prev.size());
            for (int sc = 0; prev.size() > 0 && sc < sz; ++sc) {
                Sequence ns;
                String out;
                int p;
                Sequence top = (Sequence)prev.remove();
                List<String> tmpOutcomes = top.getOutcomes();
                String[] outcomes = tmpOutcomes.toArray(new String[0]);
                String[] contexts = cg.getContext(i, sequence, outcomes, additionalContext);
                double[] scores = this.contextsCache != null ? this.contextsCache.computeIfAbsent(contexts, c -> this.model.eval((String[])c, this.probs)) : this.model.eval(contexts, this.probs);
                double[] temp_scores = new double[scores.length];
                System.arraycopy(scores, 0, temp_scores, 0, scores.length);
                Arrays.sort(temp_scores);
                double min = temp_scores[StrictMath.max(0, scores.length - this.size)];
                for (p = 0; p < scores.length; ++p) {
                    if (!(scores[p] >= min) || !validator.validSequence(i, sequence, outcomes, out = this.model.getOutcome(p)) || !((ns = new Sequence(top, out, scores[p])).getScore() > minSequenceScore)) continue;
                    next.add(ns);
                }
                if (next.size() != 0) continue;
                for (p = 0; p < scores.length; ++p) {
                    out = this.model.getOutcome(p);
                    if (!validator.validSequence(i, sequence, outcomes, out) || !((ns = new Sequence(top, out, scores[p])).getScore() > minSequenceScore)) continue;
                    next.add(ns);
                }
            }
            prev.clear();
            PriorityQueue<Sequence> tmp = prev;
            prev = next;
            next = tmp;
        }
        int numSeq = StrictMath.min(numSequences, prev.size());
        Sequence[] topSequences = new Sequence[numSeq];
        for (int seqIndex = 0; seqIndex < numSeq; ++seqIndex) {
            topSequences[seqIndex] = (Sequence)prev.remove();
        }
        return topSequences;
    }

    @Override
    public <T> Sequence[] bestSequences(int numSequences, T[] sequence, Object[] additionalContext, BeamSearchContextGenerator<T> cg, SequenceValidator<T> validator) {
        return this.bestSequences(numSequences, sequence, additionalContext, -100000.0, cg, validator);
    }

    @Override
    public <T> Sequence bestSequence(T[] sequence, Object[] additionalContext, BeamSearchContextGenerator<T> cg, SequenceValidator<T> validator) {
        Sequence[] sequences = this.bestSequences(1, sequence, additionalContext, cg, validator);
        if (sequences.length > 0) {
            return sequences[0];
        }
        return null;
    }

    @Override
    public String[] getOutcomes() {
        String[] outcomes = new String[this.model.getNumOutcomes()];
        for (int i = 0; i < this.model.getNumOutcomes(); ++i) {
            outcomes[i] = this.model.getOutcome(i);
        }
        return outcomes;
    }
}

