/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.io;

import java.io.File;
import java.io.IOException;
import opennlp.tools.ml.maxent.GISModel;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.AbstractModelReader;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.DataReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GISModelReader
extends AbstractModelReader {
    private static final Logger logger = LoggerFactory.getLogger(GISModelReader.class);

    public GISModelReader(File file) throws IOException {
        super(file);
    }

    public GISModelReader(DataReader dataReader) {
        super(dataReader);
    }

    @Override
    public AbstractModel constructModel() throws IOException {
        this.readInt();
        this.readDouble();
        String[] outcomeLabels = this.getOutcomes();
        int[][] outcomePatterns = this.getOutcomePatterns();
        String[] predLabels = this.getPredicates();
        Context[] params = this.getParameters(outcomePatterns);
        return new GISModel(params, predLabels, outcomeLabels);
    }

    @Override
    public void checkModelType() throws IOException {
        String modelType = this.readUTF();
        if (!modelType.equals("GIS")) {
            logger.error("Attempting to load a {} model as a GIS model. You should expect problems.", (Object)modelType);
        }
    }
}

