/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

import java.io.File;
import java.io.IOException;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.AbstractModelReader;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.DataReader;
import opennlp.tools.ml.naivebayes.NaiveBayesModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NaiveBayesModelReader
extends AbstractModelReader {
    private static final Logger logger = LoggerFactory.getLogger(NaiveBayesModelReader.class);

    public NaiveBayesModelReader(File file) throws IOException {
        super(file);
    }

    public NaiveBayesModelReader(DataReader dataReader) {
        super(dataReader);
    }

    @Override
    public AbstractModel constructModel() throws IOException {
        String[] outcomeLabels = this.getOutcomes();
        int[][] outcomePatterns = this.getOutcomePatterns();
        String[] predLabels = this.getPredicates();
        Context[] params = this.getParameters(outcomePatterns);
        return new NaiveBayesModel(params, predLabels, outcomeLabels);
    }

    @Override
    public void checkModelType() throws IOException {
        String modelType = this.readUTF();
        if (!modelType.equals("NaiveBayes")) {
            logger.error("Attempting to load a {} model as a NaiveBayes model. You should expect problems.", (Object)modelType);
        }
    }
}

