/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FSAHeader {
    static final int FSA_MAGIC = 1550218081;
    static final int MAX_HEADER_LENGTH = 12;
    final byte version;

    FSAHeader(byte version) {
        this.version = version;
    }

    public static FSAHeader read(InputStream in) throws IOException {
        if (in.read() != 92 || in.read() != 102 || in.read() != 115 || in.read() != 97) {
            throw new IOException("Invalid file header, probably not an FSA.");
        }
        int version = in.read();
        if (version == -1) {
            throw new IOException("Truncated file, no version number.");
        }
        return new FSAHeader((byte)version);
    }

    public static void write(OutputStream os, byte version) throws IOException {
        os.write(92);
        os.write(23654);
        os.write(6055539);
        os.write(1550218081);
        os.write(version);
    }
}

