/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.utils;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.github.javaparser.utils.CollectionStrategy;
import com.github.javaparser.utils.Log;
import com.github.javaparser.utils.ProjectRoot;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Supplier;

public class SymbolSolverCollectionStrategy
implements CollectionStrategy {
    private final ParserConfiguration parserConfiguration;
    private final CombinedTypeSolver typeSolver = new CombinedTypeSolver(new ReflectionTypeSolver(false));

    public SymbolSolverCollectionStrategy() {
        this(new ParserConfiguration());
    }

    public SymbolSolverCollectionStrategy(ParserConfiguration parserConfiguration) {
        this.parserConfiguration = parserConfiguration;
        if (!parserConfiguration.getSymbolResolver().isPresent()) {
            this.parserConfiguration.setSymbolResolver((SymbolResolver)new JavaSymbolSolver(this.typeSolver));
        }
    }

    public ParserConfiguration getParserConfiguration() {
        return this.parserConfiguration;
    }

    public ProjectRoot collect(Path path) {
        final ProjectRoot projectRoot = new ProjectRoot(path, this.parserConfiguration);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                private Path current_root;
                private Path currentProjectDir;
                private String previousSourceDirectory;
                private final PathMatcher javaMatcher;
                private final PathMatcher jarMatcher;
                {
                    this.javaMatcher = SymbolSolverCollectionStrategy.this.getPathMatcher("glob:**.java");
                    this.jarMatcher = SymbolSolverCollectionStrategy.this.getPathMatcher("glob:**.jar");
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (this.javaMatcher.matches(file)) {
                        String parent = file.getParent().toString();
                        if (!parent.equals(this.previousSourceDirectory)) {
                            Log.info((String)"Trying to compute the source root from %s", (Supplier[])new Supplier[]{() -> file.toString()});
                            this.previousSourceDirectory = parent;
                            this.currentProjectDir = SymbolSolverCollectionStrategy.this.getRoot(file).orElse(null);
                        }
                        if (this.current_root == null || this.currentProjectDir != null && !this.currentProjectDir.equals(this.current_root)) {
                            this.current_root = this.currentProjectDir;
                            if (this.current_root != null) {
                                Log.info((String)"New current source root is %s", (Supplier[])new Supplier[]{() -> this.current_root.toString()});
                            }
                        }
                    } else if (this.jarMatcher.matches(file)) {
                        Log.info((String)"Jar file is found %s", (Supplier[])new Supplier[]{() -> file.toString()});
                        SymbolSolverCollectionStrategy.this.typeSolver.add(new JarTypeSolver(file.toString()));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (Files.isHidden(dir)) {
                        Log.info((String)"Skipping sub-tree %s", (Supplier[])new Supplier[]{() -> dir.toString()});
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (this.current_root != null && Files.isSameFile(dir, this.current_root)) {
                        Log.info((String)"Adding source root %s", (Supplier[])new Supplier[]{() -> dir.toString()});
                        projectRoot.addSourceRoot(dir);
                        SymbolSolverCollectionStrategy.this.typeSolver.add(new JavaParserTypeSolver(this.current_root.toFile(), SymbolSolverCollectionStrategy.this.parserConfiguration));
                        this.current_root = null;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            Log.error((Throwable)e, (String)"Unable to walk %s", (Supplier[])new Supplier[]{() -> path});
        }
        return projectRoot;
    }
}

